      SUBROUTINE GETSUB(NAME)
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                        G E T S U B                             *
C     *                                                                *
C     ******************************************************************
C
*DOC             internal routine, used only by START and END
**DOC
*INDEX  GETSUB(IN/0): internal routine
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       The submitted Parameter NAME is the name of a subroutine
**DOC       which is looked up in SUBLUT. SUBPTR is set on the number
**DOC       of this name in SUBLUT. If NAME doesn't exist in SUBLUT
**DOC       it is appended on the list.
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       NAME   (STR)     Subroutine name
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       SUBPTR       is set on the number of NAME in SUBLUT
**DOC       ENDLUT       will be incremented occasionally
**DOC       SUBLUT(ENDLUT)=NAME  (if NAME hasn't been on the list before)
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       -
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       19.02.87
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       -
**DOC
%include 'field.inc'
*
      CHARACTER*6 NAME
      INTEGER I
*
      DO 100 I=1,ENDLUT
         IF (NAME.EQ.SUBLUT(I)) THEN
            SUBPTR = I
            RETURN
         ENDIF
100   CONTINUE
*
       ENDLUT = ENDLUT + 1
      SUBLUT(ENDLUT) = NAME
      SUBPTR = ENDLUT
      RETURN
      END
