/*******************************************************************************
-----------------------------------------------------------------------------

    ACHTUNG:
    Zur Vermeidung von zu grossen Kompatibilitaetsproblemen duerfen
    Aenderungen in den Strukturdefinitionen nur nach gemeinsamer
    Eroerterung bzw. Einigung zwischen der Cayley- und der Kant-Gruppe
    durchgefuehrt werden.
    Sydney, 25.9.1992             John Cannon, Johannes Gf. Schmettow

-----------------------------------------------------------------------------

    ATTENTION:

    To avoid major problems of incompatibility, changes to the structure
    definitions should only be made after common discussion and agreement
    between the Cayley and Kant groups.

    Sydney, 25/9/1992             John Cannon, Johannes Ct. Schmettow

-----------------------------------------------------------------------------
                   
anf_ceiling.h
   
Header file for ceilings in algebraic number fields.
This file should only be #included by anf.h.
    
A ceiling ("anf_ceiling") is a C-structure which includes two vectors:
  - a real vector containing positive weights for quadratic forms in the field.
    The product of these weights should be unity.
  - an integer exponent vector for maintaining the Fincke method for
    solving norm equations
 
History:
        92-09-17 JS        Move to Cayley V4
        92-06-04 JS        first version

*******************************************************************************/



/*******************************************************************************
/
/  Structure definition for ceilings
/
*******************************************************************************/
 
typedef struct
	{
		t_block_header	trbl_hdr;
 
		vector		lambdas;
		vector		rexps;
	} 	
	anf_ceiling_struct;

 
/*******************************************************************************
/
/   Macros for accessing structure items of ceilings
/
*******************************************************************************/
  
 
/*
    access macro for table element (internal use)
    accessing the lambdas (internal use)
    accessing the rexps (internal use)
*/
  
#define anf_ceiling_access(h)	((anf_ceiling_struct *) mem_access(h))
#define anf_ceiling_lambdas(h)	(anf_ceiling_access(h) -> lambdas)
#define anf_ceiling_rexps(h)	(anf_ceiling_access(h) -> rexps)
 
/*   
    accessing a particular lambda
    accessing a particular exponent
*/        
 
#define anf_ceiling_lambda(h,i)	(vec_entry(anf_ceiling_lambdas(h), i))
#define anf_ceiling_rexp(h,i)	(vec_entry(anf_ceiling_rexps(h), i))
  
 
/*  
    incrementing the reference counter of an ceiling
*/
  
#define anf_ceiling_incref(h)		block_incref(h)
