
#ifndef _FACLST_H_
#define _FACLST_H_

#include "defs.h"

struct factor_type
{
	integer_big	prime;
	t_int	expon;
};

struct fac_hdr
{
	t_block_header		block_header;
	struct factor_type	fheader;
	struct factor_type	factor[VARIABLE_LENGTH];
};

#define	FAC_HDR_LEN	(BLOCK_HEADER_WORDS + sizeof(struct factor_type) )

/* The component prime of fheader contains the number of different prime
 * factors, the component expon of fheader contains the total number of
 * prime divisors.
 */

/*
 * The following gives the number of bh_ints required to store a block
 * containing a factor list of n prime-exponent pairs
 */

#define faclst_required_space(n)	(FAC_HDR_LEN + 2*(n))

/*
Tracked block type for blocks storing factor list - the value of this may be
defined by the calling package, for example, in defs.h or trbl.e which 
are included before this file:
*/

#ifndef FACLST_BLOCK_TYPE

#endif

#define faclst_num_prime(f) ((((struct fac_hdr *)mem_access(f))->fheader).prime)
#define faclst_num_expon(f) ((((struct fac_hdr *)mem_access(f))->fheader).expon)
#define faclst_prime(f,i) ((((struct fac_hdr *)mem_access(f))->factor)[i].prime)
#define faclst_expon(f,i) ((((struct fac_hdr *)mem_access(f))->factor)[i].expon)



/* The next macro takes a faclst f and reduces it to 
 * a faclst able to hold num = number of distinct primes
 */

#define faclst_reduce(f,num) {mem_reduce_words(f, faclst_required_space(num));}

/* The next macro takes a faclst f and extends it to
 * a faclst able to hold num = number of distinct primes
 */

#define faclst_extend(f,num) {mem_extend_words_zero(f, faclst_required_space(num));}

/*
The following is the maximum number of primes the dynamic array can hold
*/

#define faclst_avail_length(h)	( (mem_words(h) - FAC_HDR_LEN )/2 )

/*
The following macro assures that there is enough room for at least req elements
in the sequence with t_handle hdl, by extending it as necessary; if required, at
least minext extra elements will be allocated space
 WARNING!!! - Beware of the "dangling else" problem if used in an if statement
 NOTE:		- Arguments are only evaluated once
*/

#define faclst_assure_space( hdl, req, minext ) \
	{	faclst	h = hdl; \
		faclst_length	r = (req), m = (minext), \
			a = faclst_avail_length(h); \
		if (r > a) \
			mem_extend_words_zero( h, faclst_required_space( (r > (a+m)) ? r : (a+m) ) ); \
	}

#endif /* _FACLST_H_ */
