
#ifndef _SYSTEM_H_
#define _SYSTEM_H_

/*
 *	Files and definitions that Cayley needs from the operating system 
 *	and the C library.
 */

#include <stdio.h>
#include <signal.h>
#include <math.h>
#include <setjmp.h>
#include <ctype.h>

/*	Unix errno stuff */

#ifdef UNIX
#include "errno.h"
extern int errno;
#endif

/*	Timings stuff */

#ifdef VMS
#include <types.h>
struct tbuffer
{
    int proc_user_time;
    int prc_system_time;
    int child_user_time;
    int child_system_time;
};
#else   /* VMS */
#ifdef  AUX

#include <sys/types.h>
#include <sys/times.h>

#else   /* AUX */
#ifdef CADMUS
#define AIXRT
#endif
#ifdef AIXRT
#include <sys/types.h>
#include <sys/times.h>
#else

#include <sys/time.h>
#include <sys/resource.h>

#endif  /* AIXRT */
#endif  /* AUX */
#endif  /* VMS */

/*	varargs - either from <varargs.h> or <stdarg.h> */

#ifdef ANSI_C
#include "stdarg.h"
#else
#include "varargs.h"
#endif

/*
 *	Prototypes
 */

extern char
	*getenv(),
	*strpbrk(),
	*strchr(),
	*strncpy(),
	*strstr();

extern int
	strcasecmp(),
	atoi(),
	fgetc(),
	fprintf(),
	printf(),
	vfprintf(),
	fflush(),
	fclose(),
	read(),
	write();

extern FILE 
	*fopen();

/*
 *	Macros
 */

#define mem_zero_bytes(p,size) \
	bzero((char *)(p), size)

#define mem_zero_ints(p,size) \
	bzero((char *)(p),(int)((size) * sizeof(t_word)))

#endif /* _SYSTEM_H_ */
