#include <LiDIA/rational_factorization.h>

single_factor & single_factor::operator = (const single_factor & x)
{	
single_base = x.single_base;
single_exponent = x.single_exponent;
factor_state = x.factor_state;
return *this;
}



int operator < (const single_factor & a, const single_factor & b)
{
   return (a.single_base < b.single_base);
}

int operator <= (const single_factor & a, const single_factor & b)
{
   return (a.single_base <= b.single_base);
}
   
int operator == (const single_factor & a, const single_factor & b)
{
   return (a.single_base == b.single_base);
}


istream & operator >> (istream &in, single_factor &f)
{
   bigint hb;
   int he;
   char c;
   
   cin >> c;
   
   if (c != '(')
      lidia_error_handler("rational_factorization", "operator>>::( expected");
   else
   {
      cin >> hb >> c;
      if (c != ',')
	 lidia_error_handler("rational_factorization", "operator>>::, expected");
      cin >> he >> c;
      
      while (c != ')')        cin >> c;
   }
   
   if ( !he )
   {
      f.single_exponent = 1;
      f.single_base = 1;
      f.factor_state = prime;
   }
   else
   {
      f.factor_state = dont_know;
      f.single_exponent = he;
      
      if ( hb.is_zero() )    
	 lidia_error_handler("rational_factorization", "factor 0 not allowed");
      
      f.single_base = hb;
   }
   
   return in;
}

ostream & operator << (ostream &out, single_factor &f)
{
   out << "(";
   out << f.single_base;
   out << ",";
   out << f.single_exponent;
   out << ")";
   
   return out;
}


rational_factorization::rational_factorization() 
{
  factors.set_mode(EXPAND);
  isign = 0; info = 0;
  decomp_state = dont_know;
}


rational_factorization::rational_factorization(int n)
{
  factors.set_mode(EXPAND);

  if ( n == 0 )    
    lidia_error_handler("rational_factorization", "factorization of 0 not allowed");
  
  if ( n > 0 )
  {
    isign = 1;
    factors[0].single_base = bigint(n);
  }
  else
  {
    isign = -1;
    factors[0].single_base = bigint(-n);
  }

  decomp_state = dont_know;
  info = 0;

  factors[0].single_exponent = 1;
  factors[0].factor_state = dont_know;
} 
  

rational_factorization::rational_factorization(unsigned int n)
{
  factors.set_mode(EXPAND);

  if ( n == 0 )    
    lidia_error_handler("rational_factorization", "factorization of 0 not allowed");
  
  isign = 1;
  decomp_state = dont_know;

  info = 0;
  factors[0].single_base = bigint((unsigned long)n);
  factors[0].single_exponent = 1;
  factors[0].factor_state = dont_know;
}

 
rational_factorization::rational_factorization(long n)
{
  factors.set_mode(EXPAND);

  if ( n == 0 )    
    lidia_error_handler("rational_factorization", "factorization of 0 not allowed");
  
  if ( n > 0 )
  {
    isign = 1;
    factors[0].single_base = bigint(n);
  }
  else
  {
    isign = -1;
    factors[0].single_base = bigint(-n);
  }

  info = 0;
  decomp_state = dont_know;

  factors[0].single_exponent = 1;
  factors[0].factor_state = dont_know;
} 
  

rational_factorization::rational_factorization(unsigned long n)
{
  factors.set_mode(EXPAND);

  if ( n == 0 )    
    lidia_error_handler("rational_factorization", "factorization of 0 not allowed");
  
  isign = 1;
  decomp_state = dont_know;
  info = 0;

  factors[0].single_base = bigint(n);
  factors[0].single_exponent = 1;
  factors[0].factor_state = dont_know;
} 

  
rational_factorization::rational_factorization(const bigint & n) 
{
  factors.set_mode(EXPAND);

  if ( n.is_zero() )    
    lidia_error_handler("rational_factorization", "factorization of 0 not allowed");
  
  if ( n.is_gt_zero() )
  {
    isign = 1;
    factors[0].single_base = n;
  }
  else
  {
    isign = -1;
    factors[0].single_base = -n;
  }
  
  decomp_state = dont_know;
  info = 0;
  
  factors[0].single_exponent = 1;
  factors[0].factor_state = dont_know;
}


rational_factorization::rational_factorization(const bigrational & n)
{
  factors.set_mode(EXPAND);

  isign = n.sign();
  info = 0;
  decomp_state = dont_know;
  
  factors[0].single_base = n.denominator();
  factors[0].single_exponent = -1;
  factors[0].factor_state = dont_know;

  factors[1].single_base = abs(n.numerator());
  factors[1].single_exponent = 1;
  factors[1].factor_state = dont_know;

  sort();
}
 
 
rational_factorization::rational_factorization(const rational_factorization & f)
{ 
  factors.set_mode(EXPAND);

  factors = f.factors;
  isign = f.isign;
  info = f.info;
  decomp_state = f.decomp_state;
}  


rational_factorization::~rational_factorization()
{
}


rational_factorization & rational_factorization::operator = (const rational_factorization & f)
{ 
  factors = f.factors;
  isign = f.isign;
  info = f.info;
  decomp_state = f.decomp_state;
  return *this;
}  


void rational_factorization::
assign(long n)
{
  if ( n == 0 )    
    lidia_error_handler("rational_factorization", "factorization of 0 not allowed");
  
  if ( n > 0 )
  {
    isign = 1;
    factors[0].single_base = bigint(n);
  }
  else
  {
    isign = -1;
    factors[0].single_base = bigint(-n);
  }

  decomp_state = dont_know;
  info = 0;

  factors[0].single_exponent = 1;
  factors[0].factor_state = dont_know;
} 
  

void rational_factorization::
assign(const bigint &n)
{
  if ( n.is_zero() )    
    lidia_error_handler("rational_factorization", "factorization of 0 not allowed");
  
  factors.set_size(1);
  
  if ( n.is_gt_zero() )
  {
    isign = 1;
    factors[0].single_base = n;
  }
  else
  {
    isign = -1;
    factors[0].single_base = -n;
  }

  decomp_state = dont_know;
  info = 0;
  
  factors[0].single_exponent = 1;
  factors[0].factor_state = dont_know;
}


void rational_factorization::
assign(const bigrational & n)
{
  isign = n.sign();
  info = 0;
  decomp_state = dont_know;
  
  factors[0].single_base = n.denominator();
  factors[0].single_exponent = -1;
  factors[0].factor_state = dont_know;

  factors[1].single_base = abs(n.numerator());
  factors[1].single_exponent = 1;
  factors[1].factor_state = dont_know;

  sort();
}

 
void rational_factorization::
assign(const rational_factorization &f)
{ 
  factors = f.factors;
  isign = f.isign;
  info = f.info;
  decomp_state = f.decomp_state;
}  


bigint  rational_factorization::
base(int index) const
{
  if ( (index < 0) || (index >= no_of_comp()) )
    lidia_error_handler("rational_factorization","base::index out of range");
  
  return bigint(factors[index].single_base);
}


int rational_factorization::
exponent(int index) const
{
  if ( (index < 0) || (index >= no_of_comp()) )
    lidia_error_handler("rational_factorization","exponent::index out of range");
  
  return factors[index].single_exponent;
}


int rational_factorization::
is_prime_factor(int index) 
{
  if ( index < 0 || index >= no_of_comp() )
    lidia_error_handler("rational_factorization","is_prime_factor::index out of range");

  if ( state(factors[index].factor_state) == prime )
    return 1;
    
  if ( state(factors[index].factor_state) == not_prime )
    return 0;
    
  if ( is_prime( factors[index].single_base, 8 ) )
  {
    factors[index].factor_state = prime;
    return 1;
  }
  else
  {
    factors[index].factor_state = not_prime;
    return 0;
  }
}


int rational_factorization::
is_prime_factorization()  
{

  if ( decomp_state == prime )
    return 1;

  for (int i = no_of_comp()-1; i >= 0; i--)
  {
    if ( state(factors[i].factor_state) == not_prime )
    {
      decomp_state = not_prime;
      return 0;
    }
    
    if ( state(factors[i].factor_state) == dont_know )
    {
      if ( is_prime( factors[i].single_base, 8 ) )
	factors[i].factor_state = prime;
      else
      {
	decomp_state = not_prime;
	factors[i].factor_state = not_prime;
	return 0;
      }
    }
  }
  
  decomp_state = prime;
  return 1;
}


void rational_factorization::
compose()
{
  int i, j = 0;
  int len = no_of_comp() - 1;  

  sort();
  
  for( i = 0; i < len ; i++)
  {
     j = i+1;
    while ( (j <= len) && (factors[i].single_base == factors[j].single_base) )
    {
      factors[i].single_exponent += factors[j].single_exponent;
      j++;
    }
        
    if ( (j = j - i - 1) > 0 )
    {
      factors.remove_from(i+1, j);
      len = no_of_comp() - 1;
    }
    if (factors[i].single_exponent == 0 || factors[i].single_base.is_one())
    {
       factors.remove_from(i);
       len --;
    }
 } 
 
  if (no_of_comp() == 0)
  { 
     factors[0].single_base.assign(1);
     factors[0].single_exponent = 1;
     factors[0].factor_state = prime;
     isign = 1;
     decomp_state = prime;
  }
}


istream & operator >> (istream & in, rational_factorization & f)
{
  int sg = 1, n = 0;
  char c;

  f.decomp_state = dont_know;
  
  in >> c;

  if (c != '[')
    lidia_error_handler("rational_factorization", "operator>>::[ expected");

  in >> c;

  while (c != ']')
  {
    in.putback(c);

    cin >> f.factors[n];
    
    n++;
    
    in >> c;
  }
  
  for ( int i = 0; i < n; i++)
  {  
    if ( f.factors[i].single_base.is_lt_zero() )
    {
      if ( f.factors[i].single_exponent & 1 )
	sg = -sg;
      f.factors[i].single_base.negate();
    }
    
    if ( (f.factors[i].single_base).is_one() )
    {
      f.factors.remove_from(i);
      n--;
      i--;
    }
  }
  
  f.isign = sg;
  
  f.compose();

  return in;
}


ostream & operator << (ostream & out, rational_factorization & f)
{
  int sz = f.no_of_comp();

  out << "  [";  
  
  if (f.isign == -1)
  out << "(-1,1)";
   
  for (int i = 0; i < sz; i++)
    out << f.factors[i];

  out << "]";
  
  return out;
}


void rational_factorization::
invert()
{
int len = no_of_comp();

for (int i=0; i< len; i++)
  factors[i].single_exponent = - factors[i].single_exponent;
}

void rational_factorization::
square()
{
int len = no_of_comp();

for (int i=0; i< len; i++)
  factors[i].single_exponent <<= 1;
}


void multiply(rational_factorization & f, 
	      const rational_factorization & a, 
	      const rational_factorization & b)
{
f.factors.concat(a.factors, b.factors);

if (a.decomp_state == dont_know || b.decomp_state == dont_know)
  f.decomp_state = dont_know;
else 
  if (a.decomp_state == not_prime || b.decomp_state == not_prime)
    f.decomp_state = not_prime;
  else f.decomp_state = prime;

f.isign = a.isign * b.isign;   
f.compose();   
}


void divide(rational_factorization & f, 
	    const rational_factorization & a, 
	    const rational_factorization & b)
{
int len = b.no_of_comp();

f = b;
f.invert();
f.factors.concat(a.factors, f.factors);

if (a.decomp_state == dont_know || b.decomp_state == dont_know)
  f.decomp_state = dont_know;
else 
  if (a.decomp_state == not_prime || b.decomp_state == not_prime)
    f.decomp_state = not_prime;
  else f.decomp_state = prime;

f.isign = a.isign * b.isign;   
f.compose();   
}


void rational_factorization::
refine()
{
   int i = 0, j, last_index = no_of_comp();
   single_factor sf;
   bigint q, r;
   
   while( i < last_index-1)
   {
      sf.single_base = gcd(factors[i].single_base, factors[i+1].single_base);
      
      if (sf.single_base.is_one())
            i++;
      else 
      {  
	 div_rem(factors[i].single_base, r, factors[i].single_base, sf.single_base);
	 j = 0;
	 while (r.is_zero())
	 {
	    div_rem(q, r, factors[i].single_base, sf.single_base);  
	    if (r.is_zero())
	      factors[i].single_base.assign(q);
	    j++;
	 }
	 sf.single_exponent = j * exponent(i);
	 
	 div_rem(factors[i+1].single_base, r, factors[i+1].single_base, sf.single_base);
	 j = 0;
	 while (r.is_zero())
	 {
	    div_rem(q, r, factors[i+1].single_base, sf.single_base);  
	    if (r.is_zero())
	      factors[i+1].single_base.assign(q);
	    j++;
	 }
	 sf.single_exponent += j * exponent(i+1);

	 if (is_prime(factors[i].single_base, 8))
	     factors[i].factor_state = prime;
	 else factors[i].factor_state = not_prime;

	 if (is_prime(factors[i+1].single_base, 8))
	     factors[i+1].factor_state = prime;
	 else factors[i+1].factor_state = not_prime;


	 if (sf.single_exponent != 0)
	 {
	    if (is_prime(sf.single_base,8))
	      sf.factor_state = prime;
	    else sf.factor_state = not_prime;
	     
	    if (factors[i+1].single_base.is_one())
	      factors[i+1] = sf;
	    else
	    {
	       factors[last_index] = factors[i+1];
	       factors[i+1] = sf;
	    }
	 }
      }
   }
compose();
}


void rational_factorization::
refine(const bigint & x)
{
int i, len = no_of_comp(), e = 0, e_akt;
bigint old, n, res;

for (i=0; i< len; i++)
  {
     e_akt = 0;
     old = base(i);
     div_rem(n, res, old, x);
     while(res.is_zero())
     {
	e_akt++;
	old.assign(n);
	div_rem(n, res, old, x);
     }
     if (e_akt > 0)
        { 
	   factors[i].single_base.assign(old);
	   e += e_akt * exponent(i);
	}
  }

if (e == 0)
  lidia_error_handler("rational_factorization","refine::input no refinement");
else
   {
     single_factor sf;
     
     sf.single_base = x;
     sf.single_exponent = e;
     
     if (is_prime(x,8))
        sf.factor_state = prime;
     else sf.factor_state = not_prime;

     factors[len] = sf;
     compose();
  }
}

void rational_factorization::
refine_comp (int index, const bigint &x)
{
int e = 0;
bigint old, n, res;

if ( (index < 0) || (index >= no_of_comp()) )
    lidia_error_handler("rational_factorization", "refine_comp::index out of range");

old = base(index);
div_rem(n, res, old, x);
while(res.is_zero())
     {
	e++;
	old.assign(n);
	div_rem(n, res, old, x);
     }

if (e == 0)
  lidia_error_handler("rational_factorization","refine_comp::input no refinement");
else
   { 
     single_factor sf;

     factors[index].single_base = old; 

     sf.single_base = x;
     sf.single_exponent = e * exponent(index);
     
     if (is_prime(x,8))
        sf.factor_state = prime;
     else sf.factor_state = not_prime;

     factors[no_of_comp()] = sf;
     compose();
  }
}


int operator == (const rational_factorization & a, 
		 const rational_factorization & b)
{
rational_factorization f; 

divide(f, a, b);
f.refine();

if (f.no_of_comp() == 1 && f.base(0).is_one() && f.isign == 1)
  return 1;
else return 0;
}




void rational_factorization::
factor_comp(int index, int upper_bound)
{
  int D, job_buffer[30][5];
  int strategy[30], strat_help[30];
  int jobs_avail, k; 
  
  if ( (index < 0) || (index >= no_of_comp()) )
    lidia_error_handler("rational_factorization", "factor_comp::index out of range");

  if (is_prime_factor(index))
    {
      if (info) 
	cout << "prime number " << factors[index].single_base << "\n";
    return;
    }
    
  if ( upper_bound > 34 )
      lidia_error_handler("rational_factorization", "factor_comp::incorrect parameters");
 
  int n = ( factors[index].single_base.bit_length() / 3 ) + 10;

// check whether base[index] is an exact power

  bigint N; 

  k = (int)power_test(N, factors[index].single_base);

  if (k != -1)
    {
    factors[index].single_base.assign(N);
    factors[index].single_exponent *= k;
    if (is_prime(N, 8))
      {
	factors[index].factor_state = prime;
	compose();
	return;
      }
    else
      factors[index].factor_state = not_prime;
  }

// try to factor component
 
  if (upper_bound == 34) 
    {
      char *n_string;
      n_string = new char[n];
      upper_bound = ( bigint_to_string(factors[index].single_base, n_string) >>
1 ) + 1;
      delete [] n_string;
      if (upper_bound > 34)  upper_bound = 34;
      if (upper_bound < 6) upper_bound = 6;
   }

  D = ecm_read_max(upper_bound);
  
  if ( D < 1000000 )   D = 1000000;

  ecm_primes prim(1, D+200, 200000); 
  
  k = 0;
  n = 6;                    // lower_bound = 6
     
  while ( n < upper_bound )
   {
      strategy[k++] = n;
      n += 3;
   }

   strategy[k] = upper_bound;
   strategy[k+1] = 0;
 
  trialdiv(index, 1, 1000000, prim); 
  
  if ( !(state(factors[index].factor_state) == prime) )
    {  
      if (info) 
	{
	  cout << "Strategy for ECM : \n";
	  cout.flush();
	}
      
      jobs_avail = ecm_job_planing(strategy, job_buffer);
      
      ecm(index, jobs_avail, job_buffer, prim);
    }

  compose();
}



void rational_factorization::
factor(int upper_bound)
{
  if ( is_prime_factorization() )
     return;
  if ( upper_bound > 34 )
      lidia_error_handler("rational_factorization", "factor::incorrect parameters");
 
  int D, job_buffer[30][5];
  int strategy[30];
  int jobs_avail, index, k = no_of_comp(), s, do_sort = 0;
  bigint N;



  for (index = 0; index < k; index ++)
    {
      if (info)
      	cout<<"\n index = "<<index;
      if (is_prime_factor(index))
	  continue;
      else
	  {
      	    if (info)
            	cout<<"\n factors[index] = "<<factors[index].single_base;
	    s = (int)power_test(N, factors[index].single_base);
            if (info)
           	cout<<" power_test = "<<s;
	    if (s != -1)
	      {
		do_sort = 1;
		factors[index].single_base.assign(N);
		factors[index].single_exponent *= s;
		if (is_prime(N, 8))
		  factors[index].factor_state = prime;
		else
		  factors[index].factor_state = not_prime;
	      }
	  }
    }
  if (do_sort)
    sort();

  if (is_prime_factorization())
    return;
  
  N.assign(factors[k-1].single_base);
  int n = ( N.bit_length() / 3 ) + 10;

  if (upper_bound == 34)
    {
      char *n_string = new char[n];
      upper_bound = ( bigint_to_string(N, n_string) >> 1 ) + 1;
      delete [] n_string;
      if (upper_bound > 34) upper_bound = 34;
    }
  
  if (upper_bound < 6) upper_bound = 6;

  D = ecm_read_max(upper_bound);
  
  if ( D < 1000000 )   D = 1000000;

  ecm_primes prim(1, D+200, 200000); 
  
  k = 0;
  n = 6;                // lower_bound = 6
  
  while ( n < upper_bound )
   {
      strategy[k++] = n;
      n += 3;
   }

  strategy[k] = upper_bound;
  strategy[k+1] = 0;
 
  if (info) 
  { cout << "Strategy for ECM : \n"; cout.flush(); }
  
  jobs_avail = ecm_job_planing(strategy, job_buffer);
  
  k = no_of_comp();
  
  for ( index = 0; index < k; index++)
  {
    if ( info )
    {
      cout << "\nworking on index " << index;
      cout << "\n==================\n";
    }

    N.assign(factors[index].single_base);

    
    if ( state(factors[index].factor_state) == prime )
    {
      if (info) 
          cout << "prime number " << N << "\n";
      break;
    }
    
    if ( state(factors[index].factor_state) == dont_know )
    {
      if ( is_prime(N, 8) )
      {
        if (info) 
          cout << "prime number " << N << "\n";

        factors[index].factor_state = prime;
	continue;
      }
      else
        factors[index].factor_state = not_prime;
    }

    trialdiv(index, 1, 1000000, prim);

    if ( !(state(factors[index].factor_state) == prime) )
    {
      if ( info ) 
	 cout << "ECM ";
  
      ecm(index, jobs_avail, job_buffer, prim);

    }
  }
  
  compose();

  if (is_prime_factorization())
    return;
  
  int trials = 0;
  
  k = no_of_comp();

  for (index = 0; index < k; index++)
  {
     if ( state(factors[index].factor_state) == not_prime )
     {
       N.assign( factors[index].single_base);
       
       if (info)
	   cout << "index " << index << " not prime: to factor " << N << "\n"; 

	for (n = 0; n < jobs_avail; n++)
	   job_buffer[n][3] = job_buffer[n][4];

	ecm(index, jobs_avail, job_buffer, prim);
       	compose();

       if (N == factors[index].single_base)  
	 trials ++;
       else trials = 0;
       k = no_of_comp();
       index = -1;
       
       if (trials >= 2) return;
     }     
   }
}













