/****************************/
/* Application Test Routine */
/*                          */
/* Version 1.61             */
/* author: Patrick Theobald */
/****************************/

#include <LiDIA/bigint_matrix.h>

main()
{
  ofstream dz("bigint_matrix_appl.out");

  int i, j;

  /* scalar */
  bigint s1;
  bigint s2 = 4;
  bigint s3 = 3;

  /* array */
  bigint **Wertebigint = new bigint *[2];
  for (i = 0; i < 2; i++)
  {
    Wertebigint[i] = new bigint[3];
    for (j = 0; j < 3; j++)
      Wertebigint[i][j].assign(j * (i + 1));
  }
  long **Werteint = new long *[4];
  for (i = 0; i < 4; i++)
  {
    Werteint[i] = new long[2];
    for (j = 0; j < 2; j++)
      Werteint[i][j] = i + j;
  }

  int m1, m2;

  cout << "****************************************************\n" << flush;
  cout << "***             Test for bigint_matrix           ***\n" << flush;
  cout << "****************************************************\n" << flush;

  cout << "\ntesting constructors" << flush;
  dz << "constructor\n" << flush;
  bigint_matrix A;
  dz << A << flush;
  bigint_matrix B(3);
  dz << B << flush;
  bigint_matrix C(2, 3);
  dz << C << flush;
  bigint_matrix D(2, 3, Wertebigint);
  dz << D << flush;
  {
    bigint_matrix E(4, 2, (long **) Werteint);
    dz << E << flush;
    bigint_matrix F(C);
    dz << F << flush;
  }
  cout << "........................completed\n" << flush;

  ifstream dz1("bigint_matrix_appl.1");
  ifstream dz2("bigint_matrix_appl.2");
  ifstream dz3("bigint_matrix_appl.3");

  cout << "testing read_from_stream" << flush;
  dz << "read_from_fstream\n" << flush;
  A.read_from_stream(dz1);
  B.read_from_stream(dz2);
  C.read_from_stream(dz3);
  dz << A << flush;
  dz << B << flush;
  dz << C << flush;
  dz1.close();
  dz2.close();
  dz3.close();
  bigint_matrix Z5 = A;
  cout << "....................completed\n" << flush;

  cout << "testing addition" << flush;
  dz << "addition\n" << flush;
  A += B;
  dz << A << flush;
  add(A, A, B);
  dz << A << flush;
  bigint_matrix ADD = A + B;
  dz << ADD << flush;
  add(ADD, A, B);
  dz << ADD << flush;
  cout << "............................completed\n" << flush;

  cout << "testing subtraction" << flush;
  dz << "subtraction\n" << flush;
  A -= B;
  dz << A << flush;
  subtract(A, A, B);
  dz << A << flush;
  ADD = A - B;
  dz << ADD << flush;
  subtract(ADD, A, B);
  dz << ADD << flush;
  cout << ".........................completed\n" << flush;

  cout << "testing negate" << flush;
  dz << "negate\n" << flush;
  ADD = -A;
  dz << ADD << flush;
  negate(ADD,A);
  dz << ADD << flush;
  cout << "..............................completed\n" << flush;

  cout << "testing multiplication" << flush;
  dz << "multiplication\n" << flush;
  bigint_matrix E = A, F = A;
  E *= C;
  dz << E << flush;
  E = A * C;
  dz << E << flush;
  multiply(F, A, C);
  dz << F << flush;
  cout << "......................completed\n" << flush;

  cout << "testing member" << flush;
  dz << "member\n" << flush;
  s1 = A.member(2, 1);
  dz << s1 << "\n" << flush;
  cout << "..............................completed\n" << flush;

  cout << "testing get_no_of_columns" << flush;
  dz << "get_no_of_columns\n" << flush;
  m1 = (int)A.get_no_of_columns();
  dz << m1 << "\n" << flush;
  cout << "...................completed\n" << flush;

  cout << "testing get_no_of_rows" << flush;
  dz << "get_no_of_rows\n" << flush;
  m2 = (int)A.get_no_of_rows();
  dz << m2 << "\n" << flush;
  cout << "......................completed\n" << flush;

  cout << "testing assign" << flush;
  dz << "assign\n" << flush;
  bigint_matrix G(F.get_no_of_rows(), F.get_no_of_columns());
  G = F;
  dz << F << flush;
  F.assign(G);
  dz << G << flush;
  assign(F, G);
  dz << F << flush;
  cout << "..............................completed\n" << flush;

  cout << "testing write_to_stream" << flush;
  dz << "write_to_stream\n" << flush;
  F.write_to_stream(dz);
  F.write_to_stream(dz);
  cout << ".....................completed\n" << flush;

  cout << "testing trans" << flush;
  bigint_matrix H = trans(G);
  dz << H << flush;
  H = F.trans();
  dz << H << flush;
  cout << "...............................completed\n" << flush;

  cout << "testing equal / unequal" << flush;
  dz << "equal/unequal\n" << flush;
  dz << (F == G) << "\n" << flush;
  dz << F.equal(G) << "\n" << flush;
  dz << equal(F, G) << "\n" << flush;
  dz << (F != G) << "\n" << flush;
  dz << F.unequal(G) << "\n" << flush;
  dz << unequal(F, G) << "\n" << flush;
  cout << ".....................completed\n" << flush;

  cout << "testing lininr" << flush;
  dz << "lininr\n" << flush;
  long *q = lininr(F);
  for (i = 0; i <= q[0]; i++)
    dz << q[i] << "\n" << flush;
  delete[] q;
  cout << "..............................completed\n" << flush;

  cout << "testing lininc" << flush;
  dz << "lininc\n" << flush;
  long *q1 = lininc(F);
  for (i = 0; i <= q1[0]; i++)
    dz << q1[i] << "\n" << flush;
  delete[] q1;
  cout << "..............................completed\n" << flush;

  cout << "testing rank" << flush;
  dz << "rank\n" << flush;
  dz << rank(F) << "\n" << flush;
  cout << "................................completed\n" << flush;

  cout << "testing kernel" << flush;
  dz << "kernel\n" << flush;
  bigint_matrix K = A;
  bigint_matrix PAT = A;
  bigint_matrix I = kernel(A);
  dz << I << flush;
  cout << "..............................completed\n" << flush;

  cout << "testing image" << flush;
  dz << "image\n" << flush;
  bigint_matrix J = image(K);
  dz << J << flush;
  cout << "...............................completed\n" << flush;

  cout << "testing addition with scalar" << flush;
  dz << "addition\n" << flush;
  A += s1;
  dz << A << flush;
  ADD = A + s1;
  dz << ADD << flush;
  add(ADD, A, s1);
  dz << ADD << flush;
  cout << "................completed\n" << flush;

  cout << "testing subtraction with scalar" << flush;
  dz << "subtraction\n" << flush;
  A -= s1;
  dz << A << flush;
  ADD = A - s1;
  dz << ADD << flush;
  subtract(ADD, A, s1);
  dz << ADD << flush;
  cout << ".............completed\n" << flush;

  cout << "testing multiplication with scalar" << flush;
  dz << "multiplication\n" << flush;
  ADD = A;
  ADD *= s3;
  dz << ADD << flush;
  ADD = A * s3;
  dz << ADD << flush;
  multiply(ADD, A, s3);
  dz << ADD << flush;
  cout << "..........completed\n" << flush;

  cout << "testing remainder" << flush;
  dz << "remainder\n" << flush;
  bigint_matrix D1 = A;
  D1 %= 13;
  dz << D1 << flush;
  D1 = A % 13;
  dz << D1 << flush;
  bigint ewr = 3;
  remainder(D1, A, ewr);
  dz << D1 << flush;
  cout << "...........................completed\n" << flush;

  cout << "testing multiplication with array" << flush;
  dz << "multiplication\n" << flush;
  bigint *vr, *v1;
  v1 = new bigint[6];
  vr = new bigint[4];
  for (i = 0; i < 6; i++)
    v1[i] = bigint(i);
  vr = A * v1;
  for (i = 0; i < 4; i++)
    dz << vr[i] << "\n" << flush;
  multiply(vr, A, v1);
  for (i = 0; i < 4; i++)
    dz << vr[i] << "\n" << flush;
  cout << "...........completed\n" << flush;

  cout << "testing set_no_of_columns" << flush;
  dz << "set_no_of_columns\n" << flush;
  E.set_no_of_columns(3);
  dz << E << flush;
  cout << "...................completed\n" << flush;

  cout << "testing set_no_of_rows" << flush;
  dz << "set_no_of_rows\n" << flush;
  E.set_no_of_rows(3);
  dz << E << flush;
  cout << "......................completed\n" << flush;

  cout << "testing column" << flush;
  dz << "column\n" << flush;
  bigint *c1;
  c1 = A(2);
  for (i = 0; i < 4; i++)
    dz << c1[i] << "\n" << flush;
  c1 = A.column(3);
  for (i = 0; i < 4; i++)
    dz << c1[i] << "\n" << flush;
  cout << "..............................completed\n" << flush;

  cout << "testing row" << flush;
  dz << "row\n" << flush;
  bigint *c2;
  c2 = A[0];
  for (i = 0; i < 6; i++)
    dz << c2[i] << "\n" << flush;
  c2 = A.row(1);
  for (i = 0; i < 6; i++)
    dz << c2[i] << "\n" << flush;
  cout << ".................................completed\n" << flush;

  cout << "testing sto" << flush;
  dz << "sto\n" << flush;
  E.sto(2, 0, 23);
  dz << E << flush;
  cout << ".................................completed\n" << flush;

  cout << "testing sto_column" << flush;
  dz << "sto_column\n" << flush;
  ADD = A;
  ADD.sto_column(c1, 3, 0);
  dz << ADD << flush;
  cout << "..........................completed\n" << flush;

  cout << "testing sto_row" << flush;
  dz << "sto_row\n" << flush;
  ADD = A;
  ADD.sto_row(c2, 4, 0);
  dz << ADD << flush;
  cout << ".............................completed\n" << flush;

  cout << "testing swap_columns" << flush;
  dz << "swap_columns\n" << flush;
  ADD = A;
  ADD.swap_columns(0, 5);
  dz << ADD << flush;
  cout << "........................completed\n" << flush;

  cout << "testing swap_rows" << flush;
  dz << "swap_rows\n" << flush;
  ADD = A;
  ADD.swap_rows(3, 0);
  dz << ADD << flush;
  cout << "...........................completed\n" << flush;

  cout << "testing divide" << flush;
  dz << "divide\n" << flush;
  bigint_matrix Part1(2, 4), Part2(3, 2), Part3(2, 4), Part4(1, 2);
  A.divide(Part1, Part2, Part3, Part4);
  dz << Part1 << Part2 << Part3 << Part4 << flush;
  cout << "..............................completed\n" << flush;

  cout << "testing divide_h" << flush;
  dz << "divide_h\n" << flush;
  bigint_matrix Part5(4, 4), Part6(4, 2);
  A.divide_h(Part5, Part6);
  dz << Part5 << Part6 << flush;
  cout << "............................completed\n" << flush;

  cout << "testing divide_v" << flush;
  dz << "divide_v\n" << flush;
  bigint_matrix Part7(1, 6), Part8(3, 6);
  A.divide_v(Part7, Part8);
  dz << Part7 << Part8 << flush;
  cout << "............................completed\n" << flush;

  cout << "testing compose" << flush;
  dz << "compose\n" << flush;
  bigint_matrix NEW1(4, 6);
  NEW1.compose(Part1, Part2, Part3, Part4);
  dz << NEW1 << flush;
  cout << ".............................completed\n" << flush;

  cout << "testing compose_h" << flush;
  dz << "compose_h\n" << flush;
  bigint_matrix NEW2(4, 6);
  NEW2.compose_h(Part5, Part6);
  dz << NEW2 << flush;
  cout << "...........................completed\n" << flush;

  cout << "testing compose_v" << flush;
  dz << "compose_v\n" << flush;
  bigint_matrix NEW3(4, 6);
  NEW3.compose_v(Part7, Part8);
  dz << NEW3 << flush;
  cout << "...........................completed\n" << flush;

  cout << "testing diag" << flush;
  dz << "diag\n" << flush;
  NEW1.diag(s1, s2);
  dz << NEW1 << flush;
  diag(NEW2, s2, s3);
  dz << NEW2 << flush;
  cout << "................................completed\n" << flush;

  cout << "testing latticedet" << flush;
  dz << "latticedet\n" << flush;
  dz << latticedet(PAT) << "\n" << flush;
  cout << "..........................completed\n" << flush;

  cout << "testing det" << flush;
  dz << "det\n" << flush;
  bigint_matrix N = E;
  dz << det(E) << flush;
  cout << ".................................completed\n" << flush;

  cout << "testing charpoly" << flush;
  dz << "charpoly\n" << flush;
  bigint_matrix P = N;
  int l = (int)N.get_no_of_columns();
  bigint *v = charpoly(N);
  for (i = 0; i < l + 1; i++)
    dz << v[i] << "\n" << flush;
  cout << "............................completed\n" << flush;

  cout << "testing adj" << flush;
  dz << "adj\n" << flush;
  bigint_matrix Q = P;
  bigint_matrix ADJ = adj(P);
  dz << ADJ << ADJ * Q << flush;
  cout << ".................................completed\n" << flush;

  cout << "testing RegExpansion" << flush;
  dz << "RegExpansion\n" << flush;
  bigint_matrix Z = trans(A);
  long *LIN = lininr(Z);
  bigint_matrix Z1(A), Z2(A);
  regexpansion(Z1, LIN);
  Z2.regexpansion(LIN);
  dz << Z1 << flush;
  dz << Z2 << flush;
  cout << "........................completed\n" << flush;

  cout << "testing max / min " << flush;
  dz << "min/max\n" << flush;
  dz << A.max() << "\n" << flush;
  dz << max(A) << "\n" << flush;
  dz << A.min() << "\n" << flush;
  dz << min(A) << "\n" << flush;
  cout << "..........................completed\n" << flush;

  cout << "testing max_abs / min_abs " << flush;
  dz << "min/max\n" << flush;
  dz << A.max_abs() << "\n" << flush;
  dz << max_abs(A) << "\n" << flush;
  dz << A.min_abs() << "\n" << flush;
  dz << min_abs(A) << "\n" << flush;
  cout << "..................completed\n" << flush;

  cout << "testing is_column_zero" << flush;
  dz << "is_column_zero\n" << flush;
  dz << D.is_column_zero(0) << "\n" << flush;
  dz << is_column_zero(D, 0) << "\n" << flush;
  cout << "......................completed\n" << flush;

  cout << "testing is_row_zero" << flush;
  dz << "is_row_zero\n" << flush;
  dz << D.is_row_zero(0) << "\n" << flush;
  dz << is_row_zero(D, 0) << "\n" << flush;
  cout << ".........................completed\n" << flush;

  cout << "testing SNF" << flush;
  dz << "SNF\n" << flush;
  bigint_matrix Y = Z5;
  bigint_matrix X1, X2;
  Z5.snf(X1, X2);
  dz << Z5 << X1 * Y * X2 << flush;
  cout << ".................................completed\n" << flush;

  cout << "testing HNF" << flush;
  dz << "HNF\n" << flush;
  Y = Z5;
  Z5.hnf(X2);
  dz << Z5 << Y * X2 << flush;
  cout << ".................................completed\n" << flush;

  cout << "\nThe functions ChinRest, get_primes, Hadamard and HNFmod are\n"
    " tested by implication." << flush;

  dz.close();
  cout << "\nPlease use now the 'diff' or 'cmp' command to verify\n";
  cout << "the equality of bigint_matrix_appl.dat";
  cout << " and bigint_matrix_appl.out.\n\n" << flush;
}
