//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : debug.c 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#include <LiDIA/lidia.h>

void default_debug_handler(char *f, char *m)
{
  cout << "\n debug_handler";
  cout << "::" << f;
  cout << "::" << m;
  cout << "\n";
  cout.flush();
}

debug_handler_ptr lidia_debug_handler = default_debug_handler;

debug_handler_ptr set_debug_handler(debug_handler_ptr new_handler)
{
  debug_handler_ptr old_handler = lidia_debug_handler;
  lidia_debug_handler = new_handler;
  return old_handler;
}
