//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : timer_appl.c 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#include <LiDIA/timer.h>

int main()
{
  timer x;
  long i;

  x.set_print_mode(HMS_MODE); // choose h m s ms

  x.start_timer();
#if defined(__hppa)
  for (i=0; i < 0x7ffffff; i++);
#else
  for (i=0; i < 0x7fffff; i++);
#endif
  x.stop_timer();
  cout << endl;
  x.print();
  cout << endl;

  x.set_print_mode(TIME_MODE); // choose time mode 

  x.cont_timer();
#if defined(__hppa)
  for (i=0; i < 0x7ffffff; i++);
#else
  for (i=0; i < 0x7fffff; i++);
#endif
  x.stop_timer();
  cout << endl;
  x.print();
  cout << endl;

  return (0);
}

