#include <LiDIA/quadratic_form.h>
#define LIDIA_POINTER_ACCESS
#include <LiDIA/bigint_matrix.h>
#include <assert.h>

void random_qf(quadratic_form &f, const bigint & a)
{

  bigint s,t,u;
  bigint P,G(2);
  s = randomize(a);
  P = randomize(G);
  if(P.is_even()) s.negate();
  
  t = randomize(a);
  P = randomize(G);
  if(P.is_even()) t.negate();
  
  u = randomize(a);
  P = randomize(G);
  if(P.is_even()) u.negate();
  
	 
  f = quadratic_form(s,t,u);
}

void random_qf_gl(matrix_GL2Z & U, const bigint & a)
{
  bigint s,t,u,v,d,_1(1);
  bigint P,G(2);
  
  s = randomize(a);
  P = randomize(G);
  if(P.is_even()) s.negate();
  
  t = randomize(a);
  P = randomize(G);
  if(P.is_even()) t.negate();
 
  d = xgcd(v,u,s,t);
  while(d != _1)
    {
      s = randomize(a);
      t = randomize(a);
      d = xgcd(v,u,s,t);
    }
  t.negate();
      
  U=matrix_GL2Z(s, u,
		t, v);
  matrix_GL2Z A((-1),(0),
		(0),(1));
 
  if(s.is_even()) multiply(U,U,A);
  
} 


void random_qf_sl(matrix_GL2Z & U, const bigint & a)
{
  bigint s,t,u,v,d,_1(1);
  bigint P,G(2);
  
  s = randomize(a);
  P = randomize(G);
  if(P.is_even()) s.negate();
  
  t = randomize(a);
  P = randomize(G);
  if(P.is_even()) t.negate();
 
  d = xgcd(v,u,s,t);
  while(d != _1)
    {
      s = randomize(a);
      t = randomize(a);
      d = xgcd(v,u,s,t);
    }
  t.negate();
      
  U=matrix_GL2Z(s, u,
		t, v);
  matrix_GL2Z A((-1),(0),
		(0),(1));
  
} 


int main(){
    quadratic_form f,g,h;
    bigint pow, x, y;
    power(pow, 2, 200);
    matrix_GL2Z gl1,gl2, gl3, gl4;
    bigint_matrix bm1, bm2, bm3;
    bigint ** tmp = new bigint * [2];
    tmp[0]= new bigint[2];
    tmp[1]= new bigint[2];

    for (long i = 0; i< 100; i++){
	cout << "\n Test " << i;
	// test matrix_gl2z
	random_qf_gl(gl1, pow);
	random_qf_sl(gl2, pow);
	tmp[0][0] = gl1.get_s();
	tmp[0][1] = gl1.get_u();
	tmp[1][0] = gl1.get_t();
	tmp[1][1] = gl1.get_v();
	bm1.assign(bigint_matrix(2,2,tmp));
	assert((bm1.det() == 1 ) || (bm1.det() == -1));
	assert(bm1.det() == gl1.det());
	tmp[0][0] = gl2.get_s();
	tmp[0][1] = gl2.get_u();
	tmp[1][0] = gl2.get_t();
	tmp[1][1] = gl2.get_v();
	bm2.assign(bigint_matrix(2,2,tmp));
	assert(bm2.det() == 1 );
	divide(gl3, gl1, gl2);
	assert(gl1.det() == gl3.det());
	gl4 = inverse(gl2);
	multiply(gl4, gl1, gl4);
	assert(gl4.get_s() == gl3.get_s());
	assert(gl4.get_t() == gl3.get_t());
	assert(gl4.get_u() == gl3.get_u());
	assert(gl4.get_v() == gl3.get_v());
	bm3.adj(bm2);
	multiply(bm3, bm1, bm3);
	assert(gl3.get_s()==bm3[0][0]);
	assert(gl3.get_u()==bm3[0][1]);
	assert(gl3.get_t()==bm3[1][0]);
	assert(gl3.get_v()==bm3[1][1]);

	// test quadratic_forms
	random_qf(f, pow);
	g = f;
	assert(g == f);
	assert(prop_equivalent(f,g));
	assert(f.get_b() * f.get_b() - bigint(4) * f.get_a()*f.get_c() == f.get_delta());
	random_qf_gl(gl1, pow);
	transform(g, gl1);
	for (long j = 0; j < 10; j++){
	    x=randomize(pow);
	    y=randomize(pow);
	    assert(g.eval(x,y) == bigint(gl1.det()) *
		   f.eval(gl1.get_s() * x + gl1.get_u() * y,
			  gl1.get_t() * x + gl1.get_v() * y));
	}
	gl1 = matrix_GL2Z(1,0,0,1);
	gl2 = matrix_GL2Z(1,0,0,1);
	g = f;
	g.reduce(gl1);
	assert(g.is_reduced());
	assert(prop_equivalent(f,g,gl2));
	assert(gl1.get_s() == gl2.get_s());
	assert(gl1.get_t() == gl2.get_t());
	assert(gl1.get_u() == gl2.get_u());
	assert(gl1.get_v() == gl2.get_v());
	h = f;
	transform(h,gl2);
	assert(h == g);
	cout << " succeded!";
    }
    cout << "Test succeded! :-)\n";
    return 0;
}




