#define LIDIA_POINTER_ACCESS

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:alg_number.h>
#include <LiDIA:debug.h>
#include <LiDIA:base_vector.h>
#include <LiDIA:timer.h>
#else
#include <LiDIA/alg_number.h>
#include <LiDIA/debug.h>
#include <LiDIA/base_vector.h>
#include <LiDIA/timer.h>
#endif

number_field *current_number_field=NULL;
order *current_order=NULL;

#ifdef LIDIA_DEBUG
int number_field::count = 0;
int order::count = 0;
#endif

// Constructors & destructor:
number_field::number_field(const polynomial < bigint > &p):f(p), real_roots(no_of_real_roots(p)), conjugates()
{
    debug_handler_c("number_field","in number_field"
		    "(const polynomial <bigint> &)",1,
		    count++;
		    cout << "\nNow we have "<<count<<" number_fields!\n");
    if (current_number_field == NULL && p != (polynomial <bigint>(bigint(0))))
	current_number_field=this;
}

number_field::number_field(const bigint *v, lidia_size_t deg):f(v,deg),
  real_roots(no_of_real_roots(polynomial<bigint>(v,deg))), conjugates()
{
    debug_handler_c("number_field","in number_field"
		    "(const bigint *, lidia_size_t)",1,
		    count++;
		    cout << "\nNow we have "<<count<<" number_fields!\n");
    if (current_number_field == NULL && f != (polynomial <bigint>(bigint(0))))
	current_number_field=this;
}

number_field::number_field(order * O){
  debug_handler_c("number_field","in number_field(order *)",1,
		  count++;
		  cout << "\nNow we have "<<count<<" number_fields!\n");
  O->compute_base();
  (*this) = *(O->K);
}

number_field::number_field(const number_field & F):f(F.f), real_roots(F.real_roots), conjugates(F.conjugates)
{
    debug_handler_c("number_field","in number_field(const number_field &)",1,
		    count++;
		    cout << "\nNow we have "<<count<<" number_fields!\n");
}

number_field::~number_field()
{
    debug_handler_c("number_field","in ~number_field(const number_field &)",1,
		    count--;
		    cout << "\nNow we have only "<<count<<" number_fields!\n");
    if (current_number_field==this) current_number_field=NULL;
}

// member functions:
bigfloat number_field::get_conjugate(lidia_size_t i,lidia_size_t j){
// get the j-th conjugate of \alpha^i with precision q.
    lidia_error_handler("field",
			"Constructing Conjugates is not yet supported.");
}

number_field overfield(const number_field &A, const number_field &B){
    lidia_error_handler("field",
			 "Construction of common overfields is not "
			 "yet supported.");
}	


// Comparision:
bool operator ==(const number_field & A, const number_field & B)
{
    // Fields are considered to be equal, if generated by the same polynomial;
    if (&A == &B) return true;
    if (A.f == B.f) return true;
    return false;
}


bool operator <=(const number_field & A, const number_field & B)
{
    if (A == B) return true;

    cout << "WARNING: number_field::operator <=\n";
    cout << "WARNING: Solving the subfield problem is difficult...\n";
    cout << "WARNING: So by now, we always return false!!\n";
    return false;
}

// In-/Output:
ostream& operator<< (ostream &s, const number_field &K){
    s << K.f << flush;
    return(s);
}

istream& operator>>(istream &s, number_field &K){
    s >> K.f;
    current_number_field = &K;
    K.real_roots = no_of_real_roots(K.f);
    return(s);
}

// **************************************************************************

// Constructors & destructor:
order::order(const number_field * F): 
    K(F), table(), base(), den(1), One(), trace_matrix(), conjugates()
{
    debug_handler_c("order","in order(const number_field *)",1,
		    count++;
		    cout << "\nNow we have "<<count<<" orders!\n");
    if ((current_order == NULL)&&(F!=NULL)) current_order=this;
}

order::order(const number_field & F): 
    K(&F), table(), base(), den(1), One(), trace_matrix(), conjugates()
{
    debug_handler_c("order","in order(const number_field &)",1,
		    count++;
		    cout << "\nNow we have "<<count<<" orders!\n");
    if (current_order == NULL) current_order=this;
}

order::order(const base_matrix <bigint> &in_table):
    K(NULL), table(in_table), base(), den(1),
    One(), trace_matrix(), conjugates()
{
    debug_handler_c("order","in order(const bigint_matrix &)",1,
		    count++;
		    cout << "\nNow we have "<<count<<" orders!\n");
    if (current_order == NULL) current_order=this;
}

order::order(const base_matrix <bigint> &coefficients,
	     const bigint &d, const number_field * F):
    K(F), table(), base(coefficients), den(d),
    One(), trace_matrix(), conjugates()
{
    debug_handler_c("order","in order"
		    "(const bigint_matrix &, const bigint &, const number_field *)",
		    1,count++;
		    cout << "\nNow we have "<<count<<" orders!\n");
    if (current_order == NULL) current_order=this;
}

order::order(const order &O):
    K(O.K), table(O.table), base(O.base), den(O.den),
    One(O.One), trace_matrix(O.trace_matrix)
{
    debug_handler_c("order","in order(const order &)",1,
		    count++;
		    cout << "\nNow we have "<<count<<" orders!\n");
}    

order::~order(){//hoffentlich nix zu tun,weil Member-Destruktoren alles tun!
    debug_handler_c("order","in ~order()",1,
		    count--;
		    cout << "\nNow we have only "<<count<<" orders!\n");
    if (current_order==this) current_order=NULL;
}

// private functions: Computing information, that is needed internally:
void order::compute_table() const
{
    debug_handler("order","in member - function compute_table()");

    register lidia_size_t i,j,k=0;
    polynomial <bigint> p = K->which_polynomial(), p1, p2;
    bigint * tmp;

    table.set_no_of_columns(degree());
    table.set_no_of_rows((lidia_size_t)(((double)degree())/2*(degree()+1)));

    if (!base_computed()){
	polynomial <bigint> x;		//polynom p(x)=x;
	x.assign_x();
	polynomial <bigint> p1(bigint(1));
	for(i=0;i<degree();i++,p1*=x){
	    polynomial <bigint> p2(bigint(1));
	    for(j=0;j<=i;j++,p2*=x){
		debug_handler_c("order","compute_table",0,
				cout <<"computing x^"<<j+i<<": "<<(p1*p2)%p);
		polynomial <bigint> f=(p1*p2)%p;
		register lidia_size_t l=0;
		for(; l <= f.degree(); l++)
		    table.sto(k,l,f[l]);
		for(; l < degree(); l++)
		    table.sto(k,l,0);
		k++;
	    }
	}
	debug_handler_c("order","compute_table():: Computed table\n",0,
			cout << table <<" for number_field "<<(*K);
	                cout <<"(no transformation)\n"<<flush);
    }
    else{
	bigint q,r;
	//temporary variable to hold the products of base elements:
	bigint_matrix init(degree(),degree()*(degree()+1)/2);
	for(i=0;i<degree();i++){
	    p1.set_data(tmp=base.column(i),degree());
	    delete[] tmp;
	    for(j=0;j<=i;j++){
		p2.set_data(tmp=base.column(j),degree());
		delete[] tmp;
		polynomial <bigint> f=(p1*p2)%p;
		init.sto_column(tmp=f.get_data(),f.degree()+1,(i*(i+1))/2+j);
		delete[] tmp;
	    }
	}
	init.reginvimage(base, init);
//Evtl. vorher testen, ob letzte Zeile 1 ist!
	init.set_no_of_rows(degree());

	debug_handler_c("order","in member - function compute_table(...)",
 		   3,cout << "den * MT is" << trans(init) << flush);

	for (i = 0; i < init.get_no_of_rows(); i++)
	    for (j = 0; j < init.get_no_of_columns(); j++){
		div_rem(q,r,init.member(i,j),den);
		if (!r.is_zero())
		    lidia_error_handler_c("order","compute_table::internal error::"
				    "division by p unsuccesful",
				    cout<<"While dividing"<<init.member(i,j);
				    cout<<" by " << den << endl );
		init.sto(i,j,q);
	    }
        table=trans(init);
	debug_handler_c("order","compute_table():: Computed table\n",0,
			cout << table <<" for number_field "<<(*K);
	                cout <<"with transformation\n"<<base<<flush);
    }
    debug_handler_l("order","exit member - function compute_table()",4);
}

void order::compute_base()
{
  debug_handler_l("order","in member_function `compute_base()'",0);
  bigint * tmp = new bigint[degree()];
  bigint tmp2;

  alg_number rho(tmp,1, this);
  polynomial <bigint> rho_pol(0);
  polynomial <bigint> temp_pol;

  long mu = 0;

  debug_handler_l("order","compute_base()::initialized",0);
  while (rho_pol.degree()<degree()){
    mu++;
    for(register lidia_size_t i = 0; i < degree() && 
	                             rho_pol.degree() < degree(); i++){
      tmp2.assign(tmp[i]);
      tmp[i].assign(mu);
      alg_number temp(tmp,1,this);

      debug_handler_c("order","compute_base():",0,
		      cout << "\tTesting " <<temp<<endl;
		      cout << " with matrix "<<rep_matrix(temp)<<flush);
      temp_pol = charpoly(temp);
      temp_pol = temp_pol / gcd(temp_pol, derivation(temp_pol));

      debug_handler_c("order","compute_base():",0,
		      cout << "\tMin.pol is " <<temp_pol<<endl<<flush);

      if (temp_pol.degree() > rho_pol.degree()){
	rho.assign(temp);
	rho_pol = temp_pol;
	tmp2.assign(mu);
      }

      tmp[i].assign(-mu);
      temp = alg_number(tmp,1,this);

      debug_handler_c("order","compute_base():",0,
		      cout << "\tTesting " <<temp<<endl<<flush);

      temp_pol = charpoly(temp);
      debug_handler_l("order","compute_base()::Computed char.pol!",0);

      temp_pol = temp_pol / gcd(temp_pol, derivation(temp_pol));

      debug_handler_c("order","compute_base():",0,
		      cout << "\tMin.pol is " <<temp_pol<<endl<<flush);

      if (temp_pol.degree() > rho_pol.degree()){
	rho.assign(temp);
	rho_pol = temp_pol;
      }
      else tmp[i].assign(tmp2);
    }
  }
  delete[] tmp;

  debug_handler_c("order","compute_base():",7,
		  cout << "Found number_field "<<rho_pol<<" for "<<rho<<endl<<flush);

  // Update the order:
  bigint_matrix T(degree(),degree());
  T.sto_column_vector(get_one(),degree(),0);
  alg_number temp(rho);
  for (register lidia_size_t i = 1; i < degree()-1; i++){
    T.sto_column_vector(temp.coeff_vector(),degree(),i);
    multiply(temp,temp,rho);
  }
  T.sto_column_vector(temp.coeff_vector(),degree(),degree()-1);
  
  bigint_matrix A(degree(),degree());
  A.adj(T);
  T.det(tmp2);
  den.assign(tmp2);

  for(register lidia_size_t k=0; (k < degree()) && (!tmp2.is_one()); k++)
    for (register lidia_size_t j=0; j < degree(); j++)
      tmp2.assign(gcd (A.member(k,j), tmp2));
  if (!tmp2.is_one()) {
    den /= tmp2;
    A   /= tmp2;
  }

  base.assign(A);

  // Initialize the field:
  K = new number_field(rho_pol);		// Potential memory leak !!
}

// member functions:
const math_vector <bigint> & order::get_one() const
{
    debug_handler("order","in member - function get_one()");
    register lidia_size_t i,j;
    if (One.size()>0) {
	debug_handler_l("order", "exit from get_one()",4);
	return One;
    }
    One.set_capacity(degree());
    debug_handler("order","get_one()::capacity set, decide what's used.");
    // Linear equation system for 1: One* MT(nik)_{i,k)=e_n
    // instead of n every number less than n also works, but for n
    //		getting all the columns is easier/faster.
    // construct the linear equation system using MT
    if (using_necessary()){
	// If necessary construct the multiplication table:
	if (!table_computed()){
	    compute_table();
	}
	debug_handler("get_one","Constructing LES");
	bigint_matrix A(degree(), degree());
	base_vector <bigint> tmp2;
	for(i=0, j = (lidia_size_t)(((double)degree()-1)/2.0*degree());
	    i<degree(); i++,j++){
	    debug_handler("get_one","Constructing LES");
	    table.row_vector(tmp2,j);
	    A.sto_column_vector(tmp2,degree(),i);
	}
	// solve LES
	debug_handler("get_one","construct right side");
	bigint * tmp = new bigint[degree()];	// Wie wird initialisiert??
	for (i=0; i < degree()-1;i++){		// Should be superfluous
	    tmp[i].assign_zero();		// due to initialisation
	}					// by new-operator.
	tmp[degree() - 1].assign_one();
	debug_handler_c("order","get_one(..)",0,
			cout << "Solving "<<A;
			cout<<base_vector <bigint> (tmp, degree()));

	bigint_matrix solution = solve(A,tmp);
	if (solution.get_no_of_columns() != 2)
	    lidia_error_handler_c("order","get_one::order doesn't contain a unique representation of 1",
			    cout << "While constructing 1 in the following";
			    cout <<" `order':"<<(*this)<<"Solving "<<A;
			    cout <<base_vector <bigint> (tmp, degree());
			    cout << "Got solution:"<< solution);
	delete[] tmp;
	solution.column_vector(One,1);
    }
    else{
	// If we are in the simple case, 1 is just a polynomial of degree 0
	debug_handler("order","get_one():: just return [ 1 0 ... 0]");
	bigint * tmp = new bigint[degree()];
	tmp[0] = 1;
	debug_handler("order","get_one():: set vector");
	One.set_data(tmp,degree());
	delete[] tmp;
    }
    debug_handler_l("order", "other exit from get_one()",4);
    return One;
}

bigint_matrix order::get_trace_matrix() const
{
    debug_handler("order","in member - function get_trace_matrix()");
    if (trace_matrix.get_no_of_columns()>1) return trace_matrix;

    trace_matrix.set_no_of_columns(degree());
    trace_matrix.set_no_of_rows(degree());
    debug_handler("order","in member - function get_trace_matrix() "
		  "-- computing");
    bigint * tmp;
    bigrational Tr;
    // If necessary construct the multiplication table:
    if (!table_computed()){ 
	compute_table();
    }
    for (register lidia_size_t i=0;i<degree();i++){
	for (register lidia_size_t j=0;j<i;j++){
	    tmp = table.row((lidia_size_t)(((double)i/2.0)*(i+1))+j);
	    Tr = trace(alg_number(tmp,1,this));
	    if (!Tr.denominator().is_one()){
		debug_handler_c("order","in member - function "
			       "get_trace_matrix()",0,
			       cout << "Found an element with denominator ";
			       cout << Tr.denominator() << endl);
		lidia_error_handler("order", "get_trace_matrix::internal error::"
			      "denominator is not 1");
	    }
	    trace_matrix.sto(i, j, Tr.numerator());
	    trace_matrix.sto(j, i, Tr.numerator());
	    delete[] tmp;
	}
	tmp = table.row((lidia_size_t)((double)i/2.0*(i+3)));
	Tr = trace(alg_number(tmp,1,this));
	trace_matrix.sto(i,i,Tr.numerator());
	if (!Tr.denominator().is_one()){
		debug_handler_c("order","in member - function "
			       "get_trace_matrix()",0,
			       cout << "Found an element with denominator ";
			       cout << Tr.denominator() << endl);
	    lidia_error_handler("order", "get_trace_matrix::internal error::"
			  "denominator is not 1");
	}
	delete[] tmp;
    }
    return trace_matrix;
}

lidia_size_t order::degree() const{
    if (K !=  NULL){
	return K->degree();
    }
    else
	if (!table_computed())
	    lidia_error_handler("order", 
				"degree::used on non-initialized order");
	else{
	    return (table.get_no_of_columns());
	}
}

bigint order::MT(lidia_size_t i,lidia_size_t j,lidia_size_t k){
    register lidia_size_t n = this->degree();
    if (!table_computed()){
	compute_table();
    }
    if ((i<1)||(i>n))
	lidia_error_handler("order", "MT::first index out of range\n");
    if ((j<1)||(j>n))
	lidia_error_handler("order", "MT::second index out of range\n");
    if ((k<1)||(k>n))
	lidia_error_handler("order", "MT::third index out of range\n");
    if (i<j){
	n=i;i=j;j=n;
    }
    if (i%2)
	return table.member(i*((i-1)>>1)+j-1,k-1);
    else
	return table.member((i>>1)*(i-1)+j-1,k-1);
}

void order::assign(const order & O)
{
    den.assign(O.den);
    base.assign(O.base);
    table.assign(O.table);
    K=O.K;
    One = O.One;
    trace_matrix.assign(O.trace_matrix);
}

// Cast to module
order::operator module() const
{ 
    debug_handler("order","in operator module()");
    bigint_matrix A(degree(), degree());
    A.diag(1,0);
    module M(A,1,(order *)(this));
    debug_handler("order","leaving operator module()");
    return M;
}

// Comparision:
// We are interested in comparing orders only if they are over the same field!
// One function to compute the always needed transformation matrix
void order::compare(const order & O, bool & this_in_O, bool & O_in_this) const
{
    if (*K != *(O.K))
	error_handler("order","compare::You tried to compare orders over "
		      "different number_fields!");
    debug_handler("order","in operator ==");
    if (!base_computed()){
	order * O1 = (order *)(this);
	O1->compute_base();
    }
    if (!O.base_computed()){
	order * O1 = (order *)(&O);
	O1->compute_base();
    }
    bigint_matrix T;
    T.reginvimage(base, O.base);
    this_in_O=true;
    O_in_this=true;
    for (lidia_size_t i=0; O_in_this && (i < degree()); i++)
	if (T.member(degree(),i) != bigint(1)) O_in_this=false;
    T.set_no_of_rows(degree());
    if (abs(T.det()) != bigint(1)) this_in_O = false;
}

bool operator ==(const order & O1, const order & O2)
{
    debug_handler("order","in operator ==");
    bool O1_in_O2;
    bool O2_in_O1;
    O1.compare(O2, O1_in_O2, O2_in_O1);
    return O1_in_O2 && O2_in_O1;
}

bool operator !=(const order & O1, const order & O2)
{
    debug_handler("order","in operator !=");
    bool O1_in_O2;
    bool O2_in_O1;
    O1.compare(O2, O1_in_O2, O2_in_O1);
    return !(O1_in_O2 && O2_in_O1);

}

bool operator <=(const order & O1, const order & O2)
{
    debug_handler("order","in operator <=");
    bool O1_in_O2;
    bool O2_in_O1;
    O1.compare(O2, O1_in_O2, O2_in_O1);
    return O1_in_O2;
}

bool operator <(const order & O1, const order & O2)
{
    debug_handler("order","in operator <");
    bool O1_in_O2;
    bool O2_in_O1;
    O1.compare(O2, O1_in_O2, O2_in_O1);
    return O1_in_O2 && !O2_in_O1;
}

bool operator >=(const order & O1, const order & O2)
{
    debug_handler("order","in operator >=");
    bool O1_in_O2;
    bool O2_in_O1;
    O1.compare(O2, O1_in_O2, O2_in_O1);
    return O2_in_O1;
}

bool operator >(const order & O1, const order & O2)
{
    debug_handler("order","in operator >");
    bool O1_in_O2;
    bool O2_in_O1;
    O1.compare(O2, O1_in_O2, O2_in_O1);
    return O2_in_O1 && !O1_in_O2;
}

// friend functions:
void swap(order & O, order & Q){
    swap (O.den, Q.den);
    swap (O.base, Q.base);
    swap (O.table, Q.table);
    swap (O.One, Q.One);
    swap (O.trace_matrix, Q.trace_matrix);

    const number_field * help = O.K;
    O.K = Q.K;
    Q.K = help;
}

// Number-theoretic functions:
// Dedekind test:

bool order::dedekind(const bigint & p, polynomial < bigint > & h2) const
// returns true, if p is index divisor
// and false otherwise.
{
    debug_handler("order","in member - function dedekind(const bigint &, polynomial <bigint> &)");

    if (K==NULL) return true;	//Attention: h not initialized
    register lidia_size_t j,k;

    polynomial <bigint> f(K->which_polynomial()%p);
    polynomial <bigint> *fa = new (polynomial <bigint>)[f.degree()+1];
    
    //Berechne Faktoren fa[i] von f mit fa[i]^i | f:
    debug_handler_c("order","dedekind(...)",4,
		    cout << "call squarefree_factor "<<flush);
    squarefree_factor(f, fa, p);
    debug_handler_c("order","dedekind(...)",4,
		    cout << "Factorisation of f = "<<f <<" is:\n";
		    for (j=1;j <=f.degree();j++) cout << "\t"<<fa[j]<<endl);

    polynomial <bigint> h(bigint(1)),h1(bigint(1));

    for (j=f.degree();j>=1;j--){

	for (k=1;k<=j;k++)
 	    h *= fa[j];
	if (j>=2)
 	    h1*=fa[j];
    }
    polynomial <bigint> f1 = K->which_polynomial()-h;

    f1 /= bigint(p);   // h(t) is f1
    debug_handler_c("order","dedekind(...)",4,
		    cout << "call gcd for "<<h1<<" and ";
		    cout <<f1<<" mod "<<p<<endl<<flush);
    h2 = gcd(h1,f1,p);
    delete[] fa;

    if (h2.degree()){
	debug_handler_c("order","dedekind(...)",5,
			cout << p << " is an index divisor."<<endl<<flush);
	div_rem(h2,h1,K->which_polynomial(),h2);
	return true;
    }

    debug_handler_c("order","dedekind(...)",5,
		    cout << p << " is not an index divisor."<<endl<<flush);
    return false;
}

// Computation of the pseudo radical

module order::pseudo_radical(const bigint & p, bigint & factor) const
// computes Ip + pO, the pseudo-radical of O/pO

// Alle Rechnungen sollten intern modulo p geschehen!!?!?!
{
    debug_handler("order","in member - function "
		  "pseudo_radical(const bigint &, bigint &)");
    register lidia_size_t j,k,n=degree();
    alg_number e((order *)(this)), im_e((order *)(this));
                              //initialised with zero!      
    bigint q=p;
    bigmod_matrix A(n,n,p);
    bigint *tmp = new bigint[n];

    if ((p<1000)&&is_prime(p,10)){
	debug_handler_l("order","pseudo_radical: prime case",0);
	j=1;
	// compute j such that the j-th power of p exceeds the dimension
	while (q<n){
	    j++;
	    q=q*p;
	}
	for (k=0;k<n;tmp[k++] = 0){
	    tmp[k] = 1;		//tmp=e_k
	    e = alg_number(tmp,1,(order *)(this));
	    // e=e_k
	    debug_handler_c("order","pseudo_radical",4,
			    cout<<"compute"<<e <<"^"<<p<<flush);
	    power_mod_p(im_e, e, q, p);	// Should be done mod p
	    debug_handler_c("order","pseudo_radical",4,
			    cout<<"It's"<<im_e<<flush);
	    A.sto_column(im_e.coeff_vector().get_data(),degree(),k);
	}
    }
    else{
	// we know gcd(p,n!)=1 (otherwise we would have factored p)
	// Compute A as matrix of the map: 
	//      (O/pO -> (O/pO->Z/pZ)
	//	( a   -> (b   ->Tr(ab)))
	// For this, compute (b_j -> Tr(b_j*b_k)) for each pair of 
	// base_vectors (b_j,b_k) of O/pO and store this as A_{j,k}.
	debug_handler_l("order","pseudo_radical: non-prime case",0);
	bigrational Trace;
	for (j=0;j<n;tmp[n-1] = 0, j++){
	    tmp[j] = 1;	//tmp=e_j;
	    e = alg_number(tmp,1,(order *)(this));
	    // e = e_j;
	    tmp[j]=0;
	    for (k=0;k<n; tmp[k++]  = 0){
		tmp[k] = 1;	//tmp=e_k;
		im_e = alg_number(tmp,1,(order *)(this));
		// im_e = e_k
		if ((Trace=trace(e*im_e)).denominator()!=1)
		    A.sto(j,k,Trace.numerator());
	    }
	}
     }
//gemeinsamer Code:
    debug_handler_l("order","pseudo_radical::common part of code",4);
    A = kernel(A, factor);
    if (!factor.is_one()){
	error_handler_c("order","in member - function pseudo_radical(...)",
		       cout << "While computing kernel mod "<< p;
		       cout <<" found factor "<< factor << endl);
	return (*this);
    }
    debug_handler_l("order","pseudo_radical::kernel computed part of code",4);
    bigint_matrix COPY(n,k=A.get_no_of_columns());
    delete[] tmp;
    base_vector <bigint> tmp2;
    for (j = 0; j < n; j++){
      A.row_vector(tmp2,j);
      COPY.sto_row_vector(tmp2,k,j);
    }
    debug_handler_l("order","pseudo_radical: construct Ip",0);
    module Ip(module(COPY, 1, (order *)(this)) + 
	      module(alg_number(bigint(p),(order *)(this))));
    debug_handler_c("order","in member - function pseudo_radical(...)",4,
		   cout << "Radical is " << Ip<<flush);
    return Ip;
}

// Maximizing the order:

order order::maximize() const
{
    debug_handler("order","in member - function maximize()");
    rational_factorization a=disc(*this);
                                        // initialize a with discriminant
    order maximized(*this);		// initialize maximal order
    bigint factor;
    polynomial < bigint > h;

    a.factor(10);			// find 10-digit factors (and smaller)
    debug_handler_c("order","in member - function maximize()",4,
		   cout << "Factorization of Diskriminant is "<<a<<endl);
    for (register lidia_size_t i=0; i<a.no_of_comp(); i++)
	if (a.exponent(i)>1){
	    if (a.is_prime_factor(i)){
		debug_handler_c("order","maximize()",3,
				cout << "calling dedekind for "<< a.base(i);
				cout << "\n on\n" << maximized << flush);
		if (K!=NULL){
		    if (!maximized.dedekind(a.base(i),h))
			continue;
		    // i.e. if the dedekind test could't maximize anything
		    // start the next loop iteration, otherwise do a first
		    //maximizing step:
		    bigint_matrix A(degree(), 1);
		    bigint deno(1);

		    A.sto_column(h.get_data(),h.degree()+1,0);
		    if (maximized.base_computed()){
			A.reginvimage(maximized.base,A);
			deno = A.member(degree(),0);
			A.set_no_of_rows(degree());
			A *= den;
		    }
		    alg_number x(A.column(0),deno,&maximized);
		    debug_handler_c("order","maximize()",3,
				    cout << "Polynomial is "<<h;
				    cout << "x is "<<x;
				    cout << "p is "<<alg_number(bigint(a.base(i)), &maximized);
				    cout << "Radical is ";
				    cout <<module(x,alg_number(a.base(i),&maximized))<<flush);
 		    maximized.assign(module(x,alg_number(a.base(i),&maximized)).ring_of_multipliers(a.base(i), factor));
		    debug_handler_c("order","maximize()",3,
				    cout << "maximized is "<<maximized<<flush);
 		    if (!factor.is_one())
 			lidia_error_handler_c("order","maximize():: number which "
 					"was assumed to be prime is not prime",
 					cout << factor<<" divides "<<a<<endl);
		    // if the discriminant will shrink sufficiently,
		    // we can start the next loop iteration:
		    if (a.exponent(i)<2*(degree()-h.degree()+1))
			continue;
 		}
	    }
	    // and use the Buchmann/Lenstra - algorithm for further
	    // maximization, if necessary
	    debug_handler_c("order","in member - function maximize()::"
			   "next  call to maximize(p,factor)",4,
			   cout << "with p = "<<a.base(i)<<" exponent is "<<a.exponent(i));
	    maximized.assign(maximized.maximize(a.base(i),factor));
	    if (!factor.is_one()){
                // What to do, if we did find a factor 
	    }
	    // i.e. the order is maximized locally at a.base(i)
	    debug_handler("order","in member - function maximize()::"
		"returned from maximize(p,factor)");	   
	}
    return maximized;
}

// Locally maximize the order:

order order::maximize(const bigint & p, bigint & factor) const
{
    debug_handler("order","in member - function "
		  "maximize(const bigint &, bigint &)");
    debug_handler_l("order","in member - function maximize(...)::"
		    "call pseudo_radical",4);
    module Ip=pseudo_radical(p,factor);
    if (!factor.is_one()){
	debug_handler_c("order","in member - function maximize(...)",0,
		       cout << "While computing pseudo-radical mod "<< p;
		       cout <<" found factor "<< factor << endl);
	return (*this);
    }
    debug_handler_l("order","in member - function maximize(...)::"
		    "call ring_of_multipliers",4);
    order tmp = Ip.ring_of_multipliers(p,factor);
    if (!factor.is_one()){
	debug_handler_c("order","in member - function maximize(...)",0,
		       cout << "While computing ring of mult. mod "<< p;
		       cout <<" found factor "<< factor << endl);
	return (*this);
    }
    order * multipliers = &tmp;
    order * old_multipliers=(order *)(this);
    debug_handler("order","in member - function "
		  "maximize(const bigint &, bigint &)::start loop");
   
    while (multipliers->table != old_multipliers->table){ // falls echte Obermenge:
	debug_handler("order","in member - function "
		      "maximize(const bigint &, bigint &)::in loop");
	debug_handler_l("order","in member - function maximize(...)::"
			"call pseudo_radical",4);
	Ip=multipliers->pseudo_radical(p,factor);
	if (!factor.is_one()){
	    debug_handler_c("order","in member - function maximize(...)",0,
			   cout << "While computing pseudo-radical mod "<< p;
			   cout	<<" found factor "<< factor << endl);
	    return (*multipliers);
	}
	old_multipliers=multipliers;
	debug_handler_l("order","in member - function maximize(...)::"
			"call ring_of_multipliers",4);
        tmp = Ip.ring_of_multipliers(p,factor);
	if (!factor.is_one()){
	    debug_handler_c("order","in member - function maximize(...)",0,
			   cout << "While computing ring of mult. mod "<< p;
			   cout	<<" found factor "<< factor << endl);
	    return (*multipliers);
	}

	multipliers = &tmp;
    }
    debug_handler("order","in member - function "
		  "maximize(const bigint &, bigint &)::after loop");
    return *multipliers;
}


// In-/Output:
ostream& operator<<(ostream &s, const order &O){
    // If necessary construct the mutliplication table:
    debug_handler("order","in operator << (ostream &, order &)");
    if (!O.table_computed()){
	O.compute_table();
    }
    s << O.table << flush;
    return s;
}

istream& operator>>(istream &s, order &input){
    s >> input.table;
    if ((input.table.get_no_of_columns() == 1)
	|| (input.table.get_no_of_columns() == input.table.get_no_of_rows())){
	if(current_number_field == NULL)
	    lidia_error_handler ("order","operator>>::You didn't give a mult. "
				 "table and there is no init. number_field!");
	else input.K = current_number_field;
	if (input.table.get_no_of_columns() == 1){
	    input.trace_matrix = input.base = input.table = bigint_matrix(1,1);
	    input.den = 1;
	    input.One = math_vector <bigint>();
	}
	else{
	    if (input.table.get_no_of_columns() != (input.K)->degree())
		lidia_error_handler ("order","operator>>::The given matrix "
				 "does not match with the current number_field!");

	    input.trace_matrix = input.base = bigint_matrix(1,1);
	    swap(input.base, input.table); 		// tricky & fast!!!
	    input.One = math_vector <bigint>();
	    char c;
	    do{
		s.get(c);
	    } while (isspace(c) && c != '\n'); 
	    if (c == '/'){
		s >> input.den;
	    }
	    else{
		input.den = 1;
		if (c != '\n' && c != '\r')
		    s.putback(c);
	    }
	}
    }
    else{
	if ((double)(input.table.get_no_of_columns()+1)/2 *
	    input.table.get_no_of_columns() != input.table.get_no_of_rows())
	    lidia_error_handler ("order","operator>>::Your input does not "
				 "look like an order to me. Sorry!");
	input.K = NULL;
	input.trace_matrix = (input.base = bigint_matrix(1,1));
	input.den = 1;
	input.One = math_vector <bigint>();
    }
    current_order = & input;
    return(s);
}
