//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : dlp.h 
// Author      : Damian Weber (DW)
// Last change : TP, Aug 8 1995, initial version
//

#if !defined(LIDIA_DLP_H)
#define LIDIA_DLP_H

#include <LiDIA/bigint.h>

#if !defined(HEADBANGER)
#include <LiDIA/rational_factorization.h>
#endif

extern bigint search_generator (const bigint &p, const bigint &g0);
extern bigint search_generator (const bigint &p);

#if !defined(HEADBANGER)
extern bigint search_generator (const bigint &p, const bigint &g0,
				rational_factorization &f);

extern bigint pohlig_hellman_shanks (const bigint &g, const bigint &a,
				     const bigint &p, const bigint &q);
extern bigint discrete_log (const bigint &a, const bigint &b, 
			    const bigint &p, 
			    const rational_factorization &f);
#endif

extern bigint dl (const bigint &a, const bigint &b, const bigint &p,
		  int verbose = 0);

#endif
