//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : indexed_hash_table.h
// Author      : Michael Jacobson (MJ)
// Last change : MJ, September 24, 1996
//

#ifndef LIDIA_INDEXED_HASH_TABLE_H
#define LIDIA_INDEXED_HASH_TABLE_H

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:hash_table.h>
#include <LiDIA:sort_vector.h>
#else
#include <LiDIA/hash_table.h>
#include <LiDIA/sort_vector.h>
#endif

template <class T>
class indexed_hash_table : public hash_table<T>
{
  private:

  sort_vector < int  > IDX;
  int outstyle;

  public:

  /**
   ** constructors and destructor 
   **/

  indexed_hash_table();
  ~indexed_hash_table();

  /**
   ** member functions
   **/

  void assign(const indexed_hash_table < T > & old_table);
  indexed_hash_table < T > & operator = (const indexed_hash_table < T > & old_table);

  const T & operator[] (lidia_size_t i) const;
  const T & member(lidia_size_t i) const;
  void remove(const T & G);
  void remove_from(const lidia_size_t i);
  void empty();
  void hash(const T & G);

  void output_style(int style);
  void read  (istream & in);
  void print (ostream & out) const;

  friend istream & operator >> (istream & in, indexed_hash_table < T > & HT)
   {HT.read(in); return (in);}

  friend ostream & operator << (ostream & out, const indexed_hash_table < T > &
HT)
   {HT.print(out); return (out);}
};

#ifdef LIDIA_INCLUDE_C
#include <LiDIA/indexed_hash_table.c>
#endif 

#endif
