

//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : vector.h 
// Author      : Frank Lehmann (FL), Markus Maurer (MM), 
//               Thomas Papanikolaou (TP)
// Last change : FL/MM, Feb 15 1995, initial version
//               FL/MM, May 10 1995, clean-up
//		 FL/MM, May 15 1995, changed type of size variables to base_vector<T>::size_type
//		 FL/MM, May 23 1995, removed math_sort_vector and file_sort_vector;
//				     changed vector into vector
//		 FL/MM, Jul  6 1995, replaced base_vector<T>::size_type by lidia_size_t
//               FL/MM, Jul 24 1995, added 'const' to T* parameters of constructors


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
// *
// *    File        :  vector.h
// *
// *    Description :  -) definition of template class 'vector<T>'
// *                      to combine the capabilities of the classes
// *    	          'base_vector<T>', 'math_vector<T>', 'sort_vector<T>',
// *                      and 'file_vector<T>'
// *
// *                   -) virtual base classes are 'sort_vector<T>',
// * 			  'math_vector<T>', and 'file_vector<T>'
// *
// * 		       -) the requirements on type T are derived by those
// *			  of the corresponding base classes
// *
// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


#ifndef LIDIA_VECTOR_H
#define LIDIA_VECTOR_H


#include <LiDIA/math_vector.h>
#include <LiDIA/sort_vector.h>
#include <LiDIA/file_vector.h>


 template <class T> class  vector : virtual public file_vector < T >,
                                          virtual public sort_vector < T >,
                                          virtual public math_vector < T >
 {

   public :

   // ***** constructor functions *****

   vector () : base_vector< T > ( 0, FIXED )     
    {
       debug_handler_l ( "vector", "constructor ()", LDBL_VECTOR +1 ) ;
    }

   // vector (  char md ) :  base_vector< T > ( md )     
   //  {
   //     debug_handler_l ( "vector", "constructor ( char )", LDBL_VECTOR +1 ) ;
   //  }


   //vector (  lidia_size_t all ) : base_vector< T > ( all, FIXED ) 
   // {
   //    debug_handler_l ( "vector", "constructor ( lidia_size_t )", LDBL_VECTOR +1 ) ;
   // }

   vector (  lidia_size_t all,  char md ) : base_vector< T > ( all, md ) 
    {
       debug_handler_l ( "vector", "constructor ( lidia_size_t, char )", LDBL_VECTOR +1 ) ;
    }


   vector ( lidia_size_t all, lidia_size_t len ) : base_vector< T > ( all, len, FIXED )  
    {
       debug_handler_l ( "vector", "constructor ( lidia_size_t, lidia_size_t )", LDBL_VECTOR +1 ) ;
    }

   vector ( lidia_size_t all, lidia_size_t len,  char md ) : base_vector< T > ( all, len, md )  
    {
       debug_handler_l ( "vector", "constructor ( lidia_size_t, lidia_size_t, char )", LDBL_VECTOR +1 ) ;
    }


   vector ( const base_vector < T > & v ) : base_vector< T > ( v, FIXED )  
    {
       debug_handler_l ( "vector", "constructor ( base_vector < T > & )", LDBL_VECTOR +1 ) ;
    }

   vector ( const base_vector < T > & v,  char md ) : base_vector< T > ( v, md )  
    {
       debug_handler_l ( "vector", "constructor ( base_vector < T > &, char  )", LDBL_VECTOR +1 ) ;
    }


   vector ( const  T *v, lidia_size_t len ) : base_vector< T > ( v, len, FIXED )  
    {
       debug_handler_l ( "vector", "constructor ( const T *, lidia_size_t )", LDBL_VECTOR +1 ) ;
    }

   vector ( const  T *v, lidia_size_t len,  char md ) : base_vector< T > ( v, len, md )  
    {
       debug_handler_l ( "vector", "constructor ( const T *, lidia_size_t, char )", LDBL_VECTOR +1 ) ;
    }



   // ***** destructor *****

   ~vector()
    {
      debug_handler_l ( "vector", "destructor()", LDBL_VECTOR +1 ) ;

      //  memory deallocation is done by
      //  base_vector - destructor
    }


    // ***** assignment *****

    vector<T> & operator =( const vector<T> & v ) 
     {
       debug_handler_l ( "vector", "operator=", LDBL_VECTOR +2 ) ;
       
if ( &v != this )
     
     base_vector<T>::operator = ( v );
       
       return ( *this ) ;
     }   

 } ;


#endif








