#include "iint.h"
#include <stdio.h>

#define LIMIT	300
#define NLOOPS 	100

static void 
printInt(a)
    Integer *a;
{
    int i;
    printf("sign=%d, length=%d, maxlength=%d, vec:\n",
	   a->sign, a->length, a->maxlength);
    for (i = 0; i < a->maxlength; i++)
	printf("%lu ", a->vec[i]);
    printf("\n");
}

void main()
{
    Integer a, b, c, d, u, v, limit;
    int i;

    cI(&a);
    cI(&b);
    cI(&c);
    cI(&d);
    cI(&u);
    cI(&v);

    cIasint(&limit, 1);
    IslasD(&limit, LIMIT);	/* 2^300 */

    for (i = 0; i < NLOOPS; i++)
    {
	IasrandomI(&a, &limit);
	IasrandomI(&b, &limit);
/*		fprintI(stdout, &a);
		printf("\n");
		fprintI(stdout, &b);
		printf("\n");
*/
/* Addition */
	IasIplI(&c, &a, &b);
	ImiasI(&c, &b);
	if (IneI(&c, &a))
	{
	    printf("Error: IasIplI/ImiasI\n");
	    fprintI(stdout, &a);
	    printf("\n");
	    fprintI(stdout, &b);
	    printf("\n");
	    printInt(&a);
	    printInt(&b);
	    exit(1);
	}
/* Multiplikation */
	IasImuI(&c, &a, &b);
	IdiasI(&c, &b);
	if (IneI(&c, &a))
	{
	    printf("Error: IasImuI/IdiasI\n");
	    fprintI(stdout, &a);
	    printf("\n");
	    fprintI(stdout, &b);
	    printf("\n");
	    printInt(&a);
	    printInt(&b);
	    exit(1);
	}
/* Shifts */
	IasIslD(&c, &a, Ilog(&b));
	IsrasD(&c, Ilog(&b));
	if (IneI(&c, &a))
	{
	    printf("Error: IasIslD/IsrasD\n");
	    fprintI(stdout, &a);
	    printf("\n");
	    fprintI(stdout, &b);
	    printf("\n");
	    printInt(&a);
	    printInt(&b);
	    exit(1);
	}
/* Gcd */
	Ixgcd(&d, &u, &v, &a, &b);
	ImuasI(&u, &a);
	ImuasI(&v, &b);
	IasIplI(&c, &u, &v);
	if (IneI(&c, &d))
	{
	    printf("Error: Ixgcd\n");
	    fprintI(stdout, &a);
	    printf("\n");
	    fprintI(stdout, &b);
	    printf("\n");
	    printInt(&a);
	    printInt(&b);
	    exit(1);
	}
	Idgcd(&c, &a, &b);
	if (IneI(&c, &d))
	{
	    printf("Error: Idgcd\n");
	    fprintI(stdout, &a);
	    printf("\n");
	    fprintI(stdout, &b);
	    printf("\n");
	    printInt(&a);
	    printInt(&b);
	    exit(1);
	}
/* BGcd */
	Ibxgcd(&d, &u, &v, &a, &b);
	ImuasI(&u, &a);
	ImuasI(&v, &b);
	IasIplI(&c, &u, &v);
	if (IneI(&c, &d))
	{
	    printf("Error: Ibxgcd\n");
	    fprintI(stdout, &a);
	    printf("\n");
	    fprintI(stdout, &b);
	    printf("\n");
	    printInt(&a);
	    printInt(&b);
	    exit(1);
	}
	Ibgcd(&c, &a, &b);
	if (IneI(&c, &d))
	{
	    printf("Error: Ibgcd\n");
	    fprintI(stdout, &a);
	    printf("\n");
	    fprintI(stdout, &b);
	    printf("\n");
	    printInt(&a);
	    printInt(&b);
	    exit(1);
	}

    }
    dI(&a);
    dI(&b);
    dI(&c);
    dI(&d);
    dI(&u);
    dI(&v);
    dI(&limit);
    exit(0);
}
