//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : my_timer.c
// Author      : Victor Shoup, Thomas Pfahler (TPf)
// Last change : TPf, Feb 29, 1996, initial version
//             


#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:Fp_polynomial_util.h>
#else
#include <LiDIA/Fp_polynomial_util.h>
#endif


lidia_size_t next_power_of_two(lidia_size_t m)
{
  	debug_handler( "tools.c", "next_power_of_two ( lidia_size_t )" );
	lidia_size_t k, n;
	n = 1;
	k = 0;
	while (n < m)
	{
	  	n = n << 1;
		k++;
	}
	return k;
}


lidia_size_t square_root(lidia_size_t n)
{
  	debug_handler( "tools.c", "square_root ( lidia_size_t )" );
	if (n <= 0)
	  	return 0;
	else if (n == 1)
	  	return 1;
	else
	  	return (lidia_size_t) sqrt((double) n);
}



my_timer::my_timer() : 
	msg(0)
{
  	t.set_print_mode(HMS_MODE);
}

void my_timer::start(const char* message)
{
	if (msg != 0)
	    delete[] msg;
	msg = new char[strlen(message)+1];
	if (msg == 0)
	    lidia_error_handler("my_timer","start( char* )::out of memory");
	strcpy(msg, message);
	t.start_timer();
}

void my_timer::stop()
{
	if (msg == 0)
	    return;
  	t.stop_timer();
	cerr<<msg<<"   ";
	t.print(cerr);
	cerr<<endl;
	delete[] msg;
	msg = 0;
}


