

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:gf2n.h>
#include <LiDIA:timer.h>
#else
#include <LiDIA/gf2n.h>
#include <LiDIA/timer.h>
#endif

const unsigned int tests = 10000;
const unsigned int jmax = 10;

main()
{
  unsigned int  deg;
  register unsigned int i, j;
  timer t;

  t.set_print_mode(HMS_MODE);

  cout << "\nInput Extension Degree: ";  cin >> deg;
  
  gf2n_init(deg);
  gf2n a;
  gf2n *tv;

  tv = new gf2n[tests+1];

  for (i=0; i<= tests; i++)
    randomize(tv[i]);

  t.start_timer();
  for (j = 0; j<jmax; j++)
    {
      for (i=0; i<tests; i++)
	add(a, tv[i], tv[i+1]);
    }
  t.stop_timer();
  cout<<"\n "<<jmax*tests<<" additions take time         "<<t<<flush;

  t.start_timer();
  for (j = 0; j<jmax; j++)
    {
      for (i=0; i<tests; i++)
      square(a, tv[i]);
    }
  t.stop_timer();
  cout<<"\n "<<jmax*tests<<" squarings take time          "<<t<<flush;

  t.start_timer();
  for (j = 0; j<jmax; j++)
    {
      for (i=0; i<tests; i++)
	multiply(a, tv[i], tv[i+1]);
    }
  t.stop_timer();
  cout<<"\n "<<jmax*tests<<" multiplications take time   "<<t<<flush;

  t.start_timer();
  for (j = 0; j<jmax; j++)
    {
      for (i=0; i<tests; i++)
	invert(a, tv[i]);
      t.stop_timer();
    }
  cout<<"\n "<<jmax*tests<<" inversions take time        "<<t<<flush;
  cout<<"\n\n";
}
