//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995, 1996 by the LiDIA Group
//
// File        : bigrational_polynomial.cc
// Author      : Stefan Neis (SN)

/*
$Id: bigrational_polynomial.c,v 1.4 1997/01/21 22:27:09 neis Exp $
*/

#include <LiDIA/bigrational.h>

#include <LiDIA/polynomial.h>
#ifndef LIDIA_INCLUDE_C
#include <LiDIA/polynomial.c>
#endif

#ifdef __GNUG__
template class base_polynomial <bigrational>;

template void negate(base_polynomial <bigrational> & c,
		     const base_polynomial <bigrational> &a);

template void add(base_polynomial <bigrational> & c,
		  const base_polynomial <bigrational> & a,
		  const base_polynomial <bigrational> & b);
template void add(base_polynomial <bigrational> & c,
		  const base_polynomial <bigrational> & a,
		  const bigrational & b);
template void add(base_polynomial <bigrational> & c,
		  const bigrational & b,
		  const base_polynomial <bigrational> & a);

template void subtract(base_polynomial <bigrational> & c,
		       const base_polynomial <bigrational> & a,
		       const base_polynomial <bigrational> & b);
template void subtract(base_polynomial <bigrational> & c,
		       const base_polynomial <bigrational> & a,
		       const bigrational & b);
template void subtract(base_polynomial <bigrational> & c,
		       const bigrational & b,
		       const base_polynomial <bigrational> & a);

template void multiply(base_polynomial <bigrational> & c,
		       const base_polynomial <bigrational> & a,
		       const base_polynomial <bigrational> & b);
template void multiply(base_polynomial <bigrational> & c,
		       const base_polynomial <bigrational> & a,
		       const bigrational & b);
template void multiply(base_polynomial <bigrational> & c,
		       const bigrational & b,
		       const base_polynomial <bigrational> & a);

template void power(base_polynomial <bigrational> & c, 
		    const base_polynomial <bigrational> & a, const bigint & b);

template void derivative(base_polynomial <bigrational> &c,
			 const base_polynomial <bigrational> &a);

template void power(base_polynomial <bigrational> & c, 
		    const base_polynomial <bigrational> & a, const bigint & b);

template base_polynomial <bigrational> 
derivative(const base_polynomial <bigrational> &a);

template istream & operator >> (istream &,
				base_polynomial <bigrational> &);
template ostream & operator << (ostream &,
				const base_polynomial <bigrational> &);


template class field_polynomial <bigrational>;

template void div_rem(field_polynomial <bigrational> &q,
		      field_polynomial <bigrational> &r,
		      const base_polynomial <bigrational> &a,
		      const base_polynomial <bigrational> &b);
template void divide(field_polynomial <bigrational> & c,
		     const base_polynomial <bigrational> & a,
		     const bigrational & b);
template void power_mod(field_polynomial <bigrational> & c, 
			const base_polynomial <bigrational> & a,
			const bigint & b,
			const base_polynomial <bigrational> & f);

template void integral(field_polynomial <bigrational> &c,
		       const base_polynomial <bigrational> &a);

template field_polynomial <bigrational>
gcd(const base_polynomial <bigrational> &aa,
    const base_polynomial <bigrational> &bb);
    
template field_polynomial <bigrational>
xgcd(field_polynomial <bigrational> &x,
     field_polynomial <bigrational> &y,
     const base_polynomial <bigrational> &aa,
     const base_polynomial <bigrational> &bb);
#endif

  /**
   ** Cast operators:
   **/

polynomial<bigrational>::operator base_polynomial<bigfloat>() const{
  base_polynomial <bigfloat> x;
  x.set_degree(deg);
  for (lidia_size_t i = 0; i <= deg; i++)
    x[i] = bigfloat(coeff[i].numerator(), coeff[i].denominator());
  return x;
}

polynomial<bigrational>::operator base_polynomial<bigcomplex>() const{
  base_polynomial <bigcomplex> x;
  x.set_degree(deg);
  for (lidia_size_t i = 0; i <= deg; i++)
    x[i] = bigcomplex(bigfloat(coeff[i].numerator(),
			       coeff[i].denominator()));
  return x;
}

