.TH BLAS L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
IDAMAX, DASUM, DAXPY, DCOPY, DDOT, DNRM2, DROT, DROTG, DSCAL, DSWAP
.SH DECLARATIONS
.nf
integer function IDAMAX(n,x,incx)
integer n, incx
double precision x(n)
.sp
double precision function DASUM(n,x,incx)
integer n, incx
double precision x(n)
.sp
subroutine DAXPY(n,a,x,incx,y,incy)
integer n, incx, incy
double precision a(n), x(n), y(n)
.sp
subroutine DCOPY(n,x,incx,y,incy)
integer n, incx, incy
double precision x(n), y(n)
.sp
double precision function DDOT(n,x,incx,y,incy)
integer n, incx, incy
double precision x(n), y(n)
.sp
double precision function DNRM2(n,x,incx)
integer n, incx
double precision x(n)
.sp
subroutine DROT(n,x,incx,y,incy,c,s)
integer n, incx, incy
double precision x(n), y(n), c, s
.sp
subroutine DROTG(a,b,c,s)
double precision a, b, c, s
.sp
subroutine DSCAL(n,a,x,incx)
integer n, incx
double precision a, x(n)
.sp
subroutine DSWAP(n,x,incx,y,incy)
integer n, incx, incy
double precision x(n), y(n)
.fi
.SH SYNOPSIS
The Basic Linear Algebra Subprograms, BLAS, are
FORTRAN subprograms to perform basic
vector operations.
.PP
The BLAS were first described
in Lawson, et. al.,[2]. 
Lobo.lib uses a set of 8
of the BLAS; the source for 7 of the routines
were taken from LINPACK[1], and one, DNRM2, was
taken from EISPACK.
.sp
IDAMAX finds the index of the element having the maximum
absolute value of a vector.
.sp
DASUM returns the sum of the
absolute values of the elements of a vector.
.br
DASUM~=~\fI|x(1)^|\fR~+~...~+~\fI|x(n)^|\fR
.sp
DAXPY computes a constant times a vector plus a vector.
.br
\fIy(i)\fR~=~\fIy(i)\fR~+~\fIa\*(STx(i)\fR, \fIi\fR~=~1,~...~,\fIn\fR.
.sp
DCOPY copies vector \fIx\fR to vector \fIy\fR.
.sp
DDOT forms the dot product of two vectors.
.br
DDOT~=~\fIx(1)\*(STy(1)\fR~+~...~+~\fIx(n)\*(STy(n)\fR
.sp
DNRM2 returns the Euclidean, L2, norm of vector \fIx\fR.
.br
DNRM2~=~\fIsqrt~(sum(~x(i)\*(STx(i)~),(i\fR~=~1,~...,~\fIn))\fR
.sp
DROT computes the Givens rotation of vector \fIx\fR and vector \fIy\fR.
.br
\fIx(i)\fR~=~\fIc\*(STx(i)\fR~+~\fIs\*(STy(i)\fR
.br
\fIy(i)\fR~=~\fIc\*(STy(i)\fR~-~\fIs\*(STx(i)\fR
.sp
DROTG computes the constants \fIc\fR and \fIs\fR that are used in DROT.
.br
\fIc\*(STa\fR~+~\fIs\*(STb\fR~=~\fIsqrt(a\*(STa\fR~+~\fIb\*(STb)\fR
.br
\fIc\*(STb\fR~-~\fIs\*(STa\fR~=~0
.sp
DSCAL returns a vector \fIx\fR times a constant \fIa\fR.
\fIx(i)\fR~=~\fIa\*(STx(i)\fR,~\fIi\fR~=~1,~...,~\fIn\fR
.sp
DSWAP interchanges two vectors.
.SH PARAMETERS
For all routines:
.TP 12
n
The number of elements in all vectors passed into any one
routine.
.TP 12
x, y
vectors of length at least \fIn\fR.
.TP 12
incx, incy
The increment between elements in the storage of \fIx\fR and \fIy\fR.
These parameters allows the BLAS to operate on vectors
whose elements are not contiguous
in memory.  For example, given a matrix with the
declaration \fIA(20,10)\fR, a row vector of \fIA\fR would have an
\fIincx\fR = 20.
.TP 12
a, b, c, s
Generally are used as constants.
These may be single elements of a vector.
DROTG is the only routine that returns values in these
parameters.
.SH DETAILS
.PP
The BLAS are self-explanatory.  For more information see
Appendix A of the LINPACK User's Manual and/or the article
by Lawson, et. al.
.SH REFERENCES
.IP [1]
Dongarra, J. J., J. R. Bunch, C. B. Moler, G. W. Stewart,
\fBLINPACK Users' Guide\fR,
Society for Industrial and Applied Mathematics, Philadelphia, 1979.
.IP [2]
Lawson, D., R. Hanson, D. Kincaid and F. Krogh, 
\fIBasic Linear Algebra Subprograms for FORTRAN usage\fR,
ACM Trans. Math. Software, Vol. 5, No. 3, pp. 308-371, 1979.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
