.TH DGEEV L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.SH NAME
DGEEV
.SH DECLARATIONS
.nf
subroutine DGEEV(A, lda, n, d, X, work, job, info)
integer lda, n, job, info
double precision A(lda,n), work(n)
complex double precision d(n), X(lda,n)
.fi
.SH SYNOPSIS
FORTRAN subroutine for computing the eigenvalues and, optionally, the
eigenvectors of real nonsymmetric matrices.  Uses several subroutines
from EISPACK[1].  Organized so that the input is real, and all internal
arithmetic is real, but the output can be regarded as FORTRAN complex.
.SH PARAMETERS
.TP 10
A(lda,n)
On input to DGEEV, \fIA\fR contains the matrix whose eigenvalues are
desired.
Upon return, the entire matrix has been altered.
.TP 10
lda
The leading dimension of the array \fIA\fR.
.TP 10
n
The order of the matrix.
.TP 10
d(n)
The complex eigenvalues, in no particular order.
.TP 10
X(lda,n)
The complex eigenvectors.
.br
\fIX(:,j)\fR is an eigenvector associated with \fId(j)\fR.
.br
The eigenvectors are scaled so that the largest, in magnitude,
component of each vector is 1.0.  If the input matrix does not
have a full set of linearly independent eigenvectors, then \fIX\fR
will be singular or badly conditioned.
.TP 10
work(n)
Work space.
.TP 10
job
Indicator of what is to be computed.
.RS
.br
.ns
.IP "0 - " 6
compute eigenvalues only.
.br
.ns
.IP "1 - "
compute both eigenvalues and eigenvectors.
.RE
.TP 10
info
Should be zero.  If it isn't, contact the UNM Math Software Project.
.SH DETAILS
The matrix is first scaled so that the norm
of each column is about the same as the norm of the corresponding row.
Then, the matrix is transformed to upper Hessenberg form
(upper triangular with one additional subdiagonal) using Householder
orthogonal similarity transformations.
Next, the implicit double shift QR algorithm is used
to reduce the Hessenberg matrix to a
pseudo triangular matrix.
If requested, the eigenvectors of the scaled matrix are
produced from information accumulated during the
calculation of the eigenvalues.
Then, the inverse of the original scaling transformation is
applied to the eigenvectors.
Finally, the output is rearranged so that
it acts like Fortran complex data storage, and the
eigenvectors are normalized.
.PP
DGEEV is a new driver that replaces the EISPACK driver RG.
The EISPACK routines BALANC, ORTHES, ORTRAN, HQR, HQR2, and
BALBAK are called from DGEEV to perform the calculations.
A new routine, DGEEVX is provided to transform the real output
from the EISPACK routines to complex output.
.SH EXAMPLE
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
.nf
c		Program to compute the eigenvalues and eigenvectors
c		of a real, nonsymmetric matrix.
c
		real\*(ST8 A(50,50),work(50)
		complex\*(ST16 d(50),X(50,50)
		integer n,lda
		data lda /50/
c
		n = ...
		do 20 i = 1, n
			do 10 j = 1, n
				a(i,j) = ...
	10		continue
	20	continue
c
		call dgeev(A,lda,n,d,X,work,1,info)
		if (info .ne. 0) write(6,\*(ST) 'dgeev did not converge'
c
		write(6,\*(ST) 'The eigenvalues are:'
		do 30 i = 1, n
			write(6,\*(ST) d(i)
	30	continue
c
		write(6,\*(ST) 'The eigenvectors are:'
		do 40 i = 1, n
			write(6,\*(ST) (X(i,j), j=1,n)
	40	continue
		end
.fi
.SH SECONDARY ROUTINES
.nf
BLAS: DNRM2
.SH REFERENCES
.fi
.IP [1]
B. T. Smith, J. M. Boyle, J. J. Dongarra, B. S. Garbow,
Y. Ikebe, C. B. Moler and V. C. Klema.
\fIMatrix Eigensystem Routines -- EISPACK User's Guide\fR,
\fBLecture Notes in Computer Science No. 6\fR,
Second Edition, Springer-Verlag, 1976.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
