.TH DPOCO L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
DPOCO, DPOFA, DPOSL, DPODI
.SH DECLARATIONS
.nf
subroutine DPOCO(A, lda, n, rcond, work, info)
integer lda, n, info
double precision A(lda,n), work(n), rcond

subroutine DPOFA(A, lda, n, info)
integer lda, n, info
double precision A(lda,n)

subroutine DPOSL(A, lda, n, b)
integer lda, n
double precision A(lda,n), b(n)

subroutine DPODI(A, lda, n, det, job)
integer lda, n, job
double precision A(lda,n), det(2)
.fi
.SH SYNOPSIS
FORTRAN subroutines taken from LINPACK
for performing linear algebra operations on
positive definite matrices.
.PP
A real matrix \fIA\fR is positive definite if and only if it is
symmetric, that is \fIA~=~transpose(A)\fR,
and the quadratic form
\fI(trans(x)\*(STA\*(STx)\fR is positive for all nonzero
vectors \fIx\fR.  A positive definite matrix also has
the property that \fIA~=~(trans(B)\*(STB)\fR for some
matrix \fIB\fR having linearly independent columns.
.PP
DPOCO calls DPOFA to obtain the Cholesky factorization
of a matrix,
\fIA~=~(trans(R)*R)\fR, then
estimates the reciprocal of the condition number, \fIrcond\fR,
of the matrix.
.PP
DPOSL uses the Cholesky factorization obtained from DPOCO
to solve a system of linear equations, \fIAx~=~b\fR.
.PP
DPODI uses the Cholesky factorization obtained from DPOCO
to estimate the determinant of the matrix and to provide the
inverse of the matrix.
.PP
DPODI may also be called with the factors returned from DQRDC for any
\fIn\fR by \fIp\fR matrix \fIX\fR to obtain the inverse and/or the
determinant of \fI(trans(X)\*(STX)\fR.
.PP
The output parameter \fIA\fR from DPOCO must not be
changed before subsequent calls to DPOSL or DPODI.
.PP
For general square matrices, non-square matrices,
orthogonal decompositions, and
singular value decompositions see the manual pages on
DGECO, DQRDC and DSVDC.
.SH PARAMETERS
.TP 10
A(lda,n)
Input, output of all routines.
.br
As input to DPOCO or DPOFA, \fIA\fR contains the matrix
to be factored.  Since the matrix is symmetric, only
the upper half of \fIA\fR is actually used.
DPOCO or DPOFA returns the \fI(trans(R)\*(STR)\fR factorization
of \fIA\fR, with \fIR\fR in its
upper triangle and the strict lower half of \fIA\fR unchanged.
The input to DPOSL and DPODI must be this unchanged output.
DPOSL does not change \fIA\fR,
but DPODI overwrites the upper triangle of \fIA\fR with
the upper half of the inverse of the
original matrix.
.sp
If DPODI is called with the factors of \fIX\fR from DQRDC,
the upper half of the inverse of \fI(trans(X)\*(STX)\fR is
returned.
.TP 10
lda
Input to all routines.
.br
The leading dimension of the array \fIA\fR.
.TP 10
n
Input to all routines.
.br
The order of the matrix.
.TP 10
rcond
Output from DPOCO.
.br
An estimate of the reciprocal of the condition number of \fIA\fR.
If \fIrcond\fR is so
small that \fI(1.0~+~rcond~=~1.0)\fR,
then \fIA\fR can usually be regarded as singular to working precision.
In this even neither DPOSL nor DPODI should be called.
See discussion of condition number under Details.
.TP 10
work(n)
Work space provided for DPOCO and DPODI.
.br
On return from DPOCO, if \fIA\fR is close to a singular matrix,
then \fIwork\fR will contain an approximate
null vector of \fIA\fR.
.TP 10
info
Output from DPOFA and DPOCO.
.br
If \fIinfo\fR is 0, it indicates that DPOSL
and DPODI can be safely used.
.br
If \fIinfo~=~k~<>~0\fR, then the leading minor of order \fIk\fR
is not positive definite.  The factorization is not completed.
.TP 10
b(n)
Input, output from DPOSL.
.br
Input is the right hand side of a system of
simultaneous linear equations, \fIAx~=~b\fR.  DPOSL
overwrites it with the solution, \fIx\fR.
.TP 10
job
Input to DPODI.
.br
Indicator of what is to be computed by DPODI.
.RS
.br
.ns
.IP "    1 - "
return the inverse only
.br
.ns
.IP "   10 - "
return the determinant only
.br
.ns
.IP "   11 - "
return both the determinant and the inverse
.RE
.TP 10
det(2)
Output from DPODI.
.br
If the determinant is requested, (see \fIjob\fR), DPODI returns
determinant of the matrix \fIA\fR such that
\fIDETERMINANT~=~det(1)~\*(ST~10.0\*(ST\*(STdet(2)\fR with
\fI(1.0~<=~|det(1)^|~<~10.0)\fR or \fI(det(1)~=~0.0)\fR.
.sp
If DPODI is called with the factors of \fIX\fR from DQRDC,
the determinant of \fI(trans(X)\*(STX)\fR is
returned.
.SH DETAILS
.TP 5
DPOFA
For any positive definite matrix, \fIA\fR, there is an upper
triangular matrix \fIR\fR such that \fIA~=~(trans(R)\*(STR)\fR.
In these routines, this
factorization is obtained through the Cholesky algorithm.
.TP 5
DPOCO
DPOCO obtains the Cholesky factorization of a matrix from
DPOFA then uses those factors to estimate the reciprocal
of the condition number.
.TP 5
Condition Number
Given a linear system, \fIAx~=~b\fR, the condition number of \fIA\fR
measures the sensitivity of the solution \fIx\fR to errors in the matrix
\fIA\fR and the right hand side \fIb\fR.
For the purpose of evaluating the effect of machine precision
on calculations performed by these subroutines, a matrix
can be considered to at least have errors relative to
machine precision.
.sp
In order to avoid overflow problems,
DPOCO computes the reciprocal of the condition number, \fIrcond(A)\fR,
such that
\fIrcond(A)~=~1/(^||A^||\*(ST(estimate~of~||inv(A)^||))\fR.
The estimate of \fI||inv(A)^||\fR is calculated without
explicitly forming the inverse.
If \fIrcond(A)\fR
is approximately \fI10\*(ST\*(ST-d\fR then the elements of \fIx\fR
can usually be expected to
have \fId\fR fewer significant digits of accuracy than
the elements of \fIA\fR.
If \fIrcond\fR
is small enough that \fIrcond~+~1.0~=~1.0\fR, then the matrix \fIA\fR
is probably singular to working precision, i.e. the solution \fIx\fR
or the inverse of \fIA\fR cannot be calculated accurately, and
may cause overflow problems in the routines DPOSL and DPODI.
For further discussion of the condition number of a matrix, see
the Introduction to the LINPACK Users' Guide.
.TP 5
DPOSL
DPOSL solves the linear system \fIAx~=~b\fR,
by first solving \fItrans(R)y~=~b\fR, then \fIRx~=~y\fR.
.TP 5
DPODI
DPODI returns the determinant of \fIA\fR, \fIdet(A)\fR, and
and the inverse of \fIA\fR, \fIinv(A)\fR, by calculating
\fIdet(A)~=~det(trans(R))\*(STdet(R)\fR, and
\fIinv(A)~=~inv(R)\*(STinv(trans(R))\fR.
.LP
Ordinarily, DPOCO or DPOFA is called once to factor a particular matrix
and then DPOSL can be called to apply the factorization
as many times as needed.
If you are certain the matrix is well conditioned, DPOFA can be
called directly instead of using DPOCO.
.SH EXAMPLES
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
.nf
c		Program to factor a matrix, then solves the system
c		Ax = b, if A is positive definite and not near singular.
c		Note that only the upper triangle of the symmetric
c		matrix is generated.
c
		double precision a(50,50),b(50),work(50),rcond
		integer n,lda
		data lda /50/
		n = ...
		do 20 j = 1,n
			do 10 i = 1,j
				a(i,j) = ...
	10		continue
	20	continue
		call dpoco(a,lda,n,rcond,work,info)
		if (info .ne. 0) write(6,*) 'matrix is not positive definite'
		write(6,*) 'rcond = ',d9.5
		if (rcond +1.d0 .eq. 1.d0) then
			write(6,*) 'matrix is singular to working precision'
		else
			do 30 i = 1,n
				b(i) = ...
	30		continue
			call dposl(a,lda,n,b)
			do 40 i = 1,n
				write(6,*) b(i)
	40		continue
		endif
		end


c		Program segment to show how to overwrite an n by k matrix C
c		with inv(A)\*(STC without explicitly forming inv(A).
c
		call dpofa(a,lda,n,info)
		if (info .ne. 0) then
			write(6,*) 'matrix is not positive definite'
		else
			do 10 j = 1,k
				call dposl(a,lda,n,ipvt,c(1,j),0)
	10		continue
		endif
.fi
.SH SECONDARY ROUTINES
BLAS: DAXPY, DDOT, DSCAL, DASUM, IDAMAX, DSWAP
.SH SEE ALSO
DGECO, DQRDC, DSVDC, BLAS
.SH REFERENCES
Dongarra, J. J., J. R. Bunch, C. B. Moler, G. W. Stewart,
\fBLINPACK Users' Guide\fR,
Society for Industrial and Applied Mathematics, Philadelphia, 1979.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
