.TH DQRDC L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ~
.tr ^\|
.SH NAME
DQRDC, DQRSL
.hy 0
.SH DECLARATIONS
.nf
subroutine DQRDC(X,ldx,n,p,qraux,jpvt,work,job)
integer ldx, n, p, jpvt(n), job
double precision X(ldx,p), qraux(p), work(n)

subroutine DQRSL(X,ldx,n,k,qraux,y,qy,qty,b,rsd,xb,job,info)
integer ldx, n, k, job, info
double precision X(ldx,k),qraux(k),y(n),qy(n),qty(n),b(k)
double precision rsd(n),xb(n)
.fi
.SH SYNOPSIS
FORTRAN subroutines taken from LINPACK for computing and using the
\fIQR\fR decomposition of a matrix.  The matrix need not be square.
.PP
DQRDC computes the \fIQR\fR decomposition of a matrix \fIX\fR.
The output from DQRDC can be used to determine linear dependencies
in the columns of \fIX\fR, to estimate the condition of \fIX\fR,
and can be used in situations requiring the
pseudo-inverse of \fIX\fR. The pivoting option
allows one to force the inclusion and/or exclusion of
specific columns of \fIX\fR in a least squares fit.
.PP
DQRSL uses the output from DQRDC to
compute coordinate transformations,
projections, and least squares solutions.
.PP
For solutions to the square system, \fIAx~=~b\fR,
where the matrix \fIA\fR is
reasonably well conditioned, the routines DGECO and DGESL
may be more suitable.  If \fIA\fR is positive definite, the
routines DPOCO and DPOSL should be used.  See the manual pages
on DGECO and DPOCO.  For singular value decompositions
see the manual page on DSVDC.
.PP
The output parameters from DQRDC
must not be changed before subsequent calls to DQRSL.
.PP
For more information see Chapter 9 of
the LINPACK Users' Guide.
.SH PARAMETERS
.TP 10
X(ldx,p)
On input to DQRDC, \fIX\fR contains
the matrix whose factorization is to be computed.
On output, the upper triangle of \fIX\fR
has been overwritten by the upper triangular matrix \fIR\fR
of the \fIQR\fR factorization such that
\fIQ\*(STR\fR equals a (possibly truncated) permutation of \fIX\fR.
Below its diagonal, \fIX\fR contains information from which the
orthogonal part, \fIQ\fR, of the decomposition can be recovered.
The permutation is described under \fIjpvt\fR.
.TP 10
ldx
The leading dimension of the array \fIX\fR.
.TP 10
n
The number of rows of the matrix \fIX\fR.
.TP 10
p
The number of columns of the matrix \fIX\fR.
Note, \fIn\fR need not equal \fIp\fR.
.TP 10
jpvt(n)
Vector of pivoting information.
.br
If pivoting is requested,
see \fIjob\fR, then the \fIk-th\fR column of \fIX\fR is classified
according to the input value of \fIjpvt(k)\fR
as follows:
.IP
\fIjpvt(k)~>~0, X(k)\fR is an initial column
.br
\fIjpvt(k)~=~0, X(k)\fR is a free column
.br
\fIjpvt(k)~<~0, X(k)\fR is a final column
.IP
Before the decomposition is computed, initial columns are moved
to the leading part of \fIX\fR and final columns to the
trailing part of \fIX\fR.  During the
reduction, only free columns are moved. At the
\fIk-th\fR step, if \fIX(k)\fR is a free column, it is interchanged
with the column with the largest
reduced 2-norm from the remaining free columns.
On output,
\fIjpvt(j)\fR contains the index of the column that was moved into column
\fIj\fR.
Thus, the matrix, \fIQ\*(STR\fR is a permutation of the original
matrix \fIX\fR, with the permutation described by \fIjpvt\fR.
The parameter \fIjpvt\fR is not referenced if \fIjob\fR is zero.
.TP 10
k
The number of columns, \fIk~<=~min(m,p)\fR,
of the matrix \fIX\fR to be used by DQRSL.
Specifically, \fIk\fR can be found such that the first \fIk\fR
columns of the permuted matrix \fIQ\*(STR\fR are a set of
linearly independent columns of the original matrix \fIX\fR.
Let \fIXk\fR denote this set of columns.
.TP 10
qraux(p)
Vector containing further
information required to recover the orthogonal part of the
decomposition.
This vector is computed in DQRDC and used in DQRSL.
.TP 10
work(n)
Vector of work space.  This parameter is not referenced if
\fIjob~=~0\fR.
.TP 10
job
Input to DQRDC, DQRSL.
.br
Indicator of what is to be computed.
.RS
.ns
.TP 8
DQRDC
\fIjob\fR initiates column pivoting.
.RS
.TP 6
0 -
no pivoting is done
.br
.ns
.TP 6
1 -
pivoting is done
.RE
.TP 8
DQRSL
\fIjob\fR has the decimal expansion ABCDE, where
.RS
.TP 20
A <> 0
compute \fIqy\fR
.br
.ns
.TP 20
B, C, D, or E <> 0
compute \fIqty\fR
.br
.ns
.TP 20
C <> 0
compute \fIb\fR
.br
.ns
.TP 20
D <> 0
compute \fIrsd\fR
.br
.ns
.TP 20
E <> 0
compute \fIxb\fR
.RE
.RE
.IP
Note that a request to compute \fIb, rsd\fR, or \fIxb\fR
automatically triggers the
computation of \fIqty\fR.
The parameters \fIqy, qty, b, rsd\fR, and \fIxb\fR are not
referenced if their computation
is not requested, and in this case can the replaced by
dummy variables in the calling program.
Specifically, if only one of \fIqy, qty, b, rsd\fR, and \fIxb\fR
is requested, to save storage, the same array may be used for
these parameters in the calling sequence.  If more than one
of \fIb, rsd,\fR or \fIxb\fR is requested, and \fIqty\fR
is not desired, the same array may be used for \fIqty\fR and one
of \fIb, rsd,\fR or \fIxb\fR.
.TP 10
y(n)
Vector to be manipulated by DQRSL.  See \fIqy, qty, b, rsd, xb\fR.
Usually used as input when solving the system \fIXb~=~y\fR.
If \fIy\fR is also used for any of the other vectors in
the calling sequence, it is overwritten by DQRSL, otherwise, it
is not changed.
.TP 10
qy(n)
On return from DQRSL, contains the vector \fIQ\*(STy\fR.
.TP 10
qty(n)
On return from DQRSL, contains the vector
\fItrans(Q)\*(STy\fR.
.TP 10
b(k)
On return from DQRSL, contains the solution
of the least squares problem
\fIminimize~||y~-~Xk\*(STb^||\fR
where \fIXk\fR refers to the set of \fIk\fR columns
of \fIX\fR discussed under the parameter \fIk\fR.
Note that if pivoting was done,
then \fIb(j)\fR will be associated with column \fIjpvt(j)\fR of
the original matrix \fIX\fR.
.TP 10
rsd(n)
On return from DQRSL, contains
the residual vector \fIy~-~Xk\*(STb\fR.
This is also the orthogonal projection of \fIy\fR onto the
orthogonal complement of the column space of \fIXk\fR.
.TP 10
xb(n)
On return from DQRSL, contains the least
squares approximation \fIXk\*(STb\fR.
It is also the projection of \fIy\fR onto the
column space of \fIXk\fR.
.TP 10
info
is zero unless the computation of \fIb\fR has been requested
and \fIR\fR is exactly singular.  In this case,
\fIinfo\fR is the index of the first zero diagonal
elements of \fIR\fR and \fIb\fR is left unaltered.
.SH DETAILS
.IP DQRDC
The \fIQR\fR decomposition is performed using Householder
transformations.  The pivoting option provides a
permutation of \fIX\fR so that the first \fIk\fR columns will be
linearly independent.
Theoretically, the number \fIk\fR is such that \fIk~=~min(n,p)\fR or
\fIR(k+1,k+1)\fR is the first
diagonal element that is zero.   Due to round-off error, diagonal
elements that are exactly zero rarely occur.  Thus, in practice,
\fIk\fR is usually chosen such that |\fIR(k+1,k+1)\fR^|
is small relative to |\fIR(1,1)\fR^|.
One measure of small could be
|\fIR(1,1)\fR^|~+~|\fIR(k+1,k+1)\fR^|~=~|\fIR(1,1)\fR^|.
.sp
If \fIX\fR has full rank \fIp\fR, then the pseudo-inverse of
\fIX\fR, \fIp-inv(X)\fR, is
given by the expression \fIp-inv(X)~=~inv(R)\*(STtrans(Q)\fR.
There is seldom any need to explicitly compute \fIp-inv(X)\fR.
For example, \fIp-inv(X)\*(STy\fR is the solution to least squares
problem \fImin ||y\fR-\fIX\*(STb^||\*(ST\*(ST2\fR, but
DQRSL returns this
solution  without forming \fIp-inv(X)\fR.
.sp
If \fIX\fR has full rank \fIp\fR, then
by using the pivoting option with the input vector \fIjpvt\fR
initialized to zero,
the condition of \fIX\fR can be estimated from the output of DQRDC
by \fIX(1,1)/X(p,p)\fR.
.sp
.IP DQRSL
Given the least squares problem of determining \fIb\fR such that
\fI||r^||\*(ST\*(ST2~=~||y~-~X\*(STb^||\*(ST\*(ST2\fR
is minimized, \fIb, r, Q\*(STy,
trans(Q)\*(STy\fR, and an approximation of \fIX\*(STb\fR can be
returned from DQRSL, see \fIjob\fR.
.SH EXAMPLES
.nf
.if t .ta .13i .5i .75i 1i
.if n .ta 3 7 11 14
C	Sample program for DQRDC and DQRSL
C
C	Solve the Least Square problem:
C		find b that minimizes ||y-Xb||
C		and what are the residuals
C
		double precision X(50,50),qraux(50),y(50),rsd(50),b(50),w(50)
		integer ldx,n,p,jpvt(50),job,i,j
		data ldx /50/
		n = 25
		p = 15
		do 20 j = 1,n
			do 10 i = 1,n
				a(i,j) = ...
	10		continue
	20	continue
C
C	allow column pivoting, all columns are free
		job = 1
		do 30 i = 1,n
			jpvt(i) = 0
	30	continue
		call dqrdc(X,ldx,n,p,qraux,jpvt,w,job)
C
C	Solve for b where Xb=y, res = y-Xb
C	Since qy, qty, or xb are not requested, the same storage
C	can be used for qty, res, qy and xb
C	Note, qy and xb will not be referenced
		job = 110
		call dqrsl(X,ldx,n,p,qraux,y,rsd,rsd,b,rsd,rsd,job,info)
		if (info .ne. 0) then
			write(6,*) 'Columns of X are dependant'
			write(6,*) 'starting with column ',info
		else
			write(6,*) 'b'
			mprint(b,ldx,p,1,0)
			write(6,*) 'residuals')
			mprint(res,ldx,n,1,0)
		endif
		end
.SH SECONDARY ROUTINES
.fi
BLAS: DAXPY, DDOT, DSCAL, DASUM, IDAMAX, DSWAP
.SH SEE ALSO
DPOCO, DGECO, DSVDC, BLAS
.SH REFERENCES
Dongarra, J. J., J. R. Bunch, C. B. Moler, G. W. Stewart,
\fBLINPACK Users' Guide\fR,
Society for Industrial and Applied Mathematics, Philadelphia, 1979.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
