.TH KQUAD L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.if t .ds ST  \v'.2m'*\v'-.2m'
.if n .ds ST *
.tr ^\|
.tr ~
.SH NAME
KQUAD
.SH DECLARATIONS
.nf
subroutine KQUAD(F,a,b,abserr,relerr,answer,errest,iflag,nf)
integer iflag,nf
double precision a,b,abserr,relerr,answer,errest
external F
.fi
.SH SYNOPSIS
FORTRAN subroutine
to estimate the definite integral of \fIF(t)\fR from \fIa\fR to \fIb\fR
using an adaptive quadrature scheme based on Gauss-Kronrod
algorithms.  This routine was taken from the text by Allen, Pruess,
and Shampine[1].
.PP
This routine works best on a function that reasonably smooth
within the interval.  That is, functions with singularities,
discontinuities, narrow spikes, etc, may not be evaluated
correctly or may result in an error condition in the procedure.
Methods for using KQUAD to integrate these types of
problems, as well as indefinite integrals, are
discussed in Allen[1].
.PP
A second routine, RQUAD, is available that
is based on the Gauss 8 point rule and uses a different
method of sub-interval exploration.
See the manual page on RQUAD.
.PP
For more information regarding quadrature see Forsythe[2] or Allen[1].
The QUADPACK[3] manual provides an extensive discussion on quadrature
along with routines for solving a large variety of problems.
.SH PARAMETERS
.TP 10
F
The name of the function subprogram defining \fIF(x)\fR.  This program
should have the form:
.RS
.ns
.IP
.nf
double precision function F(x)
double precision x
F = ...
return
end
.RE
.fi
.IP
The function name \fIF\fR must be declared in an EXTERNAL statement
in the calling program.
.TP 10
a, b
The end points of the interval of integration.
.TP 10
abserr,
.br
.ns
.TP 10
relerr
Respectively, the absolute and relative error tolerances desired.
.TP 10
answer
The computed estimate of integral.
.TP 10
errest
The computed estimate of absolute error in \fIanswer\fR.
.TP 10
nf
The number of \fIF\fR evaluations performed in the calculation
of \fIanswer\fR.
.TP 10
iflag
Indicator of error conditions
.RS
.IP "0 -"
for normal return
.IP "1 -"
too many subdivisions need to be stacked to achieve desired error
tolerance, (insufficient storage allocated
in internal queue)
.IP "2 -"
too many function evaluations (3500)
.IP "3 -"
\fIerrest\fR reached roundoff level
.RE
.SH DETAILS
.PP
An advantage of
a Gaussian rule is that the function is not evaluated at
the end points.
The Gauss-Kronrod (3-7) rule is used, because it provides an
efficient method for error estimation.
Discussion of Gauss-Kronrod
quadrature is found in QUADPACK[3].
.PP
An adaptive algorithm is one that automatically choses the size of
interval sub-divisions and creates more sub-divisions in
regions where the integration is more difficult, and fewer
sub-divisions where the function is smoothest.  KQUAD uses a queue to
maintain the set of sub-intervals needing further exploration.
A sub-interval meeting the \fIabserr/relerr\fR requirements
is dropped from the queue, otherwise it is further sub-divided
and the parts are placed back into the queue.  This results in
a horizontal, or breadth-first search of the tree of sub-intervals
explored.  The effect is that if the integration requires more
sub-divisions than allowed for in the routine, \fIiflag\fR~=~1,
the error in the answer will be spread relatively equally
among the various difficult regions of difficulty.
.SH EXAMPLES
.if t .ta .13i .5i 1i
.if n .ta 3 7 14
.nf
C		Sample driver for KQUAD
C
		EXTERNAL F
		DOUBLE PRECISION A,B,ABSERR,RELERR,ANSWER,ERREST
		INTEGER IFLAG,NF
		A = 0.0D0
		B = 1.0D0
		ABSERR = 1.0D-5
		RELERR = 0.0D0
		CALL KQUAD(F,A,B,ABSERR,RELERR,ANSWER,ERREST,IFLAG,NF)
		WRITE(6,10) ANSWER,ERREST
	10	FORMAT('    ANSWER=',E24.15,'    ERREST=',E18.10)
		WRITE(6,20) IFLAG,NF
	20	FORMAT('    IFLAG=',I2,'    NF=',I4)
		STOP
		END
C
		DOUBLE PRECISION FUNCTION F(X)
		DOUBLE PRECISION X
		F = DEXP(X)
		RETURN
		END
.fi
.SH SEE ALSO
RQUAD
.SH REFERENCES
.fi
.IP [1]
Allen R., Pruess S., Shampine L., \fBNumerical Computing\fR,
Math 375 Class Notes, 1984-85.  (To be published)
.IP [2]
Forsythe, G. E., M. A. Malcolm, C. B. Moler, \fBComputer Methods
for Mathematical Computations\fR. Prentice-Hall, Inc., 1977.
.IP [3]
Piessens, R., E. de Doncker-Kapenga, C. W. Uberhuber, D. K. Kahaner,
\fBQUADPACK, A Subroutine Package for Automatic Integration\fR,
Springer-Verlag, 1983.
.IP [4]
Shapiro, H., \fIIncreasing Robustness in Global Adaptive Quadrature
Through Interval Selection Heuristics\fR, Department of Computer
Science, College of Engineering, University of New Mexico,
Technical Report CS82-3, 1982.
.SH FURTHER INFORMATION
.nf
Contact:
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM  87131
