.TH MPRINT L LOCAL "1st UNM Distribution" "LOBO.LIB Users' Manual"
.hy 0
.tr ~ 
.SH NAME
MPRINT
.SH DECLARATIONS
.nf
subroutine MPRINT(A,lda,n,m,job)
integer lda, n, m, job
double precision A(lda,m)
.fi
.SH SYNOPSIS
MPRINT is a FORTRAN subroutine to `pretty-print' a matrix or vector.
.PP
Prints the matrix by segmenting it into
groups of contiguous columns, then sequentially printing
each segment with the columns aligned.
.PP
The routine automatically prints the matrix elements to look like
integers if that is possible.  Note, the elements of
the matrix must be double precision numbers.
The user can specify precision of 4 or 15 fractional digits
in either \fIf\fR format or \fId\fR format, or can
request the matrix be printed in hex.
See description of \fIjob\fR under parameters.
.SH PARAMETERS
.TP 8
A
Matrix to be printed.  \fIA\fR is a vector if \fIm\fR is equal to 1,
or \fIA\fR is a single value if both \fIn\fR and \fIm\fR are equal to 1.
.TP 8
lda
Leading dimension of \fIA\fR.
.TP 8
n
Number of rows of \fIA\fR.
.TP 8
m
Number of columns of \fIA\fR.
.TP 8
job
Format style.
0~<=~\fIjob\fR~<=~5
.RS
.ns
.IP "0 - "  6
let code choose format; chooses integer, 1 or 3.
.br
.ns
.IP "1 - "
short f format (f9.4)
.br
.ns
.IP "2 - "
long f (f19.15)
.br
.ns
.IP "3 - "
short d (d13.4)
.br
.ns
.IP "4 - "
long d (d24.15)
.br
.ns
.IP "5 - "
hex - one value per line by columns
.RE
.sp
For \fIjob\fR~<>~5,
the matrix is printed in integer
form, if possible.
Otherwise, the code will print the matrix
according to the users input.
.sp
If \fIjob\fR is 0, the code will choose the format (\fIi\fR, \fIshort f\fR
or \fIshort d\fR) showing the most significant digits.
.LP
.SH EXAMPLES
.if t .ta .5i 1i 
.if n .ta 7 14
.nf
c	Test program for the MPRINT routine.
c
	double precision a(10,10)
	lda = 10
	n = 2
	m = 3
	a(1,1) = 1.d0/3
	a(1,2) = -5.d0
	a(1,3) = 101.6d0
	a(2,1) = -3.0d-6
	a(2,2) = 43.d6
	a(2,3) = 0.08228376109d0
	write(6,*) '2X3 matrix A'
	write(6,*) '    routine chooses format, job = 0'
		call mprint(a,10,n,m,0)
	write(6,*) '    short f, job = 1'
		call mprint(a,10,n,m,1)
	write(6,*) '    long f, job = 2'
		call mprint(a,10,n,m,2)
	write(6,*) '    short d, job = 3'
		call mprint(a,10,n,m,3)
	write(6,*) '    row 2 of matrix A, long d, job = 4'
		call mprint(a(2,1),10,1,m,4)
	write(6,*) '    column 1 of matrix A, hex, job = 5'
		call mprint(a(1,1),10,2,1,5)
	write(6,*) '    column 2 of matrix A, short f, job = 1 requested,'
	write(6,*) '        but routine overides with integer'
		call mprint(a(1,2),10,2,1,1)
	end

Results of the above program:

  2X3 matrix A
      routine chooses format, job = 0

   3.3333d-01  -5.0000d+00   1.0160d+02
  -3.0000d-06   4.3000d+07   8.2284d-02


      short f, job = 1

   1.0d+07 *

   0.0000   -0.0000    0.0000
  -0.0000    4.3000    0.0000


      long f, job = 2

   1.0d+07 *

  0.000000033333333  -0.000000500000000   0.000010160000000
 -0.000000000000300   4.300000000000000   0.000000008228376


      short d, job = 3

   3.3333d-01  -5.0000d+00   1.0160d+02
  -3.0000d-06   4.3000d+07   8.2284d-02


      row 2 of matrix A, long d, job = 4

  -3.000000000000000d-06   4.300000000000000d+07   8.228376109000000d-02


      column 1 of matrix A, hex, job = 5

    COLUMN  1
      3FAAAAAAAAAAAAAB
      B749539B8887229F


      column 2 of matrix A, short f, job = 1 requested,
          but routine overides with integer

          -5
    43000000

.SH SECONDARY ROUTINES
FORMZ - machine dependent routine to print a number in
hex.
.SH AUTHORS
Originally written by Cleve Moler for MATLAB and
modified for use in LOBO.LIB.
.SH FURTHER INFORMATION
.nf
Mathematical Software Project
Computer Science Department
University of New Mexico
Albuquerque, NM 87131
