      SUBROUTINE KQUAD(F,A,B,ABSERR,RELERR,ANSWER,ERREST,IFLAG,NF)
      INTEGER IFLAG,NF
      DOUBLE PRECISION A,B,ABSERR,RELERR,ANSWER,ERREST
      EXTERNAL F
C
C   KQUAD ESTIMATES THE DEFINITE INTEGRAL OF F(T) FROM A TO B
C   USING AN ADAPTIVE QUADRATURE SCHEME BASED ON GAUSS-KRONROD
C   ALGORITHMS.
C
C  INPUT PARAMETERS
C     F = NAME OF FUNCTION SUBPROGRAM DEFINING F(X).  THIS PROGRAM
C         SHOULD HAVE THE FORM:
C            DOUBLE PRECISION FUNCTION F(X)
C            DOUBLE PRECISION X
C            F=...
C            RETURN
C            END
C         THE FUNCTION NAME F MUST APPEAR IN AN EXTERNAL STATEMENT
C         IN THE CALLING PROGRAM.
C     A, B = END POINTS OF INTEGRATION INTERVAL
C     ABSERR = ABSOLUTE ERROR TOLERANCE DESIRED
C     RELERR = RELATIVE ERROR TOLERANCE DESIRED
C
C  OUTPUT PARAMETERS
C     ANSWER = COMPUTED ESTIMATE OF INTEGRAL
C     ERREST = ESTIMATE OF ABSOLUTE ERROR IN ANSWER
C     NF = NUMBER OF F EVALUATIONS REQUIRED
C     IFLAG = 0  FOR NORMAL RETURN
C           = 1  INSUFFICIENT STORAGE IN QUEUE
C           = 2  TOO MANY FUNCTION EVALUATIONS (3500)
C           = 3  ERREST REACHED ROUNDOFF LEVEL
C
      EXTERNAL QUAD,ADD,REMOVE,EPSLON
C
C  LOCAL VARIABLES
C
      INTEGER BOTTOM,LENGTH,TOP,LQUEUE,NFMAX
      DOUBLE PRECISION ABSANS,ALPHA,BETA,H,E,EL,ER,Q,QL,QR,TOL,EPSLON
      DOUBLE PRECISION QUEUE(200,4),DABS,DMAX1
      DATA LQUEUE/200/,NFMAX/3500/
C
C  INITIALIZATION.
C
      LENGTH = 0
      TOP = 1
      BOTTOM = 1
      IFLAG = 0
      NF = 0
      CALL QUAD(F,A,B,ANSWER,ERREST,NF)
      IF(DABS(ERREST) .GT. DMAX1(ABSERR,RELERR*DABS(ANSWER)))
     &   CALL ADD(QUEUE,LQUEUE,ANSWER,ERREST,A,B,LENGTH,BOTTOM)
C
C  MAIN LOOP,  IF QUEUE IS EMPTY RETURN, ELSE SUBDIVIDE TOP ENTRY.
C
   20 IF (LENGTH .EQ. 0) RETURN
      CALL REMOVE(QUEUE,LQUEUE,Q,E,ALPHA,BETA,LENGTH,TOP)
      H = (BETA-ALPHA)/2.D0
      CALL QUAD(F,ALPHA,ALPHA+H,QL,EL,NF)
      CALL QUAD(F,ALPHA+H,BETA,QR,ER,NF)
C
C  UPDATE ANSWER AND ERROR ESTIMATE.
C
      ANSWER = ANSWER-Q+QL+QR
      ERREST = ERREST-E+EL+ER
C
C   TEST FOR FAILURES.
C
      ABSANS = DABS(ANSWER)
      IF (LENGTH .GE. LQUEUE-1) GOTO 30
      IF (NF .GE. NFMAX) GOTO 40
      IF (DABS(ERREST) .LE. EPSLON(ABSANS)) GOTO 50
C
C  TEST FOR CONVERGENCE .
C
      TOL = DMAX1(ABSERR,RELERR*ABSANS)
      IF (DABS(ERREST) .LE. TOL) RETURN
C
C  ADD NEW SUBINTERVALS TO QUEUE IF ERRORS ARE TOO BIG.
C
      TOL = TOL*H/(B-A)
      IF (DABS(EL) .GT. TOL)
     &  CALL ADD(QUEUE,LQUEUE,QL,EL,ALPHA,ALPHA+H,LENGTH,BOTTOM)
      IF (DABS(ER) .GT. TOL)
     &  CALL ADD(QUEUE,LQUEUE,QR,ER,ALPHA+H,BETA,LENGTH,BOTTOM)
      GOTO 20
C
C   FAILURE RETURNS.
C
   30 IFLAG = 1
      RETURN
   40 IFLAG = 2
      RETURN
   50 IFLAG = 3
      RETURN
      END
C
      SUBROUTINE ADD(QUEUE,LQUEUE,Q,E,ALPHA,BETA,LENGTH,BOTTOM)
      INTEGER LQUEUE,LENGTH,BOTTOM
      DOUBLE PRECISION QUEUE(LQUEUE,4),Q,E,ALPHA,BETA
C
C  ADDS THE INTERVAL TO THE END OF THE QUEUE
C
C  INPUT PARAMETERS
C     QUEUE = QUEUE OF INTERVALS TO BE EVALUATED
C     LQUEUE = MAXIMUM SIZE OF QUEUE
C     Q = QUADRATURE ESTIMATE FOR THIS INTERVAL 
C     E = ESTIMATE OF ERROR IN Q
C     ALPHA, BETA = END POINTS OF THIS INTERVAL
C     LENGTH = NUMBER OF INTERVALS ALREADY IN QUEUE
C     BOTTOM = POINTER TO NEXT FREE PLACE IN QUEUE
C
C  OUTPUT PARAMETERS
C     LENGTH, BOTTOM HAVE BEEN INCREMENTED BY 1
C
      QUEUE(BOTTOM,1) = Q
      QUEUE(BOTTOM,2) = E
      QUEUE(BOTTOM,3) = ALPHA
      QUEUE(BOTTOM,4) = BETA
      LENGTH = LENGTH+1
      IF (BOTTOM .LE. LQUEUE) BOTTOM = BOTTOM+1
      IF (BOTTOM .GT. LQUEUE) BOTTOM = 1
      RETURN
      END
C
      SUBROUTINE REMOVE(QUEUE,LQUEUE,Q,E,ALPHA,BETA,LENGTH,TOP)
      INTEGER LQUEUE,LENGTH,TOP
      DOUBLE PRECISION QUEUE(LQUEUE,4),Q,E,ALPHA,BETA
C
C  REMOVES AN INTERVAL FROM THE TOP OF THE QUEUE
C
C  INPUT PARAMETERS
C     QUEUE - QUEUE OF INTERVALS TO BE EVALUATED
C     LQUEUE - MAXIMUM SIZE OF QUEUE
C     LENGTH - NUMBER OF INTERVALS IN QUEUE
C     TOP - POINTER TO NEXT INTERVAL IN QUEUE TO BE EVALUATED
C
C  OUTPUT PARAMETERS
C     Q = QUADRATURE ESTIMATE FOR THIS INTERVAL 
C     E = ESTIMATE OF ERROR IN Q
C     ALPHA, BETA = END POINTS OF THIS INTERVAL
C     LENGTH, TOP ARE DECREMENTED BY 1
C
      Q = QUEUE(TOP,1)
      E = QUEUE(TOP,2)
      ALPHA = QUEUE(TOP,3)
      BETA = QUEUE(TOP,4)
      LENGTH = LENGTH-1
      IF (TOP .LE. LQUEUE) TOP = TOP+1
      IF (TOP .GT. LQUEUE) TOP = 1
      RETURN
      END
C
      SUBROUTINE QUAD(F,ALPHA,BETA,Q,E,NF)
      DOUBLE PRECISION F,ALPHA,BETA,Q,E
C
C  GAUSS-KRONROD(3,7) QUADRATURE OVER (ALPHA,BETA).
C
C     F = FUNCTION TO BE EVALUATED
C     ALPHA, BETA = END POINTS OF THIS INTERVAL
C     Q = QUADRATURE ESTIMATE FOR THIS INTERVAL 
C     E = ESTIMATE OF ERROR IN Q
C     NF = NUMBER OF FUNCTION CALLS
C
      INTEGER NF
      DOUBLE PRECISION E,F1,F2,F3,A(4),X(3),H,MID
      EXTERNAL F
      DATA A/-0.2870674656872221D0, 0.1046562260264672D0,
     &   0.4013974147759622D0, -0.4379723502304145D0/
      DATA X/0.7745966692414834D0, 0.9604912687080202D0,
     &    0.4342437493468026D0/
      H = (BETA-ALPHA)/2.D0
      MID = ALPHA+H
      F1 = F(MID-H*X(1))
      F2 = F(MID)
      F3 = F(MID+H*X(1))
      Q = H*(5.D0*(F1+F3)+8.D0*F2)/9.D0
      E = H*(A(2)*(F(MID-H*X(2)) + F(MID+H*X(2)))
     &     +A(4)*F2 + A(1)*(F1+F3)
     &     +A(3)*(F(MID-H*X(3)) + F(MID+H*X(3))))
      NF = NF+7
      RETURN
      END
