      SUBROUTINE MPRINT(A,LDA,N,M,FMT)
      DOUBLE PRECISION A(LDA,1)
      INTEGER LDA,N,M,FMT
C
C     MATRIX PRINT ROUTINE
C
C     PRETTY PRINTS A MATRIX BY SEGMENTING THE MATRIX INTO
C     GROUPS OF CONTIGUOUS COLUMNS, THEN PRINTING EACH SEGMENT
C     SEQUENTIALLY WITH THE COLUMNS ALIGNED.
C
C     INPUT
C       A     DOUBLE PRECISION(LDA,M)
C             MATRIX TO BE PRINTED
C
C       LDA   INTEGER
C             LEADING DIMENSION OF A
C
C       N     INTEGER
C             NUMBER OF ROWS OF A
C
C       M     INTEGER
C             NUMBER OF COLUMNS OF A
C
C       FMT   INTEGER - 0<=FMT<=5
C             FLAG FOR FORMAT STYLE.
C             0 -> LET CODE CHOOSE FORMAT
C             1 -> SHORT F FORMAT - F9.5
C             2 -> LONG F - 19.15
C             3 -> SHORT D - D13.4
C             4 -> LONG D - D24.15
C             5 -> HEX - ONE VALUE PER LINE BY COLUMNS
C             UNLESS HEX IS SPECIFIED, THE MATRIX WILL BE PRINTED
C             IN INTEGER FORM, IF POSSIBLE,
C             IF 0 IS SPECIFIED, THE CODE WILL CHOOSE A FORMAT TO
C             SHOW THE MOST DIGITS.
C             OTHERWISE, THE MATRIX WILL BE PRINTED ACCORDING TO
C             THE USERS CHOICE.
C
C
      DOUBLE PRECISION BIG,SML,TEMP,SCALE,RBUF(12)
      INTEGER FNO(6),FNL(6),TYP,KFMT,F,IBUF(12),I,J,MAXINT
      INTEGER KTEMP,KBIG,KSML,JINC,J1,J2,K
      DATA MAXINT /2147483647/
C
C     FORMAT NUMBERS
      DATA FNO /11,12,21,22,23,24/
C
C     NUMBER OF ELEMENTS PER LINE
      DATA FNL /12, 6, 8, 4, 6, 3/
C
C     FMT IS INPUT BY USER.  IT IS NOT RELEVANT IF ELEMENTS
C         CAN BE PRINTED AS INTEGERS.  BUT, USER CAN SPECIFY
C         PREFERENCE FOR F OR E FORMAT, AND FOR MORE DIGITS IN
C         FRACTION.
C     FMT   1       2       3       4       5
C         SHORT   LONG   SHORT E  LONG E    Z
C
C     ELEMENT TYPE
C     TYP   1       2
C         INTEGER  REAL
C
      KFMT = FMT
C
C     IF HEX IS DESIRED, PRINT ONE COLOUMN AT A TIME AND RETURN
C
      IF (KFMT .NE. 5) GO TO 10
        DO 5 J = 1,M
           WRITE(6,44)
           WRITE(6,45) J
           DO 5 I = 1,N
              CALL FORMZ(A(I,J))
   5    CONTINUE
      GO TO 90
  10  CONTINUE
C
C     INTEGER IS DEFAULT TYPE
C
         TYP = 1
         BIG = 0.0D0
         SML = 0.0D0
         KTEMP = 0
C
C     FIND LARGEST AND SMALLEST (NOT EQUAL 0) ELEMENTS IN MATRIX
C     DETERMINE IF ELEMENTS CAN BE WRITTEN AS INTEGERS
C
         DO 20 I = 1, N
            DO 20 J = 1,M
               TEMP = A(I,J)
               BIG = DMAX1(BIG,DABS(TEMP))
               IF (TEMP .EQ. 0.0D0) GO TO 15
               IF (SML .EQ. 0.0D0) SML = DABS(TEMP)
               SML = DMIN1(SML,DABS(TEMP))
   15          CONTINUE
C
C     PROTECT AGAINST INTEGER OVERFLOW
C
               IF (BIG .LE. MAXINT) KTEMP = TEMP
               IF (KTEMP .NE. TEMP) TYP = 2
   20    CONTINUE
C
C     EXPONENT OF LARGEST ELEMENT
C
         KBIG = 0
         IF (BIG .NE. 0.0D0) KBIG = DLOG10(BIG)
C
C     EXPONENT OF SMALLEST ELEMENT
C
         KSML = 0
         IF (SML .NE. 0.0D0) KSML = DLOG10(SML)
C
C     IF ALL "INTEGERS", BUT EXPONENT TOO LARGE, CHANGE TO FLOATING
C
         IF (TYP .EQ. 1 .AND. KBIG .GT. 9) TYP = 2
C
C     IF ALL "INTEGERS", DETERMINE FORMAT WIDTH AND PRINT
C
         IF (TYP .NE. 1) GO TO 30
            F = 1
            IF (KBIG .GT. 2) F = 2
            GO TO 50
   30    CONTINUE
C
C     START WITH "SIMPLEST" REAL FORMAT TYPE, IF NOT USER DEFINED
C
C     IF PRECISION WILL BE LOST SWITCH TO E-FORMAT
C
         IF (KFMT .NE. 0) GO TO 40
            KFMT = 1
            IF (KBIG .LE. 2 .AND. KBIG .GE. 0
     *                  .AND. KSML .LT. -4) KFMT = 3
            IF (KBIG .GT. 2 .AND. (KBIG-KSML .GE. 5)) KFMT = 3
   40    CONTINUE
C
C     SET FORMAT TYPE
C
            F = KFMT +2
   50    CONTINUE
C
C     DETERMINE IF "SCALE" FACTOR NEEDS TO BE PRINTED
C
         IF (-1 .LE. KBIG .AND. KBIG .LE. 1) KBIG = 0
         IF (KBIG .EQ. 2 .AND. KFMT .EQ. 1 .AND. TYP .EQ. 2) KBIG = 0
         IF (N*M.EQ.1 .AND. KBIG.NE.0 .AND. KFMT.LT.3 .AND. TYP.EQ.2)
     *   F = F+2
C
C     NUMBER OF COLUMNS THAT CAN BE PRINTED ON A LINE
C
         JINC = FNL(F)
         F = FNO(F)
         SCALE = 1.0D0
         IF (F.EQ.21 .OR. F.EQ.22) SCALE = 10.0D0**KBIG
         IF (SCALE .NE. 1.0D0) WRITE(6,41) SCALE
         DO 80 J1 = 1, M, JINC
            J2 = MIN0(M, J1+JINC-1)
            WRITE(6,44)
            IF (M .GT. JINC) WRITE(6,42) J1,J2
            DO 70 I = 1, N
               K = 0
               DO 60 J = J1, J2
                  K = K+1
                  IF (F .LT. 20) IBUF(K) = A(I,J)
                  IF (F .GE. 20) RBUF(K) = A(I,J)/SCALE
   60          CONTINUE
               IF (F .EQ. 11) WRITE(6,11)(IBUF(J),J=1,K)
               IF (F .EQ. 12) WRITE(6,12)(IBUF(J),J=1,K)
               IF (F .EQ. 21) WRITE(6,21)(RBUF(J),J=1,K)
               IF (F .EQ. 22) WRITE(6,22)(RBUF(J),J=1,K)
               IF (F .EQ. 23) WRITE(6,23)(RBUF(J),J=1,K)
               IF (F .EQ. 24) WRITE(6,24)(RBUF(J),J=1,K)
   70       CONTINUE
   80    CONTINUE

   90 CONTINUE
      WRITE(6,44)
C
   11 FORMAT(0X,12I6)
   12 FORMAT(0X,6I12)
   21 FORMAT(0X,F9.4,7F10.4)
   22 FORMAT(0X,F19.15,3F20.15)
   23 FORMAT(0X,1P6D13.4)
   24 FORMAT(0X,1P3D24.15)
   41 FORMAT(/0X,' ',1PD9.1,' *')
   42 FORMAT(0X,'    COLUMNS',I3,' THRU',I3)
   44 FORMAT(A1)
   45 FORMAT(0X,'    COLUMN',I3)
      RETURN
      END
