      double precision function rquad(F,left,right,tolran,nfunc,ok)
C     Formally derecursed version of Pascal function in
C     ~moler/lobo.lib/rquad.i
C     Modified by Brian Fisk (5/30/87)

      external F
      double precision left,right,tolran
      integer nfunc
      logical ok
C     F      -- function to integrate
C     left   -- left end point of entire interval
C     right  -- right end point of entire interval
C     tolran -- tolerance requested for integral over entire interval
C     nfunc  -- number of function calls
C     ok     -- flag returned; success or failure of  rquad  in its
C               own opinion.  If the desired accuracy cannot be achieved
C               in a reasonable number of steps, or because roundoff
C               error intervenes, or the stack depth is exceeded
C               (unlikely) the global variable ok is set to false.

      integer limit
      real sqrt3
      parameter(limit = 500, sqrt3 = 1.732)
C     limit  -- maximum number of bisection steps. 
C     sqrt3  -- fudge factor for changing error factor
C               sqrt(3) need not be accurate. 

C     stack required to simulate recursion
      integer depth,args,size
      parameter(depth=50,args=9,size=args*depth)
      double precision stack
      integer stktop
      common /stkstf/stack(size),stktop

      integer kount
C     kount  -- number of bisection steps performed

      double precision a,b,preapp,epslon,errfac
C     parameters to  impruv
C     a      -- left end point of interval
C     b      -- right endpoint of interval
C     preapp -- the approximation to the integral obtained from the
C               parent in the recursion
C     epslon -- the desired absolute accuracy
C     errfac -- estimates the ratio of the quadrature error on the
C               parent interval to the quadrature error on this
C               interval; a reasonable value has been determined
C               experimentally.  It starts at 1.0 on the top level of 
C               the recursion and it is decreased by a factor of
C               sqrt(3) with each level.

C     locals
      double precision dummy
      parameter (dummy = 0.0d0)

      double precision c,leftvl,rigtvl,approx,errest
      double precision Gauss8
      logical error
C     error  -- flag for stack overflow in  push
      
C     variables needed for the communication during derecursion
      integer retadd
      double precision impruv

C     initialize the stack
      stktop = 0

      ok = .true.
      kount = 0
      nfunc = 0

C     Record initial call to rquad (and impruv) from the outside
C     push(a,b,previous approximation,epsilon,error factor,c
C          result left half,result of right half,return address)
      call push(dummy,dummy,dummy,dummy,dummy,dummy,dummy,dummy,error,5)

C     Enter procedure from outside -- fake call by value
      a = left
      b = right
      preapp = Gauss8(F,a,b)
      nfunc = nfunc + 8
      epslon = tolran
      errfac = 1.0d0

C     This section of the code (recursive function impruv) attempts to
C     improve an approximation to the integral of  F(x)  over the
C     interval from  a  to  b .

    1 impruv = preapp
      kount = kount + 1
C     Have we done too much work already. 
      ok = ok .and. (kount .lt. limit)
C     if not okay then return from this recursive call
      if (.not. ok) goto 4

      c = a + (b-a)/2
      leftvl = Gauss8 (F, a, c)
      nfunc = nfunc + 8
      rigtvl = Gauss8 (F, c, b)
      nfunc = nfunc + 8
      approx = leftvl + rigtvl
      errest = errfac * abs(approx - preapp)

C     Is this approximation for this interval acceptable.
      if (errest .le. epslon) then
        impruv = approx
        goto 4
      elseif (abs(approx)+errest .eq. abs(approx)) then 
C       Check if we are reaching rounding error limits.
        ok = .false.
        goto 4
      else 
C       Bisect the interval and apply the algorithm recursively. 
        call push(a,b,preapp,epslon,errfac,c,leftvl,rigtvl,error,2)
C       Check for stack overflow -- an unlikely occurrence
        if (error) then
          ok = .false.
          goto 4
        endif
C       pass parameters
C       a = a
        b = c
        preapp = leftvl
        epslon = epslon/2.0d0
        errfac = errfac/sqrt3
C       make recursive call
        goto 1
      endif

2     leftvl = impruv
      call push(a,b,preapp,epslon,errfac,c,leftvl,rigtvl,error,3)
C     Stack overflow cannot occur, since it didn't on the last call
C     pass parameters
      a = c
C     b = b
      preapp = rigtvl
      epslon = epslon/2.0d0
      errfac = errfac/sqrt3
C     make recursive call
      goto 1

    3 impruv = leftvl + impruv 
    
C     Mimic return
C     return value for function set elsewhere
C     restore parameters and locals
    4 call pop(a,b,preapp,epslon,errfac,c,leftvl,rigtvl,retadd)
      goto(1,2,3,4,5)retadd

C     return to true caller
    5 rquad = impruv
      return
      end

      double precision function Gauss8(F,a,b)
C     Eight point Gaussian rule to approximate the integral of 
C     F(x) over the interval from a to b .
      external F
      double precision F,a,b

      double precision x1,w1,x2,w2,x3,w3,x4,w4
      parameter(
     1      x1 = 0.18343464249564980494d0, 
     2      w1 = 0.36268378337836198297d0,
     3      x2 = 0.52553240991632898582d0,  
     4      w2 = 0.31370664587788728734d0,
     5      x3 = 0.79666647741362673959d0,  
     6      w3 = 0.22238103445337447054d0,
     7      x4 = 0.96028985649753623168d0,  
     8      w4 = 0.10122853629037625915d0)
      
      double precision h,x

      h = (b - a)/2
      x = a + h
      Gauss8 = h*( (w1*(F(x-x1*h) + F(x+x1*h)) 
     1       + w2*(F(x-x2*h) + F(x+x2*h)))
     2       +(w3*(F(x-x3*h) + F(x+x3*h)) 
     3       + w4*(F(x-x4*h) + F(x+x4*h))) )
      return
      end

      subroutine push(a,b,preapp,epslon,errfac,c,leftvl,rigtvl,
     1                error,retadd)
      double precision a,b,preapp,epslon,errfac,c,leftvl,rigtvl
      logical error
      integer retadd

      integer depth,args,size
      parameter(depth=50,args=9,size=args*depth)
      double precision stack
      integer stktop
      common /stkstf/stack(size),stktop

      stktop = stktop+args
      if (stktop .gt. size) then
        error = .true.
        return
      endif
      error = .false.
      stack(stktop-8) = a
      stack(stktop-7) = b
      stack(stktop-6) = preapp
      stack(stktop-5) = epslon
      stack(stktop-4) = errfac
      stack(stktop-3) = c
      stack(stktop-2) = leftvl
      stack(stktop-1) = rigtvl
      stack(stktop  ) = retadd
      return
      end

      subroutine pop(a,b,preapp,epslon,errfac,c,leftvl,rigtvl,retadd)
      double precision a,b,preapp,epslon,errfac,c,leftvl,rigtvl
      integer retadd

      integer depth,args,size
      parameter(depth=50,args=9,size=args*depth)
      double precision stack
      integer stktop
      common /stkstf/stack(size),stktop

C     No possibility of stack underflow
      retadd = stack(stktop  )
      rigtvl = stack(stktop-1)
      leftvl = stack(stktop-2)
      c = stack(stktop-3)
      errfac = stack(stktop-4)
      epslon = stack(stktop-5)
      preapp = stack(stktop-6)
      b = stack(stktop-7)
      a = stack(stktop-8)
      stktop = stktop-args
      return
      end

