


MPS2EQ(1ES)         UNIX Programmer's Manual          MPS2EQ(1ES)



NAME
     mps2eq    - convert mps format to an equations format suit-
     able for lp_solve

SYNOPSIS
     mps2eq [option]* "<" <mps-file>

OPTIONS
     -h          Help mode, prints the usage

     -d          Debug mode, print debug information.

DESCRIPTION
     Mps2eq converts (MI)LP problems in mps format to an equa-
     tions format suitable for lp_solve. MI and FR bounds are not
     supported, because lp_solve cannot handle them.
     There are things you can do in mps which will not work with
     lp_solve:

     -    use spaces ( ), comma's (,), plus (+) or minus (-)
          signs in variable names.

INPUT SYNTAX
     According to the files MPS_FORMAT_GREGORY and
     MPS_FORMAT_MIPLIB in the source directory of mps2eq.

OUTPUT SYNTAX
     According to the specifications in the manual page of
     lp_solve.

EXAMPLE
     NAME          TESTPROB
     ROWS
      N  COST
      L  LIM1
      G  LIM2
      E  MYEQN
     COLUMNS
         XONE      COST                 1   LIM1                 1
         XONE      LIM2                 1
         YTWO      COST                 4   LIM1                 1
         YTWO      MYEQN               -1
         ZTHREE    COST                 9   LIM2                 1
         ZTHREE    MYEQN                1
     RHS
         RHS1      LIM1                 5   LIM2                10
         RHS1      MYEQN                7
     BOUNDS
      UP BND1      XONE                 4
      LO BND1      YTWO                -1
      UP BND1      YTWO                 1
     ENDATA



Printed 10/22/93                                                1






MPS2EQ(1ES)         UNIX Programmer's Manual          MPS2EQ(1ES)



     will be translated to:

     /* MPS name: TESTPROB */

     /* objective function: */
     min: + 9 ZTHREE + 4 YTWO + 1 XONE ;

     /* constraints */
     MYEQN : + 1 ZTHREE + -1 YTWO = 7;
     LIM2 : + 1 ZTHREE + 1 XONE >= 10;
     LIM1 : + 1 YTWO + 1 XONE <= 5;

     /* Bounds: */
     YTWO <= 1;
     XONE <= 4;
     YTWO >= -1;

BUGS
     If the mps file contains spaces in variable (column) or con-
     straint (row) names, mps2eq will only pick up the first part
     of the names. This usually means that your output is wrong.

SEE ALSO
     lp_solve(1)

CONTRIBUTED BY
     M.R.C.M. Berkelaar
     Eindhoven University of Technology
     Design Automation Section
     P.O. Box 513
     NL-5600 MB Eindhoven, The Netherlands
     phone +31 40 473345
     E-mail: michel@es.ele.tue.nl

STATUS
     Use at own risk. Bug reports are welcome.



















Printed 10/22/93                                                2



