C      ________________________________________________________
C     |                                                        |
C     |              SOLVE A FACTORED BAND SYSTEM              |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --BFACT'S OUTPUT                         |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,MIN0,MAX0                    |
C     |________________________________________________________|
C
      SUBROUTINE BSOLVE(X,A,B)
      REAL A(1),B(1),X(1),T
      INTEGER I,J,K,L,M,N,O,P,Q
      T = A(1)
      IF ( ABS(T) .EQ. 1231 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH BFACT BEFORE SOLVING'
      STOP
10    N = A(2)
      L = A(4)
      M = A(5)
      O = L + M
      M = 1 + L + O
      J = 5 - L
      K = 0
      IF ( T .LT. 0. ) GOTO 90
      DO 20 I = 1,N
20         X(I) = B(I)
      Q = 1
      IF ( L .GT. 0 ) GOTO 40
      K = N
      J = J + M*N
      IF ( M .GT. 1 ) GOTO 60
C     -------------------------
C     |*** DIAGONAL MATRIX ***|
C     -------------------------
      DO 30 K = 1,N
30         X(K) = X(K)/A(5+K+K)
      RETURN
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
40    J = J + M
      I = A(J+K-O)
      K = Q
      Q = K + 1
      IF ( K .EQ. N ) GOTO 60
      T = X(I)
      X(I) = X(K)
      X(K) = T
      IF ( T .EQ. 0 ) GOTO 40
      P = MIN0(K+L,N)
      DO 50 I = Q,P
50         X(I) = X(I) - T*A(I+J)
      GOTO 40
C     --------------------------------------
C     |*** BACK SUBSTITUTION BY COLUMNS ***|
C     --------------------------------------
60    T = X(K)/A(J+K)
70    X(K) = T
      IF ( K .EQ. 1 ) RETURN
      Q = MAX0(1,K-O)
      K = K - 1
      DO 80 I = Q,K
80         X(I) = X(I) - T*A(I+J)
      J = J - M
      GOTO 60
C     -----------------------------
C     |*** COMPUTE NULL VECTOR ***|
C     -----------------------------
90    J = J + M
      K = K + 1
      IF ( A(J+K) .NE. 0. ) GOTO 90
      DO 100 I = 1,N
100         X(I) = 0.
      T = 1.
      IF ( M .GT. 1 ) GOTO 70
      X(K) = 1.
      RETURN
      END
