C      ________________________________________________________
C     |                                                        |
C     |   MULTIPLY A REAL SYMMETRIC BAND MATRIX BY A VECTOR    |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --VECTOR                                 |
C     |                                                        |
C     |         A     --ARRAY CONTAINING DIAGONAL AND SUBDIAG- |
C     |                 ONAL BANDS FROM COEFFICIENT MATRIX     |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         H     --HALF BANDWIDTH                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         Y     --PRODUCT BETWEEN A AND X                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: MIN0                             |
C     |________________________________________________________|
C
      SUBROUTINE HMULT(Y,X,A,LA,N,H)
      INTEGER H,I,J,K,L,LA,M,N
      REAL A(LA,1),X(1),Y(1),R,S,T
      IF ( H .GT. 0 ) GOTO 20
      DO 10 I = 1,N
10         Y(I) = X(I)*A(1,I)
      RETURN
20    DO 30 I = 1,N
30         Y(I) = 0.
      K = 1
40    J = K
      K = K + 1
      S = X(J)
      T = A(1,J)*S
      IF ( K .GT. N ) GOTO 60
      M = 2 - K
      L = MIN0(J+H,N)
      DO 50 I = K,L
            R = A(I+M,J)
            T = T + R*X(I)
50          Y(I) = Y(I) + S*R
      Y(J) = Y(J) + T
      GOTO 40
60    Y(N) = Y(N) + T
      RETURN
      END
