C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE ORTHONORMAL BASIS FOR SPACE PERPENDICULAR TO A |
C     |               GIVEN COLLECTION OF VECTORS              |
C     |                                                        |
C     | INPUT:                                                 |
C     |                                                        |
C     |      A     --FACTORIZATION COMPUTED BY SUBROUTINE QR   |
C     |                   OF THE ARRAY OF VECTORS              |
C     |                                                        |
C     |      B     --ARRAY USED IN COMPUTATION OF BASIS        |
C     |                                                        |
C     |      LB    --LEADING (ROW) DIMENSION OF ARRAY B        |
C     |                                                        |
C     |      C     --CUTOFF                                    |
C     |                                                        |
C     | OUTPUT:                                                |
C     |                                                        |
C     |      B     --ORTHONORMAL BASIS                         |
C     |                                                        |
C     |      N     --NUMBER OF VECTORS IN THE BASIS            |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,MIN0                         |
C     |________________________________________________________|
C
      SUBROUTINE NULL(B,LB,N,A,C)
      INTEGER G,H,I,J,K,L,LB,M,N,O
      REAL  A(1),B(LB,1),C,T
      T = A(1)
      IF ( ABS(T) .EQ. 3230 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR ARRAY OF VECTORS USING'
      WRITE(6,*) 'SUBROUTINE QR BEFORE USING SUBROUTINE NULL'
      WRITE(6,*) 'TO COMPUTE A BASIS FOR THE NULL SPACE'
      STOP
10    M = A(2)
      N = A(3)
      IF ( LB .GE. M ) GOTO 20
      WRITE(6,*) 'ERROR: THE LEADING DIMENSION OF ARGUMENT B IN'
      WRITE(6,*) 'SUBROUTINE NULL MUST BE GREATER THAN OR EQUAL'
      WRITE(6,*) 'TO THE NUMBER OF COMPONENTS IN EACH BASIS VECTOR'
      STOP
20    K = 3
      L = MIN0(N,M)
      O = M + 1
      DO 30 J = 1,L
           IF ( ABS(A(J+K)) .LE. C ) GOTO 110
30         K = K + O
      IF ( N .LT. M ) GOTO 40
      N = 0
      RETURN
C     -----------------------------------
C     |*** COMPUTE ORTHONORMAL BASIS ***|
C     -----------------------------------
40    G = 3 + O*N - M
      K = M - N
50    L = K + N
      T = -A(L+G)
      DO 60 I = N,M
60         B(I,K) = T*A(I+G)
      B(L,K) = B(L,K) + 1.
      H = G
      L = N
70    J = L
      L = L - 1
      IF ( L .EQ. 0 ) GOTO 100
      H = H - O
      T = 0.
      DO 80 I = J,M
80         T = T + A(I+H)*B(I,K)
      B(L,K) = -T*A(L+H)
      DO 90 I = J,M
90         B(I,K) = B(I,K) - T*A(I+H)
      GOTO 70
100   K = K - 1
      IF ( K .GT. 0 ) GOTO 50
      N = M - N
      RETURN
110   N = J - 1
      IF ( N .GT. 0 ) GOTO 40
C     ------------------------------------
C     |*** NULL SPACE IS ENTIRE SPACE ***|
C     |*** RETURN THE IDENTITY MATRIX ***|
C     ------------------------------------
      N = M
      DO 130 J = 1,M
           DO 120 I = 1,M
120             B(I,J) = 0.
130        B(J,J) = 1.
      RETURN
      END
