C      ________________________________________________________
C     |                                                        |
C     |ESTIMATE 1-NORM CONDITION NUMBER OF A TRIDIAGONAL MATRIX|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         L,D,U --TFACT'S OUTPUT                         |
C     |                                                        |
C     |         B     --WORK ARRAY (LENGTH AT LEAST N)         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         TCON  --CONDITION NUMBER (IF ELIMINATION GENER-|
C     |                 ATES A ZERO ON THE DIAGONAL, TCON = -1)|
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |    PACKAGE SUBROUTINES: TSOLVE,TTRANS                  |
C     |________________________________________________________|
C
      FUNCTION TCON(L,D,U,B)
      REAL B(1),D(1),L(1),U(1),C,E
      INTEGER I,J,M,N
      C = D(1)
      IF ( ABS(C) .EQ. 1234 ) GOTO 10
      IF ( ABS(C) .EQ. 1238 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH TFACT BEFORE',
     1'ESTIMATING CONDITION'
      STOP
10    IF ( C .LT. 0. ) GOTO 110
      M = 0
      N = D(2)
      C = 1./D(2)
      DO 20 J = 1,N
20         B(J) = C
      GOTO 50
30    DO 40 J = 1,N
40         B(J) = 0.
      B(M) = 1.
50    CALL TSOLVE(B,L,D,U,B)
      C = 0.
      DO 70 J = 1,N
           C = C + ABS(B(J))
           IF ( B(J) .LT. 0. ) GOTO 60
           B(J) = 1.
           GOTO 70
60         B(J) = -1.
70    CONTINUE
      CALL TTRANS(B,L,D,U,B)
      I = 1
      DO 80 J = 1,N
80         IF ( ABS(B(I)) .LT. ABS(B(J)) ) I = J
      IF ( M .EQ. 0 ) GOTO 90
      IF ( M .EQ. I ) GOTO 100
      IF ( E .GE. C ) GOTO 100
90    M = I
      E = C
      GOTO 30
100   C = C*D(3)
      IF ( C .LT. 1. ) C = 1.
      TCON = C
      RETURN
110   TCON = -1.
      RETURN
      END
