
#include "vec_ZZ.h"


vector_impl(ZZ)

vector_eq_impl(ZZ)

vector_io_impl(ZZ)

void InnerProduct(ZZ& xx, const vector(ZZ)& a, const vector(ZZ)& b)
{
   ZZ t1, x;

   long n = min(a.length(), b.length());
   long i;

   clear(x);
   for (i = 1; i <= n; i++) {
      mul(t1, a(i), b(i));
      add(x, x, t1);
   }

   xx = x;
}

void mul(vector(ZZ)& x, const vector(ZZ)& a, const ZZ& b_in)
{
   ZZ b = b_in;
   long n = a.length();
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      mul(x[i], a[i], b);
}

void add(vector(ZZ)& x, const vector(ZZ)& a, const vector(ZZ)& b)
{
   long n = a.length();
   if (b.length() != n) Error("vector add: dimension mismatch");

   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      add(x[i], a[i], b[i]);
}

void sub(vector(ZZ)& x, const vector(ZZ)& a, const vector(ZZ)& b)
{
   long n = a.length();
   if (b.length() != n) Error("vector sub: dimension mismatch");
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      sub(x[i], a[i], b[i]);
}

void clear(vector(ZZ)& x)
{
   long n = x.length();
   long i;
   for (i = 0; i < n; i++)
      clear(x[i]);
}

void negate(vector(ZZ)& x, const vector(ZZ)& a)
{
   long n = a.length();
   x.SetLength(n);
   long i;
   for (i = 0; i < n; i++)
      negate(x[i], a[i]);
}

