

(defmacro push-string (string symbol)
  `(setq ,symbol (append ',(nreverse (exploden string)) ,symbol)))
(defmacro increment (counter &optional increment)
  (if increment
      `(setf ,counter (+ ,counter ,increment))
      `(setf ,counter (1+ ,counter))))


(defmacro decrement (counter &optional decrement)
    (if decrement
	`(setf ,counter (- ,counter ,decrement))
	`(setf ,counter (1- ,counter))))
(defmacro linearray-dim ()
    '(array-dimension-n 1 linearray))
(defmacro memqarr (l) `(if (memq 'array ,l) t))
(defmacro first-c () `(first string))
(defmacro pop-c   () `(pop string))

(defmacro match (x) `(get ,x 'match))

(defmacro displa-def (operator dim-function &rest rest
			 &aux l-dissym r-dissym lbp rbp)
    (dolist (x rest)
	    (cond ((stringp x)
		   (if l-dissym (setq r-dissym x) (setq l-dissym x)))
		  ((fixp x)
		   (if rbp (setq lbp rbp))
		   (setq rbp x))
		  (t (error "random object in displa-def form" x))))
    (if l-dissym
	(setq l-dissym
	      (if r-dissym
		  (cons (exploden l-dissym) (exploden r-dissym))
		  (exploden l-dissym))))
    `(progn 'compile
	    (defprop ,operator ,dim-function dimension)
	    ,(if l-dissym  `(defprop ,operator ,l-dissym dissym))
	    ,(if lbp       `(defprop ,operator ,lbp lbp))
	    ,(if rbp       `(defprop ,operator ,rbp rbp))))


(declare (macros t)
   (special define-database-file
	    define-exprs define-fexprs define-lexprs define-vars
	    liszt-eof-forms
	    liszt-root-name
	    define-print-port vdb-current))
(setq define-fexprs nil
      define-exprs  nil
      define-lexprs nil
      define-vars   nil)
(defmacro defmfun (name bvl . body)
  (cond ((eq 'fexpr bvl) (push name define-fexprs))
	((and (eq 'expr bvl) (setq bvl (car body) body (cdr body)) nil))
	((or (and bvl (symbolp bvl))
	     (memq '&rest bvl)
	     (memq '&optional bvl))
	 (push name define-lexprs))
	(t (push name define-exprs)))
  `(defun ,name ,bvl ,@body))

(defmacro defmspec (name &rest rest)
   ; this is how all fexprs are done now
   (push name define-fexprs)
   `(defun (,name mfexpr*) ,@rest))

#+Franz
(defmacro array-dimension-n (idx ary)
   (let ((access (cond ((eq idx 1) 'cadr)	; simple cases
		       ((eq idx 2) 'caddr))))
      (cond (access `(,access (arraydims ,ary)))
	    (t `(nth ,idx (arraydims ,ary))))))
