/* file:lo.c */
#include "def.h"
#include "macro.h"


#define EXP 15
#define B 32768           /*              1000000000000000*/
#define BMINUSEINS 32767  /*               111111111111111*/
#define B1 2147450880L    /* 111111111111111000000000000000*/
#define B2MINUSEINS 2147483647L    /*1000000000000000000000000000000 - 1*/
#define Basis 45
#define MSB  16384 
#define FREE_LOC(a) free(a)

#ifdef LONGINTTRUE
struct ganzdaten gd;
#endif /* LONGINTTRUE */

/* alles.c */
static struct longint * calloclongint();
static INT ganzabs();
static INT ganzadd();
static INT ganzanfang();
static INT ganzaus();
static INT ganzdefiniere();
static INT ganzein();
static INT ganzeven();
static INT ganzfziffer();
static INT ganzganzdiv();
static INT ganzint();
static INT ganzkopiere();
static INT ganzloesche();
static INT ganzmod();
static INT ganzmul();
static INT ganzneg();
static INT ganzodd();
static INT ganzparam();
static INT ganzquores();
static INT ganzsignum();
static INT ganzsadd();
static INT ganzsmul();
static INT ganzsquores();
static INT ganzsub();
static INT ganztausche();
static INT ganzvergleich();
static INT ganz1ziffer();
static INT intganz();
static INT locadd();
static INT locass();
static INT locbas2();
static INT locdiv();
static INT lochole();
static INT locint();
static INT loclisterette();
static INT locmax();
static INT locms1();
static INT locmul();
static INT locneg();
static INT locnull();
static INT locodd();
static INT locrette();
static INT locrezliste();
static INT locpsl();
static INT locpsr();
static INT locsadd();
static INT locsdiv();
static INT locsgn();
static INT locsmul();
static INT locssub();
static INT locsub();
static INT locvgl();
static INT retteziffer();

/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */

#ifdef LONGINTTRUE
static INT locadd(lx,ly,cy) struct loc *lx,*ly; INT cy;
/* AK 130789 V1.0 */ /* AK 270390 V1.1 */
/* AK 210891 V1.3 */
	{
	static INT hh;
	hh=ly->w0+cy+lx->w0;
	lx->w0=(hh&BMINUSEINS);
	cy = hh >>EXP;
	hh=ly->w1+cy+lx->w1;
	lx->w1=(hh&BMINUSEINS);
	cy = hh >>EXP;
	hh=ly->w2+cy+lx->w2;
	lx->w2=(hh&BMINUSEINS);
	cy = hh >>EXP;
	return((INT)cy);
	}
#endif /* LONGINTTRUE */

#define LOCADD(lx,ly,cy)\
	hh=(ly)->w0+cy+(lx)->w0, (lx)->w0=(hh&BMINUSEINS), cy = hh >>EXP,\
	hh=(ly)->w1+cy+(lx)->w1, (lx)->w1=(hh&BMINUSEINS), cy = hh >>EXP,\
	hh=(ly)->w2+cy+(lx)->w2, (lx)->w2=(hh&BMINUSEINS), cy = hh >>EXP,cy


#define LOCBAS2() Basis
    

#define LOCASS(lx,ly) ((lx)->w2=(ly)->w2,(lx)->w1=(ly)->w1,(lx)->w0=(ly)->w0)

#ifdef LONGINTTRUE
static INT locdiv(qu,rest,dd,dv) struct loc *qu,*rest,*dd,*dv;
/* Division. Bei Eingabe muss gelten: rest<dv.            */
/* (qu,rest) := ((rest*B+dd) DIV dv, (rest*B+dd) MOD dv). */
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */
/* AK 210891 V1.3 */
	{
	INT d6,d5,d4,d3,d2,d1,
	     h6,h5,h4,h3,h2,h1, 
	     m2,m1,m0;


 /* d=rest*B+dd */
 d6=rest->w2; d5=rest->w1; d4=rest->w0; d3=dd->w2; d2=dd->w1; d1=dd->w0;

 /* h=dv */
 h6=0L; h5=0L; h4=0L; h3=dv->w2; h2=dv->w1; h1=dv->w0; 

 /* qu=0 */
 qu->w2=0L; qu->w1=0L; qu->w0=0L;

 /* m=1 */
 m2=0L; m1=0L; m0=1L;

 while /* h<=d */
 (h6 <d6 ||
  h6==d6 && h5<d5  ||
  h6==d6 && h5==d5 && h4<d4  ||
  h6==d6 && h5==d5 && h4==d4 && h3<d3  ||
  h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2<d2  ||
  h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2==d2 && h1<d1  ||
  h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2==d2 && h1==d1 
 )
 {
  /* h=h*2 */
  h6=h6<<1; h5=h5<<1; h4=h4<<1; h3=h3<<1; h2=h2<<1; h1=h1<<1; 
  if (h1&B1) {h1=h1&BMINUSEINS; h2++; };
  if (h2&B1) {h2=h2&BMINUSEINS; h3++; };
  if (h3&B1) {h3=h3&BMINUSEINS; h4++; };
  if (h4&B1) {h4=h4&BMINUSEINS; h5++; };
  if (h5&B1) {h5=h5&BMINUSEINS; h6++; };

  /* m=m*2 */
  m2=m2<<1; m1=m1<<1; m0=m0<<1;
  if (m0&B1) {m0=m0&BMINUSEINS; m1++; };
  if (m1&B1) {m1=m1&BMINUSEINS; m2++; };
 }
  while /* d>=dv */
  (d6 >0 || d5>0  || d4>0  ||
   d6==0 && d5==0 && d4==0 && d3>dv->w2  || 
   d6==0 && d5==0 && d4==0 && d3==dv->w2 && d2>dv->w1  || 
   d6==0 && d5==0 && d4==0 && d3==dv->w2 && d2==dv->w1 && d1>dv->w0  ||
   d6==0 && d5==0 && d4==0 && d3==dv->w2 && d2==dv->w1 && d1==dv->w0 
  )
  {
   while /*h>d */
   (h6 >d6 ||
    h6==d6 && h5>d5 ||
    h6==d6 && h5==d5 && h4>d4 ||
    h6==d6 && h5==d5 && h4==d4 && h3>d3 ||
    h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2>d2 ||
    h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2==d2 && h1>d1 
   )
   {
    /* h=h/2 */
    if (h6&1) { h6--; h5=h5|B; };  h6=h6>>1;
    if (h5&1) { h5--; h4=h4|B; };  h5=h5>>1;
    if (h4&1) { h4--; h3=h3|B; };  h4=h4>>1;
    if (h3&1) { h3--; h2=h2|B; };  h3=h3>>1;
    if (h2&1) { h2--; h1=h1|B; };  h2=h2>>1;
                                   h1=h1>>1;

    /* m=m/2 */
    if (m2&1) { m2--; m1=m1|B; };  m2=m2>>1;
    if (m1&1) { m1--; m0=m0|B; };  m1=m1>>1;
                                   m0=m0>>1;
   }
   
   /* d=d-h */
   if (h1>d1) { d1=d1+B; d2--; };  d1=d1-h1;
   if (h2>d2) { d2=d2+B; d3--; };  d2=d2-h2;
   if (h3>d3) { d3=d3+B; d4--; };  d3=d3-h3;
   if (h4>d4) { d4=d4+B; d5--; };  d4=d4-h4;
   if (h5>d5) { d5=d5+B; d6--; };  d5=d5-h5;
                                   d6=d6-h6;

   /* qu=qu+m */
   qu->w0=qu->w0|m0; qu->w1=qu->w1|m1; qu->w2=qu->w2|m2;
  }
	rest->w2=d3; rest->w1=d2; rest->w0=d1;
	return(OK);
}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locint(lx,i) struct loc *lx; INT    i;
/* Umwandlung Integer in loc: lx:=abs(i); locint:=sgn(i)  */
/* AK 130789 V1.0 */ /* AK 150290 V1.1 */
/* AK 210891 V1.3 */
	{
	INT s;

	if (i<0L) 		{s=0-1L; i=0-i;}
	else if (i>0L) 		{s=1L;}
	else 			{s=0L;}

	lx->w0=i & BMINUSEINS;
	lx->w1=(i & B1)>>EXP; 
	lx->w2=(lx->w1 & B1)>>EXP;
	lx->w1=lx->w1 & BMINUSEINS;
	return(s);
	}
#endif /* LONGINTTRUE */


#define LOCMAX(lx) ((lx)->w0=BMINUSEINS,\
	(lx)->w1=BMINUSEINS,(lx)->w2=BMINUSEINS)

#ifdef LONGINTTRUE
static INT locms1(lx) struct loc *lx;
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	INT j,c,cc;

	c=Basis; cc=1L;
    for (j=14L; (j >=0L) && cc ; j--)
    {
      if ( lx->w2 & ( 1L << j )) 
         cc=0L;
      c--;
    } 
  if (cc) 
    for (j=14L; (j >=0L) && cc ; j--)
    {
      if ( lx->w1 & ( 1L << j )) 
         cc=0L;
      c--;
    }
  if (cc) 
    for (j=14L; (j >=0L) && cc ; j--)
    {
      if ( lx->w0 & ( 1L << j )) 
         cc=0L;
      c--;
    }
  if (cc) error("locms1:");
  return(c);
 }
#endif /* LONGINTTRUE */

 
#ifdef LONGINTTRUE
static INT locmul(ly,lx,la,lb) struct loc *lx,*ly,*la,*lb;
/* AK 130789 V1.0 */ /* AK 260390 V1.1 */ /* AK 210891 V1.3 */
{
static INT hh;
#define teile(z) (hh=(z)>>EXP, (z) &= BMINUSEINS, hh)
/* AK 260390 */

 lx->w0 =                          la->w0 * lb->w0;
 lx->w1 =          teile(lx->w0) + la->w1 * lb->w0;
 lx->w2 =          teile(lx->w1) + la->w2 * lb->w0;
 ly->w0 =          teile(lx->w2)                  ;
 lx->w1 +=                  la->w0 * lb->w1;
 lx->w2 +=  teile(lx->w1) + la->w1 * lb->w1;
 ly->w0 +=  teile(lx->w2) + la->w2 * lb->w1;
 ly->w1 =          teile(ly->w0)                  ;
 lx->w2 +=                  la->w0 * lb->w2;
 ly->w0 +=  teile(lx->w2) + la->w1 * lb->w2;
 ly->w1 +=  teile(ly->w0) + la->w2 * lb->w2;
 ly->w2 =          teile(ly->w1)                  ;
}
#endif /* LONGINTTRUE */

#define LOCMUL(ly,lx,la,lb) /* hh ist noetig */\
 (lx)->w0 =                          (la)->w0 * (lb)->w0,\
 (lx)->w1 =          teile((lx)->w0) + (la)->w1 * (lb)->w0,\
 (lx)->w2 =          teile((lx)->w1) + (la)->w2 * (lb)->w0,\
 (ly)->w0 =          teile((lx)->w2)                  ,\
 (lx)->w1 +=                  (la)->w0 * (lb)->w1,\
 (lx)->w2 +=  teile((lx)->w1) + (la)->w1 * (lb)->w1,\
 (ly)->w0 +=  teile((lx)->w2) + (la)->w2 * (lb)->w1,\
 (ly)->w1 =          teile((ly)->w0)                  ,\
 (lx)->w2 +=                  (la)->w0 * (lb)->w2,\
 (ly)->w0 +=  teile((lx)->w2) + (la)->w1 * (lb)->w2,\
 (ly)->w1 +=  teile((ly)->w0) + (la)->w2 * (lb)->w2,\
 (ly)->w2 =          teile((ly)->w1)                  

#ifdef LONGINTTRUE
static INT locneg(lx,cy) struct loc *lx; INT cy;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
if ((cy==0L)&&(lx->w0==0L)&&(lx->w1==0L)&&(lx->w2==0L)) {
		return(0L); }
else

	{
	lx->w0 ^= BMINUSEINS;
	lx->w1 ^= BMINUSEINS;
	lx->w2 ^= BMINUSEINS;
	if (cy == 0L )
	  { ++lx->w0;
	  if (lx->w0 & B)
	    {
	    ++lx->w1;
	    lx->w0 &= BMINUSEINS;
	    if (lx->w1 & B)
	      { ++lx->w2; lx->w1 &= BMINUSEINS; }
            }
          }
       return(1L);
       }
  } /* locneg */
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locnull(lx) struct loc *lx;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */
/* AK 210891 V1.3 */
	{
	lx->w2 = 0L; lx->w1 = 0L; lx->w0 = 0L;
	}  /* Ende von locnull */
#endif /* LONGINTTRUE */

#define LOCNULL(lx) ((lx)->w0=0L,(lx)->w1=0L,(lx)->w2=0L)

#ifdef LONGINTTRUE
static INT locodd(lx) struct loc *lx;
/*locodd:=lx ist ungerade */
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	return (INT) (lx->w0 & 1);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT locpsl(lx,ly,a) struct loc *lx,*ly; INT a;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
   INT s1,s2,s3,s4,s5,i;
   struct loc lyy;


   lyy.w0 = ly->w0; lyy.w1 = ly->w1; lyy.w2 = ly->w2;

   if ( a >= Basis) error("locpsl:");
   for (i=1L; i <= a;i++)
   {
     s1= (lyy.w0 & MSB) >> 14;
     s2= (lyy.w1 & MSB) >> 14;
     s3= (lyy.w2 & MSB) >> 14;
     s4= (lx->w0 & MSB) >> 14;
     s5= (lx->w1 & MSB) >> 14;
     lyy.w0 = lyy.w0 << 1;
     lyy.w1 = (lyy.w1 << 1) | s1;
     lyy.w2 = (lyy.w2 << 1) | s2;
     lx->w0 = (lx->w0 << 1) | s3;
     lx->w1 = (lx->w1 << 1) | s4;
     lx->w2 = (lx->w2 << 1) | s5;
   }
   lx->w0 = lx->w0 & BMINUSEINS;
   lx->w1 = lx->w1 & BMINUSEINS;
   lx->w2 = lx->w2 & BMINUSEINS;
 } /* Ende von locpsl */
#endif /* LONGINTTRUE */
     
#ifdef LONGINTTRUE
static INT locpsr(lx,ly,a) struct loc *lx,*ly; INT a;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
 {
   INT s1,s2,s3,s4,s5,i;
   struct loc lxx;


   lxx.w0 = lx->w0; lxx.w1 = lx->w1; lxx.w2 = lx->w2;


   if ( a >= Basis) error("locpsr:");
   for (i=1L; i <= a;i++)
   {
     s1= (ly->w1 & 1) << 14;
     s2= (ly->w2 & 1) << 14;
     s3= (lxx.w0 & 1) << 14;
     s4= (lxx.w1 & 1) << 14;
     s5= (lxx.w2 & 1) << 14;
     ly->w0 = (ly->w0 >> 1) | s1;
     ly->w1 = (ly->w1 >> 1) | s2;
     ly->w2 = (ly->w2 >> 1) | s3;
     lxx.w0 = (lxx.w0 >> 1) | s4;
     lxx.w1 = (lxx.w1 >> 1) | s5;
     lxx.w2 = (lxx.w2 >> 1);
   }
 } /* Ende von locpsr */
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locsadd(lx,i) struct loc *lx; INT i;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
{
	INT cy,hh;
	if (i<0L) i=(-i);
	hh=lx->w0+(i%B);
	lx->w0=(hh & BMINUSEINS);
	cy = hh >>EXP;
	hh=lx->w1+(i/B)+cy;
	lx->w1=(hh & BMINUSEINS);
	cy = hh >>EXP;
	hh=lx->w2+cy;
	lx->w2=(hh & BMINUSEINS);
	cy = hh >>EXP;
	return(cy);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT locsdiv(qu,di,dd,dv) struct loc *qu,*dd; INT di,dv;
/* Division. Bei Eingabe muss gelten: di<dv.             */
/* (locsdiv,qu) := ((di*B+dd) MOD dv, (di*B+dd) DIV dv). */
/* AK 130789 V1.0 */ /* AK 030790 V1.1 */ /* AK 210891 V1.3 */
	{
 INT d6,d5,d4,d3,d2,d1,
     h6,h5,h4,h3,h2,h1, 
     m2,m1,m0,
     dv2,dv1,dv0;

 /* di umwandeln */
 if (di<0L) {return error("locsdiv:di<0");};
 d4=di & BMINUSEINS;
 d5=(di & B1)>>EXP; 
 d6=(d5 & B1)>>EXP;
 d5=d5 & BMINUSEINS;

 /* dv umwandeln */
 if (dv<0L) {return error("locsdiv:dv<0");};
 dv0=dv & BMINUSEINS;
 dv1=(dv & B1)>>EXP; 
 dv2=(dv1 & B1)>>EXP;
 dv1=dv1 & BMINUSEINS;

 /* d=di*B+dd */
 d3=dd->w2; d2=dd->w1; d1=dd->w0;

 /* h=dv */
 h6=0L; h5=0L; h4=0L; h3=dv2; h2=dv1; h1=dv0; 

 /* qu=0 */
 qu->w2=0L; qu->w1=0L; qu->w0=0L;

 /* m=1 */
 m2=0L; m1=0L; m0=1L;

 while /* h<=d */
 (h6 <d6 ||
  h6==d6 && h5<d5  ||
  h6==d6 && h5==d5 && h4<d4  ||
  h6==d6 && h5==d5 && h4==d4 && h3<d3  ||
  h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2<d2  ||
  h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2==d2 && h1<d1  ||
  h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2==d2 && h1==d1 
 )
 {
	  /* h=h*2 */
	  h6=h6<<1; h5=h5<<1; h4=h4<<1; h3=h3<<1; h2=h2<<1; h1=h1<<1; 
	  if (h1&B1) {h1&=BMINUSEINS; h2++; };
	  if (h2&B1) {h2&=BMINUSEINS; h3++; };
	  if (h3&B1) {h3&=BMINUSEINS; h4++; };
	  if (h4&B1) {h4&=BMINUSEINS; h5++; };
	  if (h5&B1) {h5&=BMINUSEINS; h6++; };

	  /* m=m*2 */
	  m2=m2<<1; m1=m1<<1; m0=m0<<1;
	  if (m0&B1) {m0&=BMINUSEINS; m1++; };
	  if (m1&B1) {m1&=BMINUSEINS; m2++; };
 }
  while /* d>=dv */
  (d6 >0L || d5>0L  || d4>0L  ||
   d6==0L && d5==0L && d4==0L && d3>dv2  || 
   d6==0L && d5==0L && d4==0L && d3==dv2 && d2>dv1  || 
   d6==0L && d5==0L && d4==0L && d3==dv2 && d2==dv1 && d1>dv0  ||
   d6==0L && d5==0L && d4==0L && d3==dv2 && d2==dv1 && d1==dv0 
  )
  {
		   while /*h>d */
		   (h6 >d6 ||
		    h6==d6 && h5>d5 ||
		    h6==d6 && h5==d5 && h4>d4 ||
		    h6==d6 && h5==d5 && h4==d4 && h3>d3 ||
		    h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2>d2 ||
		    h6==d6 && h5==d5 && h4==d4 && h3==d3 && h2==d2 && h1>d1 
		   )
		   {
			    /* h=h/2 */
			    if (h6&1) { h6--; h5|=B; };  h6=h6>>1;
			    if (h5&1) { h5--; h4|=B; };  h5=h5>>1;
			    if (h4&1) { h4--; h3|=B; };  h4=h4>>1;
			    if (h3&1) { h3--; h2|=B; };  h3=h3>>1;
			    if (h2&1) { h2--; h1|=B; };  h2=h2>>1;
							   h1=h1>>1;

			    /* m=m/2 */
			    if (m2&1) { m2--; m1=m1|B; };  m2=m2>>1;
			    if (m1&1) { m1--; m0=m0|B; };  m1=m1>>1;
							   m0=m0>>1;
		   }
		   
		   /* d=d-h */
		   if (h1>d1) { d1+=B; d2--; };  d1-=h1;
		   if (h2>d2) { d2+=B; d3--; };  d2-=h2;
		   if (h3>d3) { d3+=B; d4--; };  d3-=h3;
		   if (h4>d4) { d4+=B; d5--; };  d4-=h4;
		   if (h5>d5) { d5+=B; d6--; };  d5-=h5;
						 d6-=h6;

		   /* qu=qu+m */
		   qu->w0|=m0; qu->w1|=m1; qu->w2|=m2;
  }
  d3=d3<<EXP|d2;
  d3=d3<<EXP|d1;
  return(d3);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locsgn(lx) struct loc *lx;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	  if (lx->w2 || lx->w1 || lx->w0 ) 
	     return(1L);
	  else return(0L);
	} /* Ende locsgn */
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT locsmul(lx,i,ue) struct loc *lx; INT i,ue;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	INT cy,h0,h1,h2,i0,i1,i2,u0,u1,u2;
	if (i<0)  {i=~i;++i;}
	if (ue<0) {ue=~ue;++ue;} 
	i0=i&BMINUSEINS; i1=((i&B1)>>15); i2=((i&(B2MINUSEINS+1))>>30);
	u0=ue&BMINUSEINS; u1=((ue&B1)>>15); u2=((ue&(B2MINUSEINS+1))>>30);
	h0=(lx->w0)*i0+u0;
		cy = (h0 >> 15);
		h0 &= BMINUSEINS;
	h1=(lx->w0)*i1+(lx->w1)*i0+cy+u1;
		cy = (h1 >> 15);
		h1 &= BMINUSEINS;
	h2=(lx->w0)*i2+(lx->w1)*i1+(lx->w2)*i0+cy+u2;
	cy = (h2 >> 15);
	h2 &= BMINUSEINS;
	cy += (lx->w1)*i2+(lx->w2)*i1+(((lx->w2)*i2)<<15);
	lx->w0 = h0; lx->w1 = h1; lx->w2 = h2;
	return(cy);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locssub(lx,i) struct loc *lx; INT i;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	INT cy;
	if (i<0L) i=(-i);
	lx->w0=lx->w0-(i%B);
	if (lx->w0 < 0) { lx->w0 += B;
			   cy = 1L; }
	else cy = 0L;
	lx->w1=lx->w1-(i/B)-cy;
	if (lx->w1 < 0) { lx->w1 += B;
			   cy = 1L; }
	else cy = 0L;
	lx->w2=lx->w2-cy;
	if (lx->w2 < 0) { lx->w2 += B;
			   cy = 1L; }
	else cy = 0L;
	return(cy);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locsub(lx,ly,cy) struct loc *lx,*ly; INT cy;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
{
	lx->w0=lx->w0- ly->w0 -cy;
	if (lx->w0 < 0L) { lx->w0 += B;
			   cy = 1L; }
	else cy = 0L;
	lx->w1=lx->w1- ly->w1- cy;
	if (lx->w1 < 0L) { lx->w1 += B;
			   cy = 1L; }
	else cy = 0L;
	lx->w2=lx->w2- ly->w2- cy;
	if (lx->w2 < 0L) { lx->w2 += B;
			   cy = 1L; }
	else cy = 0L;
	return(cy);
}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locvgl(lx,ly) struct loc *lx,*ly;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	  if (lx->w2 > ly->w2) return(1L);
	    else if (lx->w2 < ly->w2 ) return(-1L);
	    else if (lx->w1 > ly->w1) return(1L);
	    else if (lx->w1 < ly->w1) return(-1L);
	    else if (lx->w0 > ly->w0) return(1L);
	    else if (lx->w0 < ly->w0) return(-1L);
	    else return(0L); 
	}  /* Ende locvgl */
#endif /* LONGINTTRUE */



#ifdef LONGINTTRUE
static INT ganzadd(x,y) struct longint *x,*y;
/* AK: Fri Jan 13 07:24:17 MEZ 1989 */
/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	struct loc *alocx, *alocy, *lloc, *plocx, *plocy;
	INT	cy,xl,ll;
	signed char xs,ys;

	xs = x->signum; ys = y->signum; xl = x->laenge;
	if (((xs>=(signed char)0) && (ys>=(signed char)0)) || 
			((xs<(signed char)0) && (ys<(signed char)0)))
		{ alocx = x->floc; alocy = y->floc; cy = 0;
		do	{ cy = locadd(alocx,alocy,cy);
			plocx = alocx; plocy = alocy; alocx = alocx->nloc;
			alocy = alocy->nloc; }
		while ((alocx != NULL) && (alocy != NULL));

		/* fuege rest an */
		if (alocy != NULL)
			{ do 	{ lochole(&alocx); plocx->nloc = alocx;
				xl++; cy = locadd(alocx,alocy,cy);
				plocx = alocx; alocx = NULL; plocy = alocy;
				alocy = alocy->nloc; }
			while (alocy != NULL);
			}
		else	{ while ((alocx != NULL) && (cy != 0))
				{ cy = locsadd(alocx,cy); plocx = alocx;
				alocx = alocx->nloc; }
			}

		/* noch ein cy? */
		if (cy != 0)
			{ lochole(&alocx);
			plocx->nloc = alocx; locint(alocx,cy); xl++; }
		if (xs == 0) xs = ys;
		} /* end of first if */
	else	{
		alocx = x->floc; alocy = y->floc; cy = 0;
		/* subtract y from x */
		do	{ cy = locsub(alocx,alocy,cy); plocx = alocx;
			alocx = alocx->nloc; plocy = alocy; alocy = alocy->nloc;
			}
		while ((alocx != NULL) && (alocy != NULL));

		/* append the remaining part */
		if (alocy != NULL)
			{
			do 	{ lochole(&alocx); plocx->nloc = alocx; xl++;
				cy = locsub(alocx,alocy,cy); plocx = alocx;
				alocx = NULL;plocy = alocy;alocy = alocy->nloc;
				}
			while (alocy != NULL);
			}
		else 	{
			while	((alocx != NULL) && (cy != 0))
				{ cy = locssub(alocx,cy);
				plocx = alocx; alocx = alocx->nloc; }
			};

		/* normieren  von x */
		if (cy != 0)
			{
			alocx = x->floc; lloc = NULL; ll = 1; cy = 0;
			do 	{ cy = locneg(alocx,cy);
				if (locsgn(alocx) != 0)
					{ lloc = alocx; xl = ll; }
				alocx = alocx->nloc; ll++;
				}
			while (alocx != NULL);
			loclisterette(&(lloc->nloc)); xs = -xs;
			if (xs == 0) xs = -1;
			}
		else	{
			alocx = x->floc; lloc = NULL; ll = 1;
			do	{
				if (locsgn(alocx) != 0)
					{ lloc = alocx; xl = ll; }
				alocx = alocx->nloc; ll++;
				}
			while (alocx != NULL);
			if (lloc == NULL)
				/* das ergebnis der addition ist null */
				{ loclisterette(&(x->floc->nloc));
				xs = 0; xl =1; }
			else	loclisterette(&(lloc->nloc));
			}
		}
	x->laenge = xl; x->signum = xs;
	return(OK);			
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT ganzsquores(x,rest,y) struct longint *x; INT *rest,y;
/* AK Tue Jan 31 07:48:38 MEZ 1989 */
/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */
/* AK 130789 V1.0 */ /* AK 200290 V1.1 */ /* AK 210891 V1.3 */
	{

	struct loc *alocx, *blocx, *slocx;
	INT	r;
	signed char sx,sy;

	sx = x->signum;
	if (y>0L) sy=(signed char)1; 
	else if (y<0L) sy = (signed char)-1; 
	else sy=(signed char)0;
	if (y<0L) y = -y;
	blocx = x->floc; x->floc = NULL; locrezliste(&blocx);
	alocx = blocx; slocx = alocx->nloc; r=0L;
	while (slocx != NULL)
		{ r = locsdiv(alocx,r,alocx,y); alocx = slocx;
		slocx = alocx->nloc; }


	r = locsdiv(alocx,r,alocx,y);
	*rest = r * sx;
	if (locsgn(blocx) != 0L) x->signum = sx*sy;
	else if (x->laenge == 1L) x->signum = (signed char)0;
	else	{
		alocx = blocx; blocx = blocx->nloc; alocx->nloc =  NULL;
		locrette(&alocx); x->laenge --; x->signum = sx*sy;
		};

	locrezliste(&blocx);
	x->floc = blocx;
	return(OK);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT ganzquores(x,rest,y) struct longint *x, *rest, *y; 
/* AK Mon Mar 13 10:58:11 MEZ 1989 */
/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
{
	INT		vgl,cy,cyn,a,i,rl,ql;
	signed char 		sx,sy;
	struct loc 	*alocx, *plocx,*slocx,*blocx,*rlocx,*llocx,
			*alocy,*plocy,*blocy,*blocq,
			*locx2,*locx1,*locx0,*locy1,*locy0;

	struct loc	null,q,r,ov,hi,lo,max;
	INT		fertig;


if ((x->floc == y->floc) || (x->floc == rest->floc) || (y->floc == rest->floc))
	error("ganzquores: (1) equal variables");

loclisterette(&rest->floc);
sx = x->signum;
sy = y->signum;
if (y->laenge == 1L)	/* einfache divison */
	{
	locnull(&null); LOCASS(&lo,y->floc); blocx = x->floc;
	x->floc = NULL; locrezliste(&blocx); alocx = blocx; slocx = alocx->nloc;
	LOCASS(&r,&null);
	while (slocx != NULL)
		{
		locdiv(alocx,&r,alocx,&lo);
		alocx = slocx;
		slocx = slocx->nloc;
		}
	locdiv(alocx,&r,alocx,&lo);
	/* Seite 6 von test.p */
	if (locsgn(&r) == 0L) rest->signum = (signed char)0; 
	else rest->signum = sx;
	lochole(&rest->floc);
	LOCASS(rest->floc,&r);
	rest->laenge = 1L;
	if (locsgn(blocx) != 0L) x->signum = sx * sy;
	else if (x->laenge == 1L) x->signum = (signed char)0;
	else	{ alocx = blocx; blocx = blocx->nloc; alocx->nloc = NULL;
		locrette(&alocx); x->laenge --; x->signum = sx * sy;
		}
	locrezliste(&blocx);
	x->floc = blocx;
	} /* ende der einfachen division */
else	if (x->laenge < y->laenge)	/* trivial */
	{
	*rest = *x; x->floc = NULL; lochole(&x->floc);
	x->signum = (signed char)0; x->laenge = 1L;
	}	/* ende des trivialfalles */
else	{	/* normalfall x->laenge >= y->laenge >= 2 */
		/* lange division */
	locnull(&null); blocy = y->floc; y->floc = NULL;
	locrezliste(&blocy); locy1 = blocy; locy0 = blocy->nloc;
	a = LOCBAS2() - 1L - locms1(locy1);
	locx1 = x->floc; x->floc = NULL; locrezliste(&locx1);
	locx2 = NULL; lochole(&locx2); locx2->nloc = locx1;
	locx0 = locx1->nloc;

	/* dividend und divisor normieren. dividend zerlegen */
	locpsl(locx2,locx1,a);
	alocy = locy0; plocy = locy1; alocx = locx0; plocx = locx1;
	do	{
		locpsl(plocy,alocy,a); locpsl(plocx,alocx,a);
		plocy = alocy; alocy = alocy->nloc;
		plocx = alocx; alocx = alocx->nloc;
		}
	while (alocy != NULL);
	locpsl(plocy,&null,a);

	llocx = plocx;
	rlocx = alocx;

	while (alocx != NULL)	/* rest des dividenden normieren */
		{
		locpsl(plocx,alocx,a);
		plocx = alocx; alocx = alocx->nloc;
		}
	locpsl(plocx,&null,a);

	llocx->nloc = NULL; 	/* dividend getrennt */

	/* listen fuer teildividend und divisor umkehren */
	blocx = locx2; locrezliste(&blocx); locrezliste(&blocy);

	/* quotientenliste mit laenge */
	blocq = NULL; ql = 0L;

	do	{	/* divisionsschritt */
		if (locvgl(locx2,locy1) == 0L) LOCMAX(&q);
		else	{
			LOCASS(&r,locx2);
			locdiv(&q,&r,locx1,locy1);
			locmul(&hi,&lo,&q,locy0);
			/* falls (hi,lo) <= (r,locx0):fertig */
			vgl = locvgl(&hi,&r);
			if ((vgl >0) || ((vgl == 0L) && 
						(locvgl(&lo,locx0) > 0L)))
				{
				locssub(&q,1L);
				cy = locadd(&r,locy1,0L);
				if (cy == 0L)
					{
					cy = locsub(&lo,locy0,0L);
					if (cy == 1L) cy = locssub(&hi,1L);
			/* seite 7 von test.p */
					vgl = locvgl(&hi,&r);
					if (
						(vgl > 0L) ||
					 ((vgl == 0L) 
				&& 
	/* bug 050790 */	  (locvgl(&lo,locx0) > 0L )))
						cy = locssub(&q,1L);
					}
				}
			};

	/* subtrahiere q*divisor von teildivdend llocx = vorgaenger locx0 */
		alocy = blocy; alocx = blocx; cy = 0; cyn = 0; locnull(&ov);
		llocx = NULL; plocx = NULL;
		do	{
			locmul(&hi,&lo,alocy,&q);
			cy = locadd(&lo,&ov,cy);
			LOCASS(&ov,&hi);
			cyn = locsub(alocx,&lo,cyn);
			plocx = alocx; alocx = alocx->nloc; alocy = alocy->nloc;
			if (alocx == locx0) llocx = plocx;
			}
		while (alocy != NULL);
		cy = locsadd(&ov,cy); cyn = locsub(alocx,&ov,cyn);
		if (cy != 0L) error("ganzquores:(2) cy != 0");

		/* falls differenz negativ, q war um 1zu gross. korrektur */

		if (cyn == 1L)
			{
			cyn = locssub(&q,1L);
			alocx = blocx; alocy = blocy; cy = 0L;
			do	{
				cy = locadd(alocx,alocy,cy);
				alocx = alocx->nloc; alocy = alocy->nloc;
				}
			while (alocy != NULL);
			cy = locsadd(alocx,cy); 
			if (cy != 1L)  error("ganzquores:(3) cy != 1");
			}

		/* quotientenziffer q abspeichern . locx2 ist frei dafuer */
		locx1->nloc = NULL;
		if ((blocq == NULL) && (locsgn(&q) == 0L)) locrette(&locx2);
		else	{
			locx2->nloc = blocq; blocq = locx2; locx2 = NULL;
			LOCASS(blocq,&q); ql ++;
			};

		/* neuer teildividend */
		fertig = (rlocx == NULL);
		if (! fertig)
			{
			alocx = blocx; blocx = rlocx; rlocx = rlocx->nloc;
			blocx->nloc = alocx;
			locx2 = locx1; locx1 = locx0; locx0 = llocx;
			if (locx0 == NULL) locx0 = blocx; 
			}
		}
	while (! fertig);	/* ende divisionsschritt */

	/* quotient */
	if (blocq == NULL)
		{
		lochole (&x->floc); x->signum = (signed char)0;
		x->laenge = 1L;
		}
	else	{
		x->floc = blocq; blocq = NULL;
		x->signum = sx * sy; x->laenge = ql;
		}

	/* rest normierung rueckgaengig machen fuehrende nullen entfernen */
	i = 0L; llocx = NULL;
	plocx = blocx; alocx = plocx->nloc; 
	do	{
		i++;
	/* Seite 8 von test.p */
		locpsr(alocx,plocx,a);
		if (locsgn(plocx) != 0L) 
			{
			llocx = plocx; rl = i;
			}
		plocx = alocx; alocx = alocx->nloc;
		}
	while (alocx != NULL);
	locpsr(&null,plocx,a);
	if (locsgn(plocx) != 0L) { llocx = plocx; rl = i+ 1L; }

	if (llocx == NULL)	/* rest 0 */
		{
		loclisterette(&blocx->nloc); rest->floc = blocx;
		blocx = NULL; rest->signum = (signed char)0; rest->laenge = 1L;
		}
	else	{
		loclisterette(&llocx->nloc); rest->floc = blocx;
		blocx = NULL; rest->signum = sx; rest->laenge = rl;
		}

	/* divisor. normierung rueckgaengig machen */
	plocy = blocy; alocy = plocy->nloc;
	do	{ locpsr(alocy,plocy,a); plocy = alocy; alocy = alocy->nloc; }
	while (alocy != NULL);
	locpsr(&null,plocy,a); y->floc = blocy; blocy = NULL;
	} /* lange divison */
return(OK);
} /* ende ganzquores */
#endif /* LONGINTTRUE */

	
#ifdef LONGINTTRUE
static INT ganzganzdiv(x,y) struct longint *x,*y;
/* AK: Tue Mar 14 09:03:44 MEZ 1989 */
/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */
/* AK 130789 V1.0 */ /* AK 210891 V1.3 */
	{
	struct longint rest;

	rest.floc = NULL; ganzquores(x,&rest,y); 
	return ganzloesche(&rest);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzmod(x,rest,y) struct longint *x,*y,*rest;
/* AK Tue Mar 14 09:05:54 MEZ 1989 */
/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */

/* AK 130789 V1.0 *//* AK 250790 V1.1 */ /* AK 210891 V1.3 */
	{
	return ganzquores(x,rest,y);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzein(fp,x) FILE *fp; struct longint *x; 
/* AK 130789 V1.0 *//* AK 250790 V1.1 */ /* AK 270391 V1.2 */
/* AK 210891 V1.3 */
	{
	INT i;
	signed char sgn=(signed char)1;
	char c;
	

	fscanf(fp,"%ld",&i);
	if (i < 0L) 
		{
		sgn = (signed char)-1;
		i = i * -1L;
		}
	ganzint(x,  i % gd.basis);
	while ((c=getc(fp)) == gd.folgezeichen)
		{
		fscanf(fp,"%ld",&i);
		if (i < 0L) 
			{
			return error("ganzein:i < 0");
			}
		ganzsmul(x,gd.basis);
		ganzsadd(x,i % gd.basis);
		}

	x->signum = sgn;
	return OK;
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT holeziffer(zd) struct zahldaten *zd;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	struct loc *adez;
	INT zzmod3,erg;

	zd->ziffernzahl --;
	zzmod3 = zd->ziffernzahl % 3L;

	if (zzmod3 == 0L) erg=zd->fdez->w0;
	if (zzmod3 == 1L) erg=zd->fdez->w1;
	if (zzmod3 == 2L) erg=zd->fdez->w2;

	if (zzmod3 == 0L) 
		{ adez = zd->fdez; zd->fdez = zd->fdez->nloc;
		adez->nloc = NULL; locrette(&adez); }
	
	return(erg);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzfziffer(zd,d) struct zahldaten *zd; struct ganzdaten *d;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	INT z,f0,np;
	signed char buffer[200];

	if (zd->ziffernzahl == 0)
		{ zd->mehr = FALSE; strcpy(zd->ziffer," "); }
	else	{
		z = holeziffer(zd,d);
		if (zd->ziffernzahl > 0) zd->mehr=TRUE; else zd->mehr=FALSE;
		sprintf(buffer,"%ld",z);
		f0 = d->basislaenge-strlen(buffer);
		sprintf(zd->ziffer,"%s","000000000000");
			/* max. 12 Nullen */
		sprintf(zd->ziffer + f0,"%ld",z);
		if (zd->mehr == TRUE)
			sprintf(zd->ziffer,"%s%c",
				zd->ziffer,d->folgezeichen);
		else
			sprintf(zd->ziffer,"%s%c",zd->ziffer,' ');
		}
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT retteziffer(z,zd) INT	z; struct zahldaten *zd;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	struct loc *adez;
	INT zzmod3;

	zzmod3 = zd->ziffernzahl % 3L;

	if (zzmod3 == 0L) {
		adez = NULL; lochole(&adez);
		adez ->nloc = zd->fdez; zd->fdez = adez; }
	if (zzmod3 == 0L) zd->fdez->w0 = z;
	if (zzmod3 == 1L) zd->fdez->w1 = z;
	if (zzmod3 == 2L) zd->fdez->w2 = z;

	zd->ziffernzahl ++; return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganz1ziffer(zd,x) struct zahldaten *zd; struct longint	*x;
/* AK 130789 V1.0 */ /* AK 030790 V1.1 */ /* AK 210891 V1.3 */
	{
	INT z;
	signed char sgn;
	struct longint xx;

	zd->fdez =  NULL; zd->ziffernzahl = 0L; xx.floc = NULL;
	lochole(&xx.floc); ganzkopiere(&xx,x); sgn = xx.signum;
	if (xx.signum < (signed char)0) xx.signum = -xx.signum;

	while (xx.signum > (signed char)0)
		{ ganzsquores(&xx,&z,gd.basis); retteziffer(z,zd,&gd); }
	if (zd->ziffernzahl == 0L)
		{ zd->mehr = FALSE; strcpy(zd->ziffer," "); }
	else	{
		z = holeziffer(zd,&gd); z = sgn * z;
		zd->mehr = (zd->ziffernzahl > 0L);
		if (zd->mehr == TRUE)
		  sprintf(zd->ziffer,"%s%ld%c",zd->ziffer,z,gd.folgezeichen);
		else	
		  sprintf(zd->ziffer,"%s%ld",zd->ziffer,z);
		}
	locrette(& xx.floc);
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzaus(fp,x) FILE *fp; struct longint *x; 
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	struct zahldaten zd;
	char *blanks = (char *) calloc(201,sizeof(char));
	char *zeile  = (char *) calloc(201,sizeof(char));
	INT	i;

	for (i=1;i<gd.auspos;i++) blanks[i-1]=' ';
	blanks[(gd.auspos)-1]='\0';

	zd.ziffer[0] = '\0';

	zeile[0]='\0';
	gd.auszz = 0;

	ganz1ziffer(&zd,x);
	strcat(zeile,zd.ziffer);

	while (zd.mehr == TRUE)
		{
		ganzfziffer(&zd,&gd);
		if ((INT)strlen(zeile) + (INT)strlen(zd.ziffer) > gd.auslaenge)
			{ fprintf(fp,"%s%s\n",blanks,zeile);
			strcpy(zeile,zd.ziffer); gd.auszz++; }
		else	strcat(zeile,zd.ziffer);

		}
	
	zeilenposition  += strlen(zeile); zeilenposition  += strlen(blanks);


	fprintf(fp,"%s%s",blanks,zeile);
	if (fp == stdout)
		if (zeilenposition >70L)
			{ fprintf(fp,"\n"); zeilenposition = 0L; }

		
	gd.auszz++; free(blanks); free(zeile); return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzmul(x,y) struct longint *x,*y;
/* AK Mon Jan 16 09:26:56 MEZ 1989 */
/* x = x * y */
/* AK 180789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	struct loc *alocx, *alocy,   *ploca, *floca, *bloca, *aloca;
	struct loc hi,lo,ov;
	INT	cy,cya;
	INT 	hh; /* fuer LOCADD,LOCMUL */



	x->signum = x->signum * y ->signum;
	if (x->signum == (signed char)0)
		{ 
		loclisterette(& (x->floc->nloc));
		locnull(x->floc); x->laenge = 1L; return OK;
		/* das ergebnis ist null */ }

	/* das ergebnis ist nicht null */
	x->laenge = x->laenge + y->laenge;
	floca = NULL; lochole(&floca); bloca = floca; alocx = x->floc->nloc;
	ploca = floca; aloca = NULL;
	while (alocx != NULL)
		{ lochole(&aloca); ploca->nloc = aloca;
		ploca = aloca; aloca = NULL; alocx = alocx->nloc; }

	alocy = y->floc;

	do	{
		cya = 0L; locnull(&ov); cy = 0L; alocx = x->floc; aloca = bloca;
		do	{ LOCMUL(&hi,&lo,alocx,alocy); 
			cy = LOCADD(&lo,&ov, cy);
			ov = hi; cya = LOCADD(aloca,&lo,cya);
			alocx=alocx->nloc; ploca=aloca; aloca = aloca->nloc; }
		while (alocx !=  NULL);
		cy = locsadd(&ov, cy+cya);
			/* cy ist jetzt 0 */
			if (cy != 0) return error("ganzmul:cy <> 0");
		lochole(&aloca);
		ploca->nloc = aloca;
		LOCASS(aloca,&ov);
		bloca = bloca->nloc;
		alocy = alocy->nloc;
		}
	while (alocy != NULL);

	if (locsgn(aloca ) == 0L)
		{
		locrette(&(ploca->nloc));
		x->laenge --;
		}
	loclisterette(&x->floc);
	x->floc = floca;
	return OK;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzsmul(x,a) struct longint *x; INT	a;
/* AK Mon Mar 13 10:08:51 MEZ 1989 */ /* AK 050790 V1.1 */
/* AK 210891 V1.3 */
{
	struct loc *alocx, *plocx;
	INT	ue;

if (a==0L)
	{
	loclisterette(&(x->floc->nloc));
	x->signum = (signed char)locint(x->floc,0L);
	x->laenge = 1L;
	}
else if (a == 1L) ;
else if (a == -1L) x->signum = - x->signum;
else	{
	if (a<0L) x->signum = - x->signum;
	alocx = x->floc; plocx = NULL; if (a<0L) a = -a;
	ue = 0L;
	do	{ ue = locsmul(alocx,a,ue);
		plocx = alocx; alocx = alocx ->nloc; }
	while (alocx != NULL);
	if (ue != 0L)
		{ lochole(&alocx); plocx->nloc = alocx; x->laenge ++;
		ue = locint(alocx,ue); }
	}
return OK;
}
#endif  /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT ganzsadd(x,y) struct longint *x; INT y; 
/* AK 180789 V1.0 */ /* AK 070390 V1.1 */ /* AK 210891 V1.3 */
	{
	INT cy,xl,ll;
	signed char xs,ys;
	struct loc *lloc,*alocx,*plocx;

	xl = x->laenge; 
	xs = x->signum;
	if (y>0L) 
		ys=(signed char)1; 
	else if (y<0L) 
		ys = (signed char)-1; 
	else 
		ys=(signed char)0;
	if (y<0L) y = -y;

	if (	((xs>=(signed char)0)&&(ys>=(signed char)0))
		||
		((xs<(signed char)0)&&(ys < (signed char)0))
	   )
		{
		alocx = x->floc; 
		cy = y;
		while ((alocx != NULL)&&(cy != 0L))
			{
			cy = locsadd(alocx,cy); 
			plocx = alocx;
			alocx = alocx->nloc;
			}
		if (cy != 0L) 
			{
			lochole(&alocx); 
			plocx->nloc = alocx;
			locint(alocx,cy);
			xl ++;
			}
		if (xs == (signed char)0) 
			xs = ys;
		}
	else	{
		alocx = x->floc;
		cy = y;
		while ((alocx != NULL) && (cy != 0L))
			{ 
			cy = locssub(alocx,cy);
			plocx = alocx; 
			alocx = alocx->nloc; 
			}
		if (cy != 0L)
			{
			alocx = x->floc; 
			lloc = NULL; 
			ll = 1L; 
			cy = 0L;
			do	{ 
				cy = locneg(alocx,cy);
				if (locsgn(alocx) != NULL)
					{ lloc = alocx; xl = ll; }
				alocx = alocx->nloc;
				ll ++;
				}
			while (alocx != NULL);
			loclisterette(&(lloc->nloc));
			xs = -xs;
			if (xs == (signed char)0) 
				xs = (signed char)-1;
			}
		else 	{ 
			alocx = x->floc; 
			lloc = NULL; 
			ll = 1L;
			do	{
				if (locsgn(alocx) != 0L)
					{ 
					lloc = alocx; 
					xl = ll; 
					}
				alocx = alocx->nloc;
				ll ++;
				}
			while (alocx != NULL);
			if (lloc == NULL)
				{
				loclisterette(&(x->floc->nloc));
				xs = (signed char)0; 
				xl = 1L;
				}
			else 	loclisterette(&(lloc->nloc));
			}
		}
	x->laenge = xl; 
	x->signum = xs;
	return(OK);
	}
#endif  /* LONGINTTRUE */
			


#ifdef LONGINTTRUE
static INT ganzvergleich(x,y) struct longint *x,*y;
/* AK Thu Jan 12 09:08:15 MEZ 1989 */
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	struct loc *alocx, *alocy;
	INT	av,lv;
	signed char sx,sy;

	sx = x->signum; sy = y->signum;
	if (sx>sy) 
		return(1L);
	if (sx<sy) 
		return(-1L);
	/* es gilt nun gleiches vorzeichen */
	if (sx==(signed char)0) 
		return(0L);
	if (x->laenge > y->laenge) 
		return((INT)sx);
	if (x->laenge < y->laenge) 
		return((INT)-sy);
	/* es gilt nicht nur gleiches vorzeichen sondern auch
	gleiche laenge */
	alocx = x->floc;
	alocy = y->floc;
	lv = 0;
	do	{ av = locvgl(alocx,alocy);
		if (av != 0) lv = av;
		alocx = alocx->nloc; alocy = alocy->nloc; }
	while (alocx != NULL);
	if (sx>(signed char)0) 
		return(lv); 
	else 
		return(-lv);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT intganz(x) struct longint *x;
/* AK 150290 V1.1 */ /* umwandlung longint to int falls moeglich sonst fehler */
/* AK 210891 V1.3 */
	{
	INT wert;
	if (x->laenge != 1L) {
		error("intganz: no integer value ");
		}
	wert = x->floc->w0;
	wert += x->floc->w1 * B;
	return( (INT)x->signum * wert );
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzint(x,i) struct longint *x; INT	i; 
/* AK Thu Jan 12 13:18:53 MEZ 1989 */
/* AK 130789 V1.0 */ /* AK 150290 V1.1 */ /* AK 210891 V1.3 */
	{
	if (x->floc->nloc != NULL) loclisterette(& x->floc->nloc );
	x->laenge = 1L;
	x->signum = (signed char)locint(x->floc,i);
	return(OK);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT ganzsignum(x) struct longint *x; 
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	return (INT)x->signum;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzeven(x) struct longint *x;
/* AK 061190 V1.1 */ /* AK 210891 V1.3 */
	{
	return not locodd(x->floc);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzodd(x) struct longint *x;
/* AK 061190 V1.1 */ /* AK 210891 V1.3 */
	{
	return locodd(x->floc);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzkopiere(x,a) struct longint *x,*a; 
/* x:= a AK umgeschrieben in C Fri Jan 20 07:46:34 MEZ 1989 */
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	struct loc *alocx, *plocx, *aloca;

	if (x->floc == a->floc)
		 return error("ganzkopiere: identic lists ");

	x->signum = a->signum; x->laenge = a->laenge;
	aloca = a->floc; alocx = x->floc; plocx = NULL;

	do	{ if (alocx == NULL)
			{ lochole(&alocx); plocx->nloc = alocx; }
		LOCASS(alocx,aloca);
		aloca = aloca->nloc; plocx = alocx; alocx = alocx->nloc;
		}
	while (aloca != NULL);
	loclisterette(&(plocx->nloc));return(OK);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT ganzneg(x) struct longint *x;
/* AK 130789 V1.0 */ /* AK 201289 V1.1 */ /* AK 210891 V1.3 */
	{
	x->signum = -x->signum;return(OK);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT lochole(aloc) struct loc   **aloc; 
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	*aloc = (struct loc *) malloc(sizeof(struct loc));
	if (*aloc == NULL) error("lochole:no memory");
	locnull(*aloc);
	(*aloc)->nloc = NULL;
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT loclisterette(aloc) struct loc **aloc; 
/* AK 130789 V1.0 */ /* AK 010290 V1.1 */
/* AK 150290 ohne struct ganzdaten */ /* AK 210891 V1.3 */
	{
	struct loc *aloc1, *ploc1;
	if (*aloc != NULL)
		{
		aloc1=   (*aloc);
		do { ploc1 = aloc1->nloc; FREE_LOC(aloc1); aloc1 = ploc1; }
		while 	(aloc1 != NULL);
		*aloc = NULL; 
		}
	return(OK);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
static INT locrette(aloc) struct loc **aloc;
/* AK 130789 V1.0 */ /* AK 100190 V1.1 */ /* AK 210891 V1.3 */
	{
	if (*aloc != NULL)
		{
		/* kommentar AK 100190 */
		/*
		if ((*aloc)->nloc != NULL) error("locrette:next != NULL");
		*/
		FREE_LOC(*aloc);
		*aloc = NULL;
		}
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT locrezliste(aloc) struct loc **aloc;
/* AK Thu Jan 12 08:06:59 MEZ 1989 */
/* dreht liste um */
/* AK 100190 V1.1 */ /* AK 210891 V1.3 */
	{
	struct loc *lloc,*rloc,*hloc;
	if (*aloc != NULL)
		{
		lloc = NULL; rloc = *aloc;
		while (rloc != NULL)
			{
			hloc = rloc->nloc;
			rloc->nloc=lloc;
			lloc=rloc;
			rloc=hloc;
			}
		*aloc = lloc;
		}
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT start_longint()
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	ganzanfang(&gd);
	ganzparam(1000000L,2L,78L,'.',&gd);
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static struct longint * calloclongint()
/* AK 170888 */ /* AK 130789 V1.0 */ /* AK 050790 V1.1 */
/* AK 210891 V1.3 */
	{
	struct longint *ergebnis = 
		(struct longint *) malloc( sizeof(struct longint));
	if (ergebnis == NULL) error("calloclongint: no mem");
	return ergebnis;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT init_longint(l) OP l;
/* AK 170888 */ /* AK 130789 V1.0 */ /* AK 040790 V1.1 */
/* AK 210891 V1.3 */
	{
	OBJECTSELF c;

	c.ob_longint = calloclongint();
	B_KS_O(LONGINT,c,l);
	c = S_O_S(l);
	ganzdefiniere(c.ob_longint);
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT fprint_longint(f,l) FILE *f; OP l;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF c;

	if (nullp(l)) { /* AK 020889 V1.0 */
		freeself(l);m_i_i(0L,l);fprint_integer(f,l);return(OK);}
	c = S_O_S(l);
	ganzaus(f, c.ob_longint,&gd);
	return(OK);
	}
#endif /* LONGINTTRUE */



#ifdef LONGINTTRUE
INT tex_longint(l) OP l;
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */
/* AK 070291 V1.2 texout instaed of stdout for output */ /* AK 210891 V1.3 */
	{
	fprintf(texout," $ "); fprint_longint(texout,l); 
	fprintf(texout," $ ");
	texposition += 6L; return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT copy_longint(a,c) OP a,c;
/* AK 180888 */ /* AK 130789 V1.0 */ /* AK 030790 V1.1 */
/* AK 210891 V1.3 */
	{
	OBJECTSELF cs,as;

	init(LONGINT,c);
	cs = S_O_S(c);
	as = S_O_S(a);
	return ganzkopiere(cs.ob_longint,as.ob_longint);
	/* erstes element wird gleich dem zweiten */
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT freeself_longint(a) OP a;
/* AK 180888 */ /* AK 130789 V1.0 */ /* AK 030790 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF c;
	c = S_O_S(a);

	ganzloesche(c.ob_longint); free(c.ob_longint);
	return(OK);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
INT add_longint(a,c,l) OP a,c,l;
/* AK 180888 */ /* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	INT erg = OK;
	switch(S_O_K(c))
		{
#ifdef BRUCHTRUE
		case BRUCH: erg += add_bruch_scalar(c,a,l);
			if (S_O_K(l) == LONGINT)
				erg += t_longint_int(l);
			break;
#endif /* BRUCHTRUE */
		case INTEGER: erg += add_longint_integer(a,c,l);break;
		case LONGINT:{
			OBJECTSELF ls,cs;

			erg += copy(a,l);
			ls = S_O_S(l);
			cs = S_O_S(c);
			erg += ganzadd(ls.ob_longint,cs.ob_longint);
				/* longinteger-addition ist x:= x+y */
			erg += t_longint_int(l);
			break;
			}
		default:{
			printobjectkind(c);
			error("add_longint:wrong second type");
			return(ERROR);
			}
		};
	if (erg != OK)
		{
		error("add_longint: error during computation");
		}
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT mult_longint(a,c,l) OP a,c,l;
/* AK 180888 */ /* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	INT erg = OK;
	switch (S_O_K(c))
		{
#ifdef BRUCHTRUE
		case BRUCH: erg+=mult_bruch_integer(c,a,l);break;
#endif /* BRUCHTRUE */
#ifdef INTEGERTRUE
		case INTEGER: erg+=mult_longint_integer(a,c,l);break;
#endif /* INTEGERTRUE */
#ifdef MATRIXTRUE
		case MATRIX: erg+=mult_scalar_matrix(a,c,l);break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM: erg+=mult_scalar_monom(a,c,l);break;
#endif /* MONOMTRUE */
		case LONGINT: erg+=mult_longint_longint(a,c,l);break;
		case POLYNOM: erg+=mult_scalar_polynom(a,c,l);break;
#ifdef SCHURTRUE
		case SCHUR: erg+=mult_scalar_schur(a,c,l);break;
#endif /* SCHURTRUE */
#ifdef CHARTRUE
		case SYMCHAR: erg+=mult_scalar_symchar(a,c,l);break;
#endif /* CHARTRUE */
		default:
			{
			printobjectkind(c);
			return error("mult_longint:wrong second type");
			}
		};
	if (erg != OK)
		return error("mult_longint:error in computation");
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT mult_longint_longint(a,c,l) OP a ,c,l;
/* AK 310590 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF ls,cs;
	copy_longint(a,l);
	ls = S_O_S(l);
	cs = S_O_S(c);
	return ganzmul(ls.ob_longint,cs.ob_longint);
		/* longinteger-multiplikation ist x:= x*y */
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT addinvers_apply_longint(a) OP a;
/* AK 201289 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF c;
	c = S_O_S(a);
	return(ganzneg(c.ob_longint));
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT addinvers_longint(a,l) OP a,l;
/* AK 180888 */ /* AK 130789 V1.0 */ /* AK 201289 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF c;

	copy(a,l);
	c = S_O_S(l);
	ganzneg(c.ob_longint);
		/* longinteger-addinvers ist x:= -x */
	return(OK);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
INT add_apply_longint(a,b) OP a,b;
/* AK 120390 V1.1 */ /* AK 190291 V1.2 */ /* AK 210891 V1.3 */
	{
	INT erg = OK;
	switch (S_O_K(b)) {
#ifdef BRUCHTRUE
		case BRUCH: erg += add_apply_scalar_bruch(a,b); break;
#endif /* BRUCHTRUE */
		case INTEGER: erg += add_apply_longint_integer(a,b); break;
		case LONGINT: erg += add_apply_longint_longint(a,b); break;
		default: /* AK 190291 */
			{
			OP c = callocobject();
			*c = *b;
			C_O_K(b,EMPTY);
			erg += add(a,c,b);
			erg += freeall(c);
			}
		}
	if (erg != OK) {
		error("add_apply_longint:error during computation");
		}
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
#ifdef MATRIXTRUE
INT mult_apply_longint_matrix(a,b) OP a,b;
/* AK 220390 V1.1 */ /* AK 190291 V1.2 */ /* AK 210891 V1.3 */
	{
	OP z = S_M_S(b);
	INT i = S_M_HI(b)*S_M_LI(b);
	INT erg=OK;
	for(;i>0;i--,z++)
		erg += mult_apply(a,z);
	return erg;
	}
#endif /* MATRIXTRUE */
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT mult_apply_longint(a,b) OP a,b;
/* AK 080390 V1.1 */ /* AK 190291 V1.2 */ /* AK 210891 V1.3 */
	{
	switch (S_O_K(b)) {
#ifdef BRUCHTRUE
		case BRUCH: 
				mult_apply_longint(a,S_B_O(b));
				kuerzen(b); 
				return(OK);
#endif /* BRUCHTRUE */
		case INTEGER: 
			return mult_apply_longint_integer(a,b);
		case LONGINT: 
			return mult_apply_longint_longint(a,b);
#ifdef MATRIXTRUE
		case MATRIX: 
			return mult_apply_longint_matrix(a,b);
#endif /* MATRIXTRUE */
		default: /* AK 190291 */
			{
			OP c = callocobject();
			INT erg=OK;
			*c = *b;
			C_O_K(b,EMPTY);
			erg += mult(a,c,b);
			erg += freeall(c);
			return erg;
			}
		}
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT add_apply_longint_longint(a,b) OP a,b;
/* AK 120390 V1.1 */ /* AK 050791 V1.3 */ /* AK 210891 V1.3 */
	{
	INT erg = OK;
	OBJECTSELF as,bs;
	as = S_O_S(a);
	bs = S_O_S(b);
	erg += ganzadd(bs.ob_longint,as.ob_longint);
	erg += t_longint_int(b);
	if (erg != OK)
		error("add_apply_longint_longint:error during computation");
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT mult_apply_longint_longint(a,b) OP a,b;
/* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as,bs;
	as = S_O_S(a);
	bs = S_O_S(b);
	return(ganzmul(bs.ob_longint,as.ob_longint));
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
INT add_apply_longint_integer(a,b) OP a,b;
/* AK 120390 V1.1 */ /* AK 050791 V1.3 */
	{
	INT erg = OK;
	OP c = callocobject();
	*c = *b;
	C_O_K(b,EMPTY);
	erg += add(a,c,b);
	erg += freeall(c);
	erg += t_longint_int(b);
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT mult_apply_longint_integer(a,b) OP a,b;
/* AK 080390 V1.1 */ /* AK 050791 V1.3 */
	{
	OP c = callocobject();
	INT erg = OK;
	*c = *b;
	C_O_K(b,EMPTY);
	erg += mult(a,c,b);
	erg += freeall(c);
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT add_apply_integer_longint(a,b) OP a,b;
/* b = a + b */ /* b ist LONGINT, a ist INTEGER */
/* AK 120390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF ls;
	ls = S_O_S(b);
	return(ganzsadd(ls.ob_longint,S_I_I(a)));
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT mult_apply_integer_longint(a,b) OP a,b;
/* b = a * b */ /* b ist LONGINT, a ist INTEGER */
/* AK 080290 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF ls;
	INT erg = OK;
	ls = S_O_S(b);
	erg += ganzsmul(ls.ob_longint,S_I_I(a));
	erg += t_longint_int(b);
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT mult_longint_integer(a,c,l) OP a,c,l;
/* a ist LONINT c ist INTEGER */ /* AK 180888 */
/* AK 130789 V1.0 */ /* AK 080290 V1.1 */ /* AK 210891 V1.3 */
	{
	INT erg = OK;
	OBJECTSELF ls;

	erg += copy_longint(a,l); ls = S_O_S(l);
	erg += ganzsmul(ls.ob_longint,S_I_I(c));
	erg += t_longint_int(l);
		/* longinteger-multiplikation ist x:= x*y */
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT add_longint_integer(a,c,l) OP a,c,l;
/* a is LONGINT c is INTEGER */ /* AK 180888 */
/* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF ls;
	copy_longint(a,l);
	ls = S_O_S(l);
	ganzsadd(ls.ob_longint,S_I_I(c));
		/* longinteger-addition ist x:= x+y */
	t_longint_int(l);
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT dec_longint(a) OP a;
/* AK 230888 */ /* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as ;
	as = S_O_S(a);
	ganzsadd(as.ob_longint,-1L);
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT inc_longint(a) OP a;
/* AK 230888 */ /* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as;
	as = S_O_S(a);

	return(ganzsadd(as.ob_longint,1L));
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT t_longint_int(a) OP a;
/* AK 150290 V1.1 */ /* umwandlung in INTEGER falls moeglich */
/* AK 210891 V1.3 */
	{
	OBJECTSELF cs;
	INT wert;
	if (S_O_K(a) == INTEGER) return OK;
	if (S_O_K(a) != LONGINT) return error("t_longint_int:no LONGINT");
	cs = S_O_S(a);
	if (cs.ob_longint ->laenge == 1L)
		if (cs.ob_longint ->floc ->w2 == 0L)
		if (cs.ob_longint ->floc ->w1 < 100L)
		{
		wert = intganz(cs.ob_longint);
		return m_i_i(wert,a);
		}
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT einsp_longint(a) OP a;
/* AK 271190 V1.1 */ /* AK 250291 V1.2 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF cs;
	cs = S_O_S(a);
	if (cs.ob_longint ->laenge == 1L)
	if (cs.ob_longint ->signum == 1L)
	if (cs.ob_longint ->floc ->w2 == 0L)
	if (cs.ob_longint ->floc ->w1 == 0L)
	if (cs.ob_longint ->floc ->w0 == 1L)
			return TRUE;
	return FALSE;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT t_int_longint(a,c) OP a,c;
/* umwandeln von INTEGER -> LONGINT AK 180888 */
/* AK 130789 V1.0 */ /* AK 150290 V1.1 */ /* AK 250391 V1.2 */
/* AK 210891 V1.3 */
	{
	INT erg = OK;
	OBJECTSELF cs;

	erg += init(LONGINT,c); 
	cs = S_O_S(c);
	erg += ganzint(cs.ob_longint,S_I_I(a));
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT comp_longint(a,c) OP a,c;
/* AK 180888 */ /* AK 130789 V1.0 */ /* AK 050790 V1.1 */ /* AK 210891 V1.3 */
	{
	OP d; INT erg;

	switch(S_O_K(c))
		{
		case INTEGER:
			{
			/* AK 190888 */
			OBJECTSELF as,ds;
			d = callocobject(); 
			t_int_longint(c,d); as=S_O_S(a); ds=S_O_S(d);
			erg = ganzvergleich(as.ob_longint, ds.ob_longint);
			freeall(d);
			return(erg);
			}
		case LONGINT:
			{
			OBJECTSELF as,cs;
			as=S_O_S(a); cs=S_O_S(c);
			erg = ganzvergleich(as.ob_longint, cs.ob_longint);
			return(erg);
			}
#ifdef BRUCHTRUE
		case BRUCH:
			{
			d = callocobject(); 
			m_scalar_bruch(a,d);
			erg = comp(d,c);
			freeall(d);
			return erg;
			}
#endif /* BRUCHTRUE */
		default: {
			printobjectkind(c);
			error("comp_longint:wrong second type");
			return(ERROR);
			}
		};
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
INT mod_longint(a,e,c) OP a,e,c;
/* modulo AK 180888 */ /* c = a mod e */ /* AK 130789 V1.0 */
/* AK 200290 V1.1 */ /* AK 210891 V1.3 */
	{
	OP d = callocobject(); 
	copy(a,d);
		/* noetig da sonst in a das divisionsergebnis steht */
	switch(S_O_K(e))
		{
		case INTEGER: {
			OBJECTSELF ds,cs;

			m_i_i(0L,c); ds = S_O_S(d); cs = S_O_S(c);
			ganzsquores(ds.ob_longint,&S_O_S(c).ob_INT ,S_I_I(e));
			freeall(d); return(OK);
			}
		case LONGINT: {
			OBJECTSELF es,ds,cs;

			init(LONGINT,c);
			ds = S_O_S(d); cs = S_O_S(c); es = S_O_S(e);
			ganzmod(ds.ob_longint,cs.ob_longint, es.ob_longint);
			freeall(d); return(OK);
			}
		default: {
			freeall(d);freeself(c);
			printobjectkind(e);
			error("mod_longint:wrong second type");
			return(ERROR);
			}
		}
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT ganzdiv_longint(a,e,c) OP a,e,c;
/* ganzdiv AK 220888 */ /* c = a / e */
/* AK 130789 V1.0 */ /* AK 150290 V1.1 */ /* AK 140691 V1.2 */
/* AK 210891 V1.3 */
	{
	INT erg = OK;
	switch (S_O_K(e))
		{
		case INTEGER:
			{
			OBJECTSELF cs;
			INT	rest;
			erg += copy(a,c);
			if (erg)
				{ error("ganzdiv_longint:erg(1)"); }
			cs = S_O_S(c); 
			erg += ganzsquores(cs.ob_longint,&rest,S_I_I(e));
			if (erg)
				{ error("ganzdiv_longint:erg(2)"); }
			erg += t_longint_int(c);
			if (erg)
				{ 
				fprintln(stderr,c);
				fprintf(stderr,"erg = %ld\n",erg);
				error("ganzdiv_longint:erg(3)"); }
			break;
			}
		case LONGINT:
			{
			OBJECTSELF es,cs;
			erg += copy(a,c); 
			if (erg)
				{ error("ganzdiv_longint:erg(4)"); }
			cs = S_O_S(c); 
			es = S_O_S(e);
			erg += ganzganzdiv(cs.ob_longint, es.ob_longint);
			if (erg)
				{ error("ganzdiv_longint:erg(5)"); }
			erg += t_longint_int(c);
			if (erg)
				{ error("ganzdiv_longint:erg(6)"); }
			break;
			}
#ifdef BRUCHTRUE
		case BRUCH:
			{
			if (einsp(S_B_U(e)))
				{
				erg += ganzdiv_longint(a,S_B_O(e),c);
				erg += t_longint_int(c);
				}
			else
				erg += error("ganzdiv_longint: wrong bruch");
			break;
			}
#endif /* BRUCHTRUE */
		default:
			{
			printobjectkind(e);
			erg += error("ganzdiv_longint:wrong second type");
			break;
			}
		};
	if (erg != OK)
		{
		printobjectkind(a);
		printobjectkind(e);
		error("ganzdiv_longint: error during computation");
		return erg;
		}
	return erg;
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT quores_longint(a,e,c,d) OP a,e,c,d;
/* ganzdiv AK 220888 */ /* c = a / e */
/* AK 130789 V1.0 */ /* AK 150290 V1.1 */ /* AK 210891 V1.3 */
	{
	switch (S_O_K(e))
		{
		case INTEGER:
			{
			OBJECTSELF cs;
			INT	rest;
			copy(a,c);cs = S_O_S(c); 
			ganzsquores(cs.ob_longint,&rest,S_I_I(e));
			t_longint_int(c);
			m_i_i(rest,d);
			return(OK);
			}
		case LONGINT:
			{
			OBJECTSELF es,cs,ds;
			copy(a,c); copy(c,d);
			cs = S_O_S(c); es = S_O_S(e); ds = S_O_S(d);
			ganzquores(cs.ob_longint, ds.ob_longint,es.ob_longint);
			t_longint_int(c);
			t_longint_int(d);
			return(OK);
			}
		default:
			{
			printobjectkind(e);
			return error("quores_longint:wrong second type");
			}
		};
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
INT scan_longint(a) OP a;
/* AK 180888 */ /* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as;
	
	printeingabe("longint:");
	init(LONGINT,a);as=S_O_S(a);
	ganzein(stdin,as.ob_longint,&gd);
	if (nullp(a) ) { /* AK 020889 V1.0 */
		freeself(a);
		m_i_i(0L,a); 
		}
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT posp_longint(a) OP a;
/* AK 190888 */ /* AK 280689 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as;
	as=S_O_S(a);
	return(ganzsignum(as.ob_longint) == 1L);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT odd_longint(a) OP a;
/* AK 061190 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as;
	as=S_O_S(a);
	return ganzodd(as.ob_longint);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT even_longint(a) OP a;
/* AK 061190 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as;
	as=S_O_S(a);
	return ganzeven(as.ob_longint);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT nullp_longint(a) OP a;
/* AK 190888 */ /* AK 280689 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as;
	as=S_O_S(a);
	return(ganzsignum(as.ob_longint) == 0L);
	}
#endif /* LONGINTTRUE */


#ifdef LONGINTTRUE
INT negp_longint(a) OP a;
/* AK 190888 */ /* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF as;
	as=S_O_S(a);
	return(ganzsignum(as.ob_longint) == -1);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT objectread_longint(f,l) FILE *f; OP l;
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF ls;

	init(LONGINT,l);
	ls=S_O_S(l);
	ganzein(f, ls.ob_longint, &gd);
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT objectwrite_longint(f,l) FILE *f; OP l;
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OBJECTSELF ls;

	if (nullp(l)) { /* AK 020889 V1.0 */
		freeself(l);m_i_i(0L,l);objectwrite_integer(f,l);return(OK);}

	fprintf(f," %d ",LONGINT);
	ls=S_O_S(l);
	ganzaus(f, ls.ob_longint,&gd); fprintf(f,"\n"); return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzparam(basis,auspos,auslaenge,folgezeichen,d) 
	INT basis,auspos,auslaenge;
	char	folgezeichen; struct ganzdaten *d;
/* AK Mon Mar 13 10:24:35 MEZ 1989 */
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	if (basis>1L) d->basis=basis; else error("ganzparam:basis negativ");

	if (auspos>1L) d->auspos=auspos; else d->auspos = 2;
	if (basis <= 10L) d->basislaenge = 1; else
	if (basis <= 100L) d->basislaenge = 2; else
	if (basis <= 1000L) d->basislaenge = 3; else
	if (basis <= 10000L) d->basislaenge = 4; else
	if (basis <= 100000L) d->basislaenge = 5; else
	if (basis <= 1000000L) d->basislaenge = 6; else
	if (basis <= 10000000L) d->basislaenge = 7; else
	if (basis <= 100000000L) d->basislaenge = 8; else
	if (basis <= 1000000000L) d->basislaenge = 9; else
				  d->basislaenge = 10;
	if (auslaenge > d->basislaenge) d->auslaenge = auslaenge;
	else d->auslaenge = d->basislaenge+1;
	d->folgezeichen = folgezeichen;return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzanfang(d) struct ganzdaten *d;
/* AK: Tue Mar 14 08:43:55 MEZ 1989 */
/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	d->vorrat = 0L; d->speicher = 0L; d->floc = NULL; d->auszz = 0L;
	d->basis = 1000000L; d->basislaenge = 6L; d->folgezeichen = '.';
	d->auspos = 2L; d->auslaenge = 78L; return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzdefiniere(x) struct longint *x;
/* AK: Tue Mar 14 08:47:54 MEZ 1989 */
/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	x->signum = (signed char)0; x->laenge = 1L; x->floc = NULL;
	lochole(&x->floc);
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
static INT ganzloesche(x) struct longint *x;
/* AK: Tue Mar 14 08:49:35 MEZ 1989 */

/* dieser Teil wurde von Peter Hain in Karlsruhe
entworfen. Er schrieb diese Langzahl arithmetik in Pascal und
Assembler. In Bayreuth wurden in Form eines Seminars die
Assemblerteile in C geschrieben und spaeter wurde von
Axel Kohnert die restlichen Pascalteile in C uebersetzt.
Die Ein und Ausgabe routinen wurden vollstaendig in Bayreuth
entworfen */
/* AK 130789 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	loclisterette(&x->floc);
	x->laenge = 0L; x->signum = (signed char)0;
	return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT m_i_longint(a,b) OP b;INT a;
/* AK 180888 */ /* AK 270689 V1.0 */ /* AK 080390 V1.1 */ /* AK 210891 V1.3 */
	{
	OP c = callocobject(); 
	m_i_i(a,c);		/* make INT --> INTEGER */
	t_int_longint(c,b); /* transform INTEGER --> LONGINT */
	freeall(c); return(OK);
	}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT debugprint_longint(a) OP a;
/* AK 020390 V1.1 */ /* AK 210891 V1.3 */
{
	OBJECTSELF c;
	c = s_o_s(a);
	fprintf(stderr,"kind:22=longint\n");
	fprintf(stderr,"laenge = %ld\n",
	    c.ob_longint->laenge);
	fprintf(stderr,"signum = %d\n",
	    c.ob_longint->signum);
	return(OK);
}
#endif /* LONGINTTRUE */

#ifdef LONGINTTRUE
INT test_longint() {
/* AK 020390 V1.1 */ /* AK 210891 V1.3 */
	OP a = callocobject();
	OP b = callocobject();
	OP c = callocobject();

	start_longint();
	printf("test_longint:scan(a)"); scan(LONGINT,a);println(a);
	printf("test_longint:add(a,a,b)"); add(a,a,b); println(b);
	printf("test_longint:mult(a,b,b)"); mult(a,b,b); println(b);
	printf("test_longint:m_i_i(-1L,c);mult(c,b,b)");
	m_i_i(-1L,c); mult(c,b,b); println(b);
	printf("test_longint:m_i_i(-1L,c);add(c,b,b)");
	m_i_i(-1L,c); add(c,b,b); println(b);
#ifdef BRUCHTRUE
	printf("test_longint:invers(b,a)"); invers(b,a); println(a);
#endif /* BRUCHTRUE */
	printf("test_longint:mult(b,a,a)"); mult(b,a,a); println(a);

	printf("test_longint:m_i_i(3L,c);div(a,c,b)");
	m_i_i(3L,c); div(a,c,b); println(b);
	printf("test_longint:m_i_i(100L,c);fakul(c,b)");
	m_i_i(100L,c); fakul(c,b); println(b);

	freeall(a);freeall(b);freeall(c);
	return(OK);
	}
#endif /* LONGINTTRUE */
	
#ifdef LONGINTTRUE
INT random_longint(erg,ober) OP erg,ober;
/* AK 080390 V1.1 */
/* ober ist beim ersten aufruf die obere grenze, spater NULL */
/* AK 210891 V1.3 */
	{
	static OP o = NULL; /* obere grenze */
	static OP m = NULL; /* modulo */
	static OP x = NULL; /* ergebnis */
	static OP a = NULL; /* multiplier */
	INT l,i;
	OP h1,h2,h3;
	if (ober == NULL) {
		if (o == NULL) return(
				error("random_longint: no initialisation"));
		}
	else	{
		if (o == NULL) {
			o=callocobject(); a=callocobject();
			x=callocobject(); m=callocobject();
			}
		else 	{
			freeself(o); freeself(a); freeself(x); freeself(m);
			}
		copy(ober,o);
		h1 = callocobject(); h2 = callocobject();
		h3 = callocobject();
		l = (S_O_S(ober).ob_longint->laenge) * 3 ; /* laenge */
		m_i_i(10L,m);m_i_i(l*6L,h1);hoch(m,h1,m);
		m_i_i(222222L,a);m_i_i(1000000L,h2);
		m_i_i(222222L,h1);
		m_i_i(0L,x);
		for (i=1;i<=l;i++)
			{
			mult(a,h2,a);
			add(h1,a,a);
			random_integer(h3,NULL,h2);
			mult(x,h2,x);
			add(h3,x,x);
			}
		mod(x,o,erg); 
		freeall(h1); freeall(h2); freeall(h3);
		return(OK);
		}
	/* dies ist der fall dass initialisiert ist */
	h1 = callocobject();
	mult(x,a,h1);
	mod(h1,m,x);
	mod(x,o,erg); 
	freeall(h1);return(OK);
	}
#endif /* LONGINTTRUE */
