/* file: sb.c */
#include "def.h"
#include "macro.h"

#ifdef SCHUBERTTRUE
static INT algorithmus2();
static INT algorithmus3();
static INT algorithmus4();
static INT pol_sch_alg01();
static INT co_L9();
#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT einsp_schubert(a) OP a;
/* AK 200691 V1.2 */ /* AK 200891 V1.3 */
	{
	if (einsp(S_SCH_S(a)))
		if (einsp(S_SCH_K(a)))  
			if (S_SCH_N(a) == NULL) return TRUE;
	return FALSE;
	}
#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT schubertp(a) OP a; 
/* AK 200891 V1.3 */
	{
	if (s_o_k(a) == SCHUBERT) return TRUE;
	else                      return FALSE;
	}
#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE

INT m_lehmer_schubert_monom_summe(a,b) OP a,b;
/* AK 061288 */ /* AK 240789 V1.0 */ /* AK 190690 V1.1 */ /* AK 090891 V1.3 */
	{
	INT erg = OK; /* AK 191191 */
	OP p = callocobject(); 
	erg += lehmercode(a,p);
	erg += m_perm_schubert_monom_summe(p,b);
	erg += freeall(p);
	return erg;
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT m_perm_schubert_monom_summe(perm,res) OP perm,res;
/* Eingabe: PERMUTATION als label des Schubertpolynoms */
/* Ausgabe: POLYNOM */
/* 020588 */ /* AK 240789 V1.0 */ /* AK 120790 V1.1 */ /* AK 090891 V1.3 */
	{
	OP vorfaktor;
		/* das monom, mit dem das ergebnis einer einzelnen
		rekursion multipliziert werden muss */
		/* beim start = [0,0,0,0,....,0] */
	INT i;
	if (einsp(perm)) /* AK 191191 */
		return m_scalar_polynom(cons_eins,res);
	if (not EMPTYP(res)) 
		freeself(res);
	vorfaktor = callocobject(); 
	m_il_v(S_P_LI(perm),vorfaktor);
	for (i=0L;i<S_V_LI(vorfaktor);i++) 
			M_I_I(0L,S_V_I(vorfaktor,i));
		/* vorfaktor ist nun initialisiert */
	algorithmus2(vorfaktor,0L,S_P_LI(perm)-1L,perm,res);
		/* die rekursion wird aufgerufen */
	freeall(vorfaktor);
		/* vorfaktor wird freigegeben  ==> kein speicher bedarf */
	return OK;
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT m_perm_schubert_qpolynom(perm,res) OP perm,res;
/* 020588 */ /* AK 240789 V1.0 */ /* AK 040190 V1.1 */ /* AK 090891 V1.3 */
	{
	if (not EMPTYP(res)) freeself(res);
	algorithmus4(0L,0L,S_P_LI(perm)-1L,perm,res);
	return(OK);
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT m_perm_schubert_dimension(perm,res) OP perm,res;
/* 020588 */ /* AK 240789 V1.0 */ /* AK 120790 V1.1 */ /* AK 090891 V1.3 */
	{
	if (not EMPTYP(res)) freeself(res); 
	M_I_I(0L,res); 
	return algorithmus3(0L,perm,res);
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT t_POLYNOM_SCHUBERT(pol,sch) OP pol,sch;
/* AK 240789 V1.0 */ /* AK 131290 V1.1 */
/* AK 150291 V1.2 */ /* AK 090891 V1.3 */
	{
	OP p; /* wird copie des polynoms */
	if (pol == sch) /* AK 220891 */
		{
		p = callocobject();
		*p = *sch;
		C_O_K(sch,EMPTY);
		t_POLYNOM_SCHUBERT(p,sch);
		freeall(p);
		return OK;
		}
	if (not EMPTYP(sch)) 
		freeself(sch); 
	if (EMPTYP(pol)) 
		return OK;
	p = callocobject(); 
	copy(pol,p); 
	pol_sch_alg01(p,sch); 
	freeall(p); 
	return(OK);
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
static INT pol_sch_alg01 (p,s) OP p,s;
/* AK 240789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{
	OP l,res,schub;
	INT i,j;

pol_sch_alg01l2:
	l = callocobject(); res = callocobject(); schub = callocobject(); 

	if (S_O_K(p) != POLYNOM) 
		{
		printobjectkind(p);
		debugprint(p);
		return error("pol_sch_alg01: p not POLYNOM");
		}
	copy(S_PO_S(p),l);
	if (S_O_K(l) != VECTOR) 
		{ 
		debugprint(l);
		return error("pol_sch_alg01: not vectortype in p"); 
		}

pol_sch_alg01l1:
	for (i=0L,j=S_V_LI(l)-1L;i<S_V_LI(l);i++,j--)
	    if(S_V_II(l,i) > j)
		{ 
		inc_vector(l);
		M_I_I(0L,S_V_I(l,S_V_LI(l)-1L));
		goto pol_sch_alg01l1;
		}
/* nun ist l ein lehmercode */

	b_skn_sch(callocobject(),callocobject(),NULL,schub);
	copy(S_PO_K(p),S_SCH_K(schub));
	lehmercode(l,S_SCH_S(schub));
	


	if (not EMPTYP(res)) freeself(res);
	m_lehmer_schubert_monom_summe(l,res);
	mult_apply(S_PO_K(p),res);
	sub(p,res,p);
	insert(schub,s,NULL,comp_monomvector_monomvector);
	freeall(res); freeall(l);
	if (not EMPTYP(p)) 
		if (not empty_listp(p)) goto pol_sch_alg01l2;
	return OK;
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
static INT algorithmus2(vorfaktor,alphabetindex,stufe,perm,res)
	OP vorfaktor; /* ist ein monom, d.h. vector */
		/* bsp [0,1,0] == b^2 */
		/* damit wird das ergebnis dieser rekursion 
		multipliziert und in res eingefuegt */
	INT alphabetindex; 
		/* ist der start des alphabets a==0 */
		/* d.h. wird nur noch im alphabet b,c,d, ..
		gerechnet so ist dies =1 */
	INT stufe; /* der exponent des Vorfaktors */
	OP perm; /* die permutation zu der berechnet wird */
	OP res; /* das globale ergebnis */
/* AK 020588 */ /* AK 081188 */ /* AK 240789 V1.0 */ /* AK 201189 V1.1 */
/* AK 090891 V1.3 */
	{
	if (S_O_K(perm) != PERMUTATION) 
		return error("algorithmus2:no PERMUTATION");
	if (S_O_K(vorfaktor) != VECTOR) 
		return error("algorithmus2:no VECTOR");
	if (S_V_LI(vorfaktor) == 0L)
		return error("algorithmus2:vorfaktor == 0");
	if (S_P_LI(perm) == 2L)	
		/* ende des algorithmus */
		{
		OP monom = callocobject(); 
		b_skn_po(callocobject(),callocobject(),NULL,monom);
		M_I_I(1L,S_PO_K(monom));
		copy(vorfaktor,S_PO_S(monom));
		/* das monom ist nun fertig initialisiert */

		if (S_P_II(perm,0L) == 2L) 
			inc(S_PO_SI(monom,alphabetindex));
			/* der vorfaktor wird noch mit dem i-ten
			buchstaben multipliziert falls perm = [2,1] */
		insert(monom,res,add_koeff,comp_monomvector_monomvector);
			/* einfuegen des ergebnis in das globale ergebnis */
		return OK;
		}


	if (S_P_II(perm,0L) == S_P_LI(perm)) /* nun die rekursion */
		{
		OP neuperm = callocobject(); 
		OP neufaktor = callocobject(); 
		INT i;

		b_ks_p(VECTOR,callocobject(),neuperm);
		m_il_v(S_P_LI(perm)-1L,S_P_S(neuperm));
		for(i=0L;i<S_P_LI(neuperm);i++) 
			M_I_I(S_P_II(perm,i+1L),S_P_I(neuperm,i));
		/* es wurde die permutation um das erste element
		welches das groesste war gekuerzt, hier wurde
		ausgenutzt 
		z.B X_634215 = a^6 X_34215(b,c,d,e,f)
		diese multiplikation folgt nun
		*/

		copy_vector(vorfaktor,neufaktor);
		M_I_I(stufe,S_V_I(neufaktor,alphabetindex));
		algorithmus2(	neufaktor,alphabetindex+1,
				S_P_LI(neuperm)-1,neuperm,res);
		freeall(neufaktor);
		freeall(neuperm);
		return OK;
		}
	else	{	/* falls keine rekursion im alphabet */
		INT i;
		INT maximal = S_P_LI(perm)+1L;
		OP neuperm = callocobject(); 
		for (i=1L;i<S_P_LI(perm);i++)
			if (	(S_P_II(perm,i) < maximal)&&
				(S_P_II(perm,i) > S_P_II(perm,0L)))
				{
				copy(perm,neuperm);
				maximal = S_P_II(perm,i);
				M_I_I(S_P_II(perm,0L),S_P_I(neuperm,i));
				M_I_I(S_P_II(perm,i),S_P_I(neuperm,0L));

				algorithmus2(vorfaktor,alphabetindex,
						stufe-1L,neuperm,res);
				};
		freeall(neuperm);
		return OK;
		}
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE

static INT algorithmus4(exponent,alphabetindex,stufe,perm,erg)
	INT exponent; /* ist ein monom, d.h. vevtor */
			/* bsp [0,1,0] == b^2 */
	INT alphabetindex; /* ist der startdes alphabets a==0 */
	INT stufe; /* der exponent des Vorfaktors */
	OP perm; /* die permutation zu der berechnet wird */
	OP erg;
/* AK 020588 */ /* AK 240789 V1.0 */
/* AK 170190 V1.1 */ /* aendern monom nicht mehr integer sondern vector */
/* AK 090891 V1.3 */
	{
	if (S_P_LI(perm) == 2L)	/* ende des algorithmus */
		{
		OP monom = callocobject(); 
		b_skn_po(callocobject(),callocobject(),NULL,monom);
			 /* monom has now emptyp self and koeff */
		M_I_I(1L,S_PO_K(monom));
		m_il_v(1L,S_PO_S(monom));
		M_I_I(exponent,S_PO_SI(monom,0L));
		/* das monom ist nun fertig initialisiert */

		if (S_P_II(perm,0L) == 2L) 
			M_I_I(exponent+alphabetindex,S_PO_SI(monom,0L));

		insert(monom,erg,add_koeff,comp_monomvector_monomvector);
			/* einfuegen des ergebnis in das globale ergebnis */
		return(OK);
		}

	if (S_P_II(perm,0L) == S_P_LI(perm)) /* nun die rekursion */
		{
		OP neuperm = callocobject(); 
		INT i;

		b_ks_p(VECTOR,callocobject(),neuperm);
		m_il_v(S_P_LI(perm)-1L,S_P_S(neuperm));
		for(i=0L;i<S_P_LI(neuperm);i++) 
			M_I_I(S_P_II(perm,i+1L),S_P_I(neuperm,i));
		
		algorithmus4(exponent + stufe*alphabetindex ,alphabetindex+1L,
				S_P_LI(neuperm)-1L,neuperm,erg);
		
		freeall(neuperm);
		return(OK);
		}
	else	{
		INT i;
		INT maximal = S_P_LI(perm)+1L;
		for (i=1L;i<S_P_LI(perm);i++)
			if (	(S_P_II(perm,i) < maximal)&&
				(S_P_II(perm,i) > S_P_II(perm,0L)))
				{
				OP neuperm = callocobject(); 
				copy_permutation(perm,neuperm);
				maximal = S_P_II(perm,i);
				M_I_I(S_P_II(perm,0L),S_P_I(neuperm,i));
				M_I_I(S_P_II(perm,i),S_P_I(neuperm,0L));

				algorithmus4(exponent,alphabetindex,
						stufe-1L,neuperm,erg);
				freeall(neuperm);
				};
		return(OK);
		}
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
static INT algorithmus3(alphabetindex,perm,erg)
	INT alphabetindex; /* ist der startdes alphabets a==0 */
	OP perm; /* di epermutation zu der berechnet wird */
	OP erg;
	/* AK 020588 */
/* AK 240789 V1.0 */ /* AK 191190 V1.1 */
/* AK 090891 V1.3 */
	{
	if (S_P_LI(perm) == 2L)	/* ende des algorithmus */
		{ inc(erg); return(OK); }

	if (S_P_II(perm,0L) == S_P_LI(perm)) /* nun die rekursion */
		{
		OP neuperm = callocobject(); 
		INT i;

		b_ks_p(VECTOR,callocobject(),neuperm);
		m_il_v(S_P_LI(perm)-1L,S_P_S(neuperm));
		for(i=0L;i<S_P_LI(neuperm);i++) 
			M_I_I(S_P_II(perm,i+1L),S_P_I(neuperm,i));
		algorithmus3(alphabetindex+1L,neuperm,erg);
		freeall(neuperm);
		return(OK);
		}
	else	{
		INT i;
		INT maximal = S_P_LI(perm)+1L;
		for (i=1L;i<S_P_LI(perm);i++)
			if (	(S_P_II(perm,i) < maximal)&&
				(S_P_II(perm,i) > S_P_II(perm,0L)))
				{
				OP neuperm = callocobject(); 
				copy(perm,neuperm);
				maximal = S_P_II(perm,i);
				M_I_I(S_P_II(perm,0L),S_P_I(neuperm,i));
				M_I_I(S_P_II(perm,i),S_P_I(neuperm,0L));

				algorithmus3(alphabetindex,neuperm,erg);
				freeall(neuperm);
				};
		return(OK);
		}
	}



#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE

INT all_ppoly(a,c,b) OP a,b,c;
/* AK 201189 V1.1 */ /* AK 090891 V1.3 */
{
/* a is PARTITION, c is INTEGER-limit , b becomes result */

	INT i,j,k;
	OP w = callocobject();
	for (i=0L;i<=S_I_I(c);i++)
	 {
	 OP d = callocobject();
	 OP e = callocobject(); /* becomes permutation with lehmercode d */
	 OP f = callocobject(); /* becomes q specialisation */
	 OP g = callocobject();
	 m_il_v(i+S_PA_LI(a)+s_pa_ii(a,S_PA_LI(a)-1L),d);
	 for (j=0L;j<i;j++) M_I_I(0L,S_V_I(d,j));
	 for (k=0L;k<S_PA_LI(a);k++,j++) copy(s_pa_i(a,k),S_V_I(d,j));

	 for (k=0L;k<s_pa_ii(a,S_PA_LI(a)-1L);k++,j++)  M_I_I(0L,S_V_I(d,j));
	 println(d);
	 lehmercode(d,e); println(e);
	 m_perm_schubert_qpolynom(e,f);
	 b_skn_po(callocobject(),f,NULL,g); ;
	 m_il_v(1L,S_PO_S(g));
	 M_I_I(i,S_PO_SI(g,0L)); println(g);
	 add(g,b,b);
	 freeall(g);
	 freeall(e);
	 freeall(d);
	 }
	weight(a,w);
	println(b);
	for (i=0L;i<=S_I_I(w);i++)
	 {
	 OP p = callocobject();
	 OP q = callocobject();
	 b_skn_po(callocobject(),callocobject(),NULL,p);
	 b_skn_po(callocobject(),callocobject(),NULL,S_PO_K(p));
	 M_I_I(1L,S_PO_K(S_PO_K(p)));
	 M_I_I(0L,S_PO_S(S_PO_K(p)));
	 m_il_v(1L,S_PO_S(p));M_I_I(0L,S_PO_SI(p,0L));
	 println(p);
	 b_skn_po(callocobject(),callocobject(),NULL,q);
	 b_skn_po(callocobject(),callocobject(),NULL,S_PO_K(q));
	 M_I_I(-1L,S_PO_K(S_PO_K(q)));
	 M_I_I(i,S_PO_S(S_PO_K(q)));
	 m_il_v(1L,S_PO_S(q));M_I_I(1L,S_PO_SI(q,0L));
	 println(q);
	 add(p,q,q);println(q);
	 mult(q,b,b);println(b);
	 }
	return(OK);
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT tex_schubert(poly) OP poly;
/* AK 101187 */ /* AK 240789 V1.0 */ /* AK 191190 V1.1 */
/* AK 070291 V1.2 prints to texout */ /* AK 090891 V1.3 */
	{
	OP zeiger = poly;
	INT i,j;

	fprintf(texout,"\\ "); if (EMPTYP(poly)) return(OK);
	while (zeiger != NULL)
		{
		if (not einsp (S_SCH_K(zeiger)))
			/* der koeffizient wird nur geschrieben wenn er
			ungleich 1 ist */
			tex(S_SCH_K(zeiger));
		fprintf(texout,"\\ $X_{ "); 
		fprint(texout,S_SCH_S(zeiger)); 
		fprintf(texout," } $\\ ");
		zeiger = S_SCH_N(zeiger); 
		if (zeiger != NULL) fprintf(texout," $+$ ");
		texposition += 15L;
		if (texposition >70L) {fprintf(texout,"\n");texposition = 0L;}
		};
	fprintf(texout,"\\ "); texposition += 3L;
	return(OK);
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT add_schubert_schubert(a,b,c) OP a,b,c;
/* AK 191190 V1.1 */ /* AK 090891 V1.3 */
{
	INT erg;
	OP d = callocobject();
	if (not EMPTYP(c)) freeself(c);
	copy_list(a,d); 
	copy_list(b,c);
	
	erg = insert(d,c,add_koeff,comp_monomvector_monomvector);

	return(erg);
}

			
#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE

INT m_skn_sch(self,koeff,next,ergebnis) OP self,koeff,next,ergebnis;
/* AK 110789 V1.0 */ /* AK 191190 V1.1 */ /* AK 090891 V1.3 */
	{
	if (ergebnis == NULL)
		 return error("m_skn_sch:ergebnis == NULL");

	m_skn_po(self,koeff,next,ergebnis); C_O_K(ergebnis,SCHUBERT);
	return(OK);
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT b_skn_sch(self,koeff,next,ergebnis) OP self,koeff,next,ergebnis;
/* AK 110789 V1.0 */ /* AK 191190 V1.1 */ /* AK 090891 V1.3 */
	{
	if (ergebnis == NULL)
		{ error("b_skn_sch:ergebnis == NULL"); return(ERROR); };

	b_skn_po(self,koeff,next,ergebnis); C_O_K(ergebnis,SCHUBERT);
	return(OK);
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT scan_schubert(ergebnis) OP ergebnis;
/* AK 110789 V1.0 */ /* AK 191190 V1.1 */ /* AK 090891 V1.3 */
	{
	char antwort[2];
	OBJECTKIND kind;

	b_skn_sch( callocobject(), callocobject(), callocobject(), ergebnis);
	printeingabe("input of Schubert-monom as permutation");
	scan(PERMUTATION,S_SCH_S(ergebnis));
	printeingabe("input kind of coeff");
	kind = scanobjectkind();
	scan(kind,S_SCH_K(ergebnis));
	printeingabe("one more monom y/n"); scanf("%s",antwort);
	if (antwort[0]  == 'y') 	scan(SCHUBERT,S_SCH_N(ergebnis));
	else 		{ free(S_SCH_N(ergebnis));c_sch_n(ergebnis,NULL); }
	return(OK);
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
OP s_sch_s(a) OP a;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_s:a == NULL"), (OP) NULL;
	if (not schubertp(a)) return 
		error("s_sch_s:a != SCHUBERT"), (OP) NULL;
	return(s_mo_s(s_l_s(a))); 
	}

OP s_sch_k(a) OP a;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_k:a == NULL"), (OP) NULL;
	if (not schubertp(a)) return 
		error("s_sch_k:a != SCHUBERT"), (OP) NULL;
	return(s_mo_k(s_l_s(a))); 
	}

OP s_sch_n(a) OP a;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_n:a == NULL"), (OP) NULL;
	if (not schubertp(a)) return 
		error("s_sch_n:a != SCHUBERT"), (OP) NULL;
	return(s_l_n(a)); 
	}

OP s_sch_si(a,i) OP a; INT i;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_si:a == NULL"), (OP) NULL;
	if (not schubertp(a)) return 
		error("s_sch_si:a != SCHUBERT"), (OP) NULL;
	return s_p_i(s_sch_s(a),i); 
	}

OP s_sch_sl(a) OP a;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_sl:a == NULL"), (OP) NULL;
	if (not schubertp(a)) return 
		error("s_sch_sl:a != SCHUBERT"), (OP) NULL;
	return s_p_l(s_sch_s(a)); 
	}

INT s_sch_ki(a) OP a;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_ki:a == NULL");
	if (not schubertp(a)) return error("s_sch_ki:a != SCHUBERT");
	return s_i_i(s_sch_k(a)); 
	}

INT s_sch_sii(a,i) OP a; INT i;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_sii:a == NULL");
	if (not schubertp(a)) return error("s_sch_sii:a != SCHUBERT");
	return s_p_ii(s_sch_s(a),i); 
	}


INT s_sch_sli(a) OP a; 
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	if (a == NULL) return error("s_sch_sli:a == NULL");
	if (not schubertp(a)) return error("s_sch_sli:a != SCHUBERT");
	return s_p_li(s_sch_s(a)); 
	}

INT c_sch_n(a,b) OP a,b;
/* AK 110789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{ 
	OBJECTSELF c; 
	if (a == NULL) return error("c_sch_n:a == NULL");
	c = s_o_s(a); 
	c.ob_list->l_next = b; return OK; 
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT display_schubert(a) OP a;
/* AK 240789 V1.0 */ /* AK 131290 V1.1 */ /* AK 090891 V1.3 */
	{return(fprintln(a));}


#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT test_schubert() 
/* AK 200891 V1.3 */
	{
	OP a = callocobject();
	OP b = callocobject();

	printf("test_schubert:scan(PERMUTATION)\n");
	scan(PERMUTATION,a);println(a);
	printf("test_schubert:m_perm_schubert_monom_summe(a,b)\n");
	m_perm_schubert_monom_summe(a,b);
	println(b);
	printf("test_schubert:scan(POLYNOM)\n");
	scan(POLYNOM,a);println(a);
	printf("test_schubert:t_POLYNOM_SCHUBERT(a,b)\n");
	t_POLYNOM_SCHUBERT(a,b);println(b);
	printf("test_schubert:tex(b)\n");
	tex(b);
	printf("test_schubert:scan(SCHUBERT,a)\n");
	scan(SCHUBERT,a); println(a);
	printf("test_schubert:hoch(a,2L,b)\n");
	hoch(a,cons_zwei,b); println(b);
	printf("test_schubert:einsp(b)\n");
	if (not einsp(b))
		printeingabe("not eins");
	else
		printeingabe("is eins");

	freeall(a);freeall(b);
	return(OK);
	}
#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
	
INT mult_apply_schubert(a,b) OP a,b;
/* AK  191190 V1.1 */ /* AK 090891 V1.3 */
{
	OP c = callocobject();
	*c = *b; 
	C_O_K(b,EMPTY); 
	mult(a,c,b);
	freeall(c);
	return OK;
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT print_schubert_difference(b,c) OP b,c;
/* druckt in spezieller weise aus
b ist ein einzelnes Schubertpolynom, c ist eine summe von Schubertpolynomen
gedruckt werden nur die stellen die verschieden in den permutationen */
/* AK 200690 */
/* AK 200891 V1.3 */
{ 
OP x; INT i;
x = c; while ( x != NULL) {
	print(S_SCH_K(b)); printf(" [");
	for (i=0L;(i < S_SCH_SLI(x))&&
		 (i <S_SCH_SLI(b)) ; i++ )
		{
		if (S_SCH_SII(x,i)==S_SCH_SII(b,i)) printf(".,");
		else printf("%d,",S_SCH_SII(b,i));
		zeilenposition += 2L;
		} printf("]\n");
	print(S_SCH_K(x)); printf(" [");
	for (i=0L;(i < S_SCH_SLI(x))&&
		 (i <S_SCH_SLI(b)) ; i++ )
		{
		if (S_SCH_SII(x,i)==S_SCH_SII(b,i)) printf(".,");
		else printf("%d,",S_SCH_SII(x,i));
		zeilenposition = 0L;
		} printf("]\n\n");
	x = S_SCH_N(x);
	}
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT t_SCHUBERT_POLYNOM(a,b) OP a,b;
/* AK 210690 V1.1 */ /* AK 210291 V1.2 */ /* AK 090891 V1.3 */
{
	OP z=a;
	OP c = callocobject();
	if (not EMPTYP(b)) freeself(b);
	while(z != NULL) {
		m_perm_schubert_monom_summe(S_SCH_S(z),c);
		mult_apply(S_SCH_K(z),c); /* missing in V1.1 */
		add_apply(c,b);
		z = S_SCH_N(z);
		}
	freeall(c); return OK;
}

			
#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE

INT mult_scalar_schubert(von,nach,ergebnis) OP von, nach, ergebnis;
/* AK 110789 V1.0 */ /* AK 191190 V1.1 */ /* AK 090891 V1.3 */
	{
	mult_scalar_polynom(von,nach,ergebnis); 
	C_O_K(ergebnis,SCHUBERT);
	return OK;
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT mult_schubert_schubert(a,b,c) OP a,b,c;
/* AK 210690 V1.1 */ /* AK 090891 V1.3 */
{
	INT dt = 0L;
	OP d;
	if (S_SCH_SLI(a) > S_SCH_SLI(b)) { d=a; a=b; b=d; }
	d=callocobject();
	t_SCHUBERT_POLYNOM(a,d);
	if (dt) {
		fprintf(stderr,"mult_schubert_schubert: polynom= ");
		fprintln(stderr,d);
		fprintf(stderr,"mult_schubert_schubert: schubert= ");
		fprintln(stderr,b);
		}
	mult(d,b,c);
	if (dt) {
		fprintf(stderr,"mult_schubert_schubert: result= ");
		fprintln(stderr,c);
		}
	freeall(d);
	return(OK);
}
#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE

INT mult_schubert_variable (a,i,r) OP a,i,r;
/* a ist schubert polynom
   i ist INTEGER, index der variable *
   r wird result */
/* AK 190690 V1.1 */ /* AK 090891 V1.3 */
{
	OP z,ss,c; 
	INT ii = S_I_I(i);  /* variablennumerierung beginnt mit 0 */
	INT j;
	INT grenzelinks,grenzerechts;
	if (a==r) {
		c = callocobject(); *c = *a; C_O_K(r,EMPTY); 
		ii = mult_schubert_variable(c,i,r);
		freeall(c); return ii;
		}

	if (not EMPTYP(r)) freeself(r);
	b_sn_l(NULL,NULL,r); C_O_K(r,SCHUBERT);
	z = a;
	while (z != NULL)
		{
		ss = S_SCH_S(z);
		if (S_P_II(ss,S_P_LI(ss)-1L) != S_P_LI(ss) ) {
			inc(S_P_S(ss)); 
			M_I_I(S_P_LI(ss), S_P_I(ss,S_P_LI(ss)-1L) );
			}
		while (ii+1L >= S_P_LI(ss))
			{
			inc(S_P_S(ss)); 
			M_I_I(S_P_LI(ss), S_P_I(ss,S_P_LI(ss)-1L) );
			}
		grenzelinks=0L;
		grenzerechts=S_P_LI(ss)+1L;
		for (j=ii-1L;j>=0L; j--)
			{
			if (
				(S_P_II(ss,j) < S_P_II(ss,ii) )
				&&
				(S_P_II(ss,j) > grenzelinks )
			   )
					{
					/* nach links tauschen */
					c = callocobject();
					b_skn_sch(callocobject(),callocobject(),
						  NULL,c);
					addinvers(S_SCH_K(z),S_SCH_K(c));
					copy(ss,S_SCH_S(c));
					m_i_i(s_p_ii(ss,j), s_sch_si(c,ii));
					m_i_i(s_p_ii(ss,ii), s_sch_si(c,j));
					insert(c,r,add_koeff,
						comp_monomvector_monomvector);
					grenzelinks = S_P_II(ss,j);
					}
			}
		for (j=ii+1L; j <S_P_LI(ss); j++)
			{
			if (
				(S_P_II(ss,j) > S_P_II(ss,ii) )
				&&
				(S_P_II(ss,j) < grenzerechts )
			   )
					{
					/* nach rechts tauschen */
					c = callocobject();
					b_skn_sch(callocobject(),callocobject(),
						  NULL,c);
					copy(S_SCH_K(z),S_SCH_K(c));
					copy_permutation(ss,S_SCH_S(c));
					M_I_I(S_P_II(ss,j), S_SCH_SI(c,ii));
					M_I_I(S_P_II(ss,ii), S_SCH_SI(c,j));
					insert(c,r,add_koeff,
						comp_monomvector_monomvector);
					grenzerechts = S_P_II(ss,j);
					}
			}
			
		z = S_SCH_N(z);
		}
	return OK;
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT mult_schubert_monom(a,b,c) OP a,b,c;
/* a ist SCHUBERT b ist MONOM eines POLYNOMS c wird ergebnis */
/* AK 190690 V1.1 */ /* AK 090891 V1.3 */
{
	OP e=callocobject();
	INT i,j;
	copy(a,c);
	for (i=0L; i<S_MO_SLI(b); i++)
		for (j=0L; j<S_MO_SII(b,i); j++)
			{
			M_I_I(i,e);
			mult_schubert_variable(c,e,c);
			}
		
	mult_apply(S_MO_K(b),c);
	freeall(e);
	return OK;
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT mult_schubert_polynom(a,b,c) OP a,b,c;
/* a ist SCHUBERT b ist POLYNOM c wird SCHUBERT */
/* AK 190690 V1.1 */ /* AK 090891 V1.3 */
{
	OP d,z = b;
	if (not EMPTYP(c)) freeself(c);
	b_sn_l(NULL,NULL,c); C_O_K(c,SCHUBERT);
	while (z != NULL)
		 {
		 d = callocobject();
		 mult_schubert_monom(a,S_L_S(z),d);
		 insert(d,c,add_koeff,comp_monomvector_monomvector);
		 z = S_PO_N(z);
		 }
	return OK;
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT t_PERMUTATION_SCHUBERT(a,b) OP a,b;
/* AK 200891 V1.3 */
	{
	if (not EMPTYP(b)) 
		freeself(b);
	b_skn_sch(callocobject(),callocobject(),NULL,b);
	M_I_I(1L,S_SCH_K(b));
	copy_permutation(a,S_SCH_S(b));
	return OK;
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT add_apply_schubert_schubert(a,b) OP a,b;
/* AK 200891 V1.3 */
	{
	OP c = callocobject();
	copy_list(a,c);
	return(insert(c,b,add_koeff,comp_monomvector_monomvector));
	}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT add_apply_schubert(a,b) OP a,b;
/* AK 220390 V1.1 */ /* AK 210291 V1.2 */ /* AK 090891 V1.3 */
{
	if (EMPTYP(b)) return(copy_polynom(a,b));
	switch(S_O_K(b)) {
		case SCHUBERT: 
			return add_apply_schubert_schubert(a,b);
		default:
			{ 
			/* 210291 */
			OP c = callocobject();
			INT erg;
			*c = *b;
			C_O_K(b,EMPTY);
			erg = add(a,c,b);
			erg += freeall(c);
			return erg;
			}
		}
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE

INT addinvers_schubert(von,nach) OP von, nach;
/* AK 110789 V1.0 */ /* AK 201289 v1.1 */ /* AK 090891 V1.3 */
{
	return addinvers_polynom(von,nach); 
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT println_schub_lehmer(a) OP a;
/* AK 070691 V1.2 */ /* AK 200891 V1.3 */
{
	OP z,b;
	z=a;
	b = callocobject();
	while (z != NULL)
		{
		print(S_SCH_K(z));
		lehmercode(S_SCH_S(z),b); 
		print(b);
		if (S_SCH_N(z) != NULL)
			if (not negp(S_SCH_K(S_SCH_N(z))))
				printf("+");
		z = S_SCH_N(z);
		}
	freeall(b);
	printf("\n");
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT m_i_schubert(a,b) INT a; OP b;
/* changes a INT into a SCHUBERTpolynomial with this INT as 
koeffizent and labeled by the identity perm */
/* AK 181290 V1.1 */ /* AK 090891 V1.3 */
{
	if (not EMPTYP(b)) freeself (b);
	b_skn_sch(callocobject(),callocobject(),NULL,b);
	M_I_I(a,S_SCH_K(b));
	b_ks_p(VECTOR,callocobject(),S_SCH_S(b));
	m_il_v(2L,S_P_S(S_SCH_S(b)));
	M_I_I(1L,S_P_I(S_SCH_S(b),0L));
	M_I_I(2L,S_P_I(S_SCH_S(b),1L));
	return OK;
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
INT invers_polynom(a,b) OP a,b;
/* AK 281290 V1.1 */ /* AK 090891 V1.3 */
{
	INT i,j,erg;
	OP c = callocobject();
	if (not EMPTYP(b)) freeself(b);
	m_i_schubert(1L,b);
	for (i=0L; i< S_P_LI(a); i++)
		for (j=i+1; j< S_P_LI(a); j++)
			{
			if ( S_P_II(a,j) < S_P_II(a,i) ) 
				{
				co_L9(i,j,c);
				mult(c,b,b);
				freeself(c);
				}
			}

	freeall(c);
	return OK;
}

#endif /* SCHUBERTTRUE */

#ifdef SCHUBERTTRUE
static INT co_L9(i,j,c) INT i,j; OP c;
/* computes x_i - x_j */
/* AK 200891 V1.3 */
{
	OP d = callocobject();
	if (not EMPTYP(c)) freeself(c);
	m_iindex_monom(i,c);
	m_iindex_monom(j,d);addinvers_apply(d);
	add_apply(d,c);
	freeall(d);
}

#endif /* SCHUBERTTRUE */

