#include "def.h"
#include "macro.h"
static struct tableaux * calloctableaux();
static INT inhaltcoroutine();

/* jeu_de.c AK 010889 V1.0 */


#ifdef TABLEAUXTRUE
INT inverse_nilplactic_jeudetaquin_tableaux(a,si,sj,b) OP a,b;INT si,sj;
/* AK 120790 V1.1 */ /* AK 200691 V1.2 */ /* AK 200891 V1.3 */
	{
	OP self,umriss;
	INT posi,posj; /* aktuelle position des jokers */
	OP unten, links;
	if (not EMPTYP(b) ) freeself(b);
	if (sj != zeilenende(a,si)+1L)
		return error("INV_NILJDT: illegel index");
	if (S_O_K(S_T_U(a)) == PARTITION)
		if (si > S_T_ULI(a))
			return error("INV_NILJDT: illegel index");
	if (S_O_K(S_T_U(a)) == SKEWPARTITION)
		if (si > S_T_UGLI(a))
			return error("INV_NILJDT: illegel index");
	self = callocobject();
	copy(S_T_S(a),self);
	if (sj == S_M_LI(self)) inc(self);
	if (si == S_M_HI(self)) inc(self);
	posi = si; posj = sj;
m120790again:
	unten = NULL; links = NULL;
	if (posj > 0L) {
		links = S_M_IJ(self, posi, posj-1L);
		if (EMPTYP(links)) links = NULL;}
	if (posi > 0L) {
		unten = S_M_IJ(self, posi-1L, posj);
		if (EMPTYP(unten)) unten = NULL;}

	if ((links == NULL) && (unten == NULL))
		{
		/* Abbruchbedingung */
		C_O_K(S_M_IJ(self,posi,posj),EMPTY);
		umriss = callocobject(); m_matrix_umriss(self,umriss);
		return b_us_t(umriss,self,b); 
		}

	if (links == NULL) 
		{ M_I_I(S_I_I(unten), S_M_IJ(self,posi,posj));
		posi--; goto m120790again; }
	if (unten == NULL) 
		{ M_I_I(S_I_I(links), S_M_IJ(self,posi,posj));
		posj--; goto m120790again; }
	if (S_I_I(unten) == S_I_I(links))
		{
		if ( not emptyp(S_M_IJ(self,posi-1L,posj-1L)))
		if ( S_M_IJI(self,posi-1L,posj-1L) == S_I_I(links)-1L )
			{
			/* jetzt anwenden der nilplactic relationen */
			INT i;
			M_I_I(S_M_IJI(self,posi,posj-1L),
			      S_M_IJ(self,posi,posj));
			for (i=1L; i <= posi ; i++)
				{
				if (
					(S_M_IJI(self,posi-i,posj-1L) 
					!= S_I_I(links)-i)  ||
					(S_M_IJI(self,posi-i,posj) 
					!= S_I_I(links)-i+1L)  
				   ) break;
				M_I_I(S_M_IJI(self,posi-i,posj-1L),
				      S_M_IJ(self,posi-i,posj));
				}
			posj--;
			goto m120790again;
			}
		}
	if (S_I_I(unten) >= S_I_I(links))
		{ M_I_I(S_I_I(unten), S_M_IJ(self,posi,posj));
		posi--; goto m120790again; }
	else
		{ M_I_I(S_I_I(links), S_M_IJ(self,posi,posj));
		posj--; goto m120790again; }
	
	}
#endif /* TABLEAUXTRUE */


#ifdef TABLEAUXTRUE
INT inverse_jeudetaquin_tableaux(a,si,sj,b) OP a,b;INT si,sj;
/* AK 100790 V1.1 */ /* AK 200891 V1.3 */
	{
	OP self,umriss;
	INT posi,posj; /* aktuelle position des jokers */
	OP unten, links;
	if (not EMPTYP(b) ) freeself(b);
	if (sj != zeilenende(a,si)+1L)
		return error("inverse_jeudetaquin_tableaux: illegel index");
	self = callocobject();
	copy(S_T_S(a),self);
	if (sj == S_M_LI(self)) inc(self);
	if (si == S_M_HI(self)) inc(self);
	posi = si; posj = sj;
m100790again:
	unten = NULL; links = NULL;
	if (posj > 0L) {
		links = S_M_IJ(self, posi, posj-1L);
		if (EMPTYP(links)) links = NULL;}
	if (posi > 0L) {
		unten = S_M_IJ(self, posi-1L, posj);
		if (EMPTYP(unten)) unten = NULL;}

	if ((links == NULL) && (unten == NULL))
		{
		/* Abbruchbedingung */
		C_O_K(S_M_IJ(self,posi,posj),EMPTY);
		umriss = callocobject(); m_matrix_umriss(self,umriss);
		b_us_t(umriss,self,b); return(OK);
		}
	if (links == NULL) 
		{ M_I_I(S_I_I(unten), S_M_IJ(self,posi,posj));
		posi--; goto m100790again; }
	if (unten == NULL) 
		{ M_I_I(S_I_I(links), S_M_IJ(self,posi,posj));
		posj--; goto m100790again; }
	if (S_I_I(unten) >= S_I_I(links))
		{ M_I_I(S_I_I(unten), S_M_IJ(self,posi,posj));
		posi--; goto m100790again; }
	else
		{ M_I_I(S_I_I(links), S_M_IJ(self,posi,posj));
		posj--; goto m100790again; }
	
	}
#endif /* TABLEAUXTRUE */

INT jeudetaquin_tableaux(a,b) OP a,b;
/* AK 080688 */
/* Jeu de Taquin auf a wird b . a ist schieftableau und wird ein tableau b */
/* AK 010889 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OP self; OP umriss; OP unten,rechts;
	INT i,j; 
	INT posi,posj;  /* aktuelle position des jokers */
	INT nexti,nextj;  /* naechste position des jokers */
	INT si,sj; /* start of joker */

	if (S_O_K(S_T_U(a)) == PARTITION) return copy(a,b);

	self = callocobject(); 
	copy (S_T_S(a),self);
m0806883: /* ein neues spiel */
	i = 0L;
	for (j=0L;j<S_M_LI(self);j++)
		if (not EMPTYP(S_M_IJ(self,i,j)))
			{
			if (j == 0L) goto m080688stop1; /* ende */
					/* man hat ein tableaux */


			/* spalte mit eintrag */
			j = j - 1L; 
			for (i=0L;i<S_M_HI(self);i++)
				if (not EMPTYP(S_M_IJ(self,i,j)))
					{ si=i-1L;sj=j;goto m0806881;}
			};
m0806881:	/* si,sj die position des jokers */
	posi = si; posj = sj;
m0806882: 	/* next step */
		/* nach richtung kleineres element, bei gleich nach unten */
	unten = NULL; rechts = NULL;
	if (posi+1 < S_M_HI(self)) /* joker nicht in unterste zeile */
		{
		unten = S_M_IJ(self,posi+1L,posj);
		if (EMPTYP(unten)) unten = NULL;
		};
	if (posj+1 < S_M_LI(self)) /* joker nicht in letzter spalte */
		{
		rechts = S_M_IJ(self,posi,posj+1L);
		if (EMPTYP(rechts)) rechts = NULL;
		};
	if ( (unten == NULL) && (rechts == NULL) ) 
		/* ende ein neues spiel */ goto m0806883;
	if ( (unten == NULL))  /* nach rechts */
		{ nexti = posi; nextj=posj+1L; }
	else if ( (rechts == NULL))  /* nach unten */
		{ nexti = posi+1L; nextj=posj; }
	else /* in beide richtungen ist noch ein eintrag */
		{
		if (lt(rechts,unten))
			{ nexti = posi; nextj=posj+1L; }
		else	{ nexti = posi+1L; nextj=posj; };
		};

	copy(S_M_IJ(self,nexti,nextj),S_M_IJ(self,posi,posj));
	freeself(S_M_IJ(self,nexti,nextj));
	posi=nexti; posj=nextj;
	goto m0806882; /* noch eine runde */
m080688stop1: /* wir sind fertig,aus der matrix wird ein tableau */
	umriss = callocobject(); m_matrix_umriss(self,umriss);
	b_us_t(umriss,self,b); return(OK);
#else
	error("jeudetaquin_tableaux:TABLEAUX not supported");
	return(ERROR);
#endif
	}


INT m_u_t(umriss,ergebnis) OP umriss,ergebnis;
/* AK 020488 aufbau eines tableaus ohne inhalt */
/* AK 281289 V1.1 */ /* AK 240791 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OP l= callocobject(); 
	OP h= callocobject(); 
	INT erg = OK;

	erg += length(umriss,h);
		/* bsp umriss = 1234 ==> height = 4
		umriss = 23456789/3456 ==> height = 8 */

	erg += lastof(umriss,l);

	erg += b_us_t(callocobject(),callocobject(),ergebnis);
	erg += copy(umriss,S_T_U(ergebnis));
	erg += b_lh_m(l,h,S_T_S(ergebnis)); 
	return erg;
#else
	error("m_u_t:TABLEAUX is not available");
#endif
	}

INT freeself_tableaux(a) OP a;
/* AK 260789 */ /* AK 281289 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OBJECTSELF c;
	freeall(S_T_S(a)); freeall(S_T_U(a));
	c = S_O_S(a); free(c.ob_tableaux); return(OK);
#else
	return error("freeself_tableaux:TABLEAUX is not available");
#endif
	}

INT copy_tableaux(a,b) OP a,b;
/* AK 260789 */ /* AK 230790 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	b_us_t(callocobject(),callocobject(),b);
	copy_matrix(S_T_S(a),S_T_S(b));
	return copy(S_T_U(a),S_T_U(b));
#else
	return error("copy_tableaux:TABLEAUX is not available");
#endif
	}
	

#ifdef TABLEAUXTRUE
static struct tableaux * calloctableaux()
/* 020488 AK erste prozedur beim einfuehren eines neuen datentyps */
/* AK 010889 V1.1 */ /* AK 200891 V1.3 */
	{
	struct  tableaux *erg
	= (struct tableaux *) calloc((int)1,sizeof(struct tableaux));
	if (erg == NULL) error("calloctableaux:no memory");
	return(erg);
	}
#endif /* TABLEAUXTRUE */

INT m_us_t(umriss,self,ergebnis) OP umriss,self,ergebnis;
/* AK 230790 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OP u = callocobject(),s = callocobject();
	copy(umriss,u); 
	copy(self,s); 
	return b_us_t(u,s,ergebnis);
#endif /* TABLEAUXTRUE */
	}

INT b_us_t(umriss,self,ergebnis) OP umriss,self,ergebnis;
/* die zweite prozedur bei neuen typen */
/* AK 010889 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OBJECTSELF d;

	if (ergebnis==NULL) return error("b_us_t:ergebnis == NULL");

	d.ob_tableaux = calloctableaux();
	b_ks_o(TABLEAUX, d, ergebnis);

	c_t_u(ergebnis,umriss); /*change_tableaux_umriss*/
	c_t_s(ergebnis,self); /*change_tableaux_self*/
	return(OK);
#else
	return error("b_us_t:TABLEAUX not available");
#endif
	}

INT objectread_tableaux(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef TABLEAUXTRUE
	b_us_t(callocobject(),callocobject(),a);
	objectread(f,S_T_U(a));
	return objectread(f,S_T_S(a));
#endif /* TABLEAUXTRUE */
}

INT objectwrite_tableaux(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef TABLEAUXTRUE
	fprintf(f,"%ld ",(INT)S_O_K(a));
	objectwrite(f,S_T_U(a));
	return objectwrite(f,S_T_S(a));
#endif /* TABLEAUXTRUE */
}


#ifdef TABLEAUXTRUE
INT m_matrix_tableaux(mat,tab) OP mat,tab;
/* AK 010988 */ /* AK 010889 V1.1 */ /* AK 200891 V1.3 */
	{
	OP u = callocobject(); 
	m_matrix_umriss(mat,u); 
	return b_us_t(u,mat,tab);
	}
#endif  /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
INT m_matrix_umriss(mat,umr) OP mat,umr;
/* AK 080688 */
/* aus einer matrix, welche tableaux ist , wird der umriss berechnet */
/* AK 010989 V1.0 */ /* AK 110790 V1.1 */ /* AK 200891 V1.3 */
	{
	INT i,j,schalter;


	if (S_O_K(mat) != MATRIX) {
		printobjectkind(mat);
		error("m_matrix_umriss:no MATRIX");return(ERROR);}

	if (not (EMPTYP(umr)) ) freeself(umr);
	/* zuerst die laenge der partition */
	for (i=0L;i<S_M_HI(mat);i++) if (EMPTYP(S_M_IJ(mat,i,0L))) break;

	if (i==0L) {
		/* SKEWPARTITION */
		/* AK 110790 V1.1 */
		OP a = callocobject(), b = callocobject();
		m_il_v(S_M_HI(mat),a); m_il_v(S_M_HI(mat),b);
		for (i=0L;i<S_M_HI(mat); i++)
		{
		schalter = 0L;
		for (j=0L;j<S_M_LI(mat); j++)
			{
			if (schalter == 0L) {
				/* noch im linken leeren teil */
				if (not EMPTYP(S_M_IJ(mat,i,j))) {
					M_I_I(j,S_V_I(b,i));
					schalter=1L;
					}
				else if (j == S_M_LI(mat)-1L) {
					/* d.h. am ende */
					M_I_I(S_M_LI(mat),S_V_I(a,i));
					M_I_I(S_M_LI(mat),S_V_I(b,i));
					}
				}
			if (schalter == 1L) {
				/* im teil mit eintraegen */
				if (EMPTYP(S_M_IJ(mat,i,j))) {
					M_I_I(j,S_V_I(a,i));
					schalter=2L;
					}
				else
				if (j == S_M_LI(mat)-1L) {
					/* d.h. am ende */
					M_I_I(S_M_LI(mat),S_V_I(a,i));}
				}
			else
			if (schalter == 2L) {
				if (not EMPTYP(S_M_IJ(mat,i,j))) {
					freeall(a); freeall(b);
					debugprint(mat);
					return
					 error("m_matrix_umriss:no MATRIX");
					}
				}
			}
		}
		for (i=S_M_HI(mat)-1L; i>=0L; i--)
			{
			if (S_V_II(b,i) == S_M_LI(mat)) 
				{
				M_I_I(0L,S_V_I(b,i));
				M_I_I(0L,S_V_I(a,i));
				}
			else    break;
			}
		/* nun sind die nullen am ende */
		/* das umdrehen */ 
		b_gk_spa(callocobject(),callocobject(),umr);
		m_v_pa(a,S_SPA_G(umr)); m_v_pa(b,S_SPA_K(umr));
		freeall(a);freeall(b); return OK;
		}

	b_ks_pa(VECTOR,callocobject(),umr); m_il_v(i,S_PA_S(umr));
	/* die laenge wurde berechnet */

	for (i=0L;i<S_PA_LI(umr);i++)
		{
		for (j=0L;j<S_M_LI(mat);j++) if (EMPTYP(S_M_IJ(mat,i,j))) break;
		if (j==0L) error("0 in m_matrix_umriss");
		M_I_I(j,S_PA_I(umr,S_PA_LI(umr)-1-i));
		};
	return(OK);
	}
#endif  /* TABLEAUXTRUE */


#ifdef TABLEAUXTRUE
INT tex_tableaux(a) OP a;
/* AK 060588 */ /* AK 230790 V1.1 */
/* AK 070291 V1.2 prints to texout */ /* AK 200891 V1.3 */
	{
	INT i,j,s;
	fprintf(texout,"\\hbox \{ \\vbox \{\n");
	for (i=0L; i< S_PA_LI(S_T_U(a)); i++)
			{
			fprintf(texout,"\\hrule width %dpt\n",
				S_PA_II(S_T_U(a),i)*13-1L);
			fprintf(texout,"\\vskip 0pt\n\\hbox \{\n");
			for (j=0L; j< S_PA_II(S_T_U(a),i); j++)
				{
				fprintf(texout,
					"\\kern-3.5pt\n\\hbox to 13pt\{");
				fprintf(texout,"\\vrule height10pt depth3pt$");
/* s_t_iji statt S_T_IJI */
			if (s_t_iji(a,S_PA_LI(S_T_U(a))-1-i,j) < 10L)
				fprintf(texout,"\\ %d",
/* s_t_iji statt S_T_IJI */
					s_t_iji(a,S_PA_LI(S_T_U(a))-1-i,j));
/* s_t_iji statt S_T_IJI */
			else if (s_t_iji(a,S_PA_LI(S_T_U(a))-1-i,j) < 100L)
				fprintf(texout,"%d",
/* s_t_iji statt S_T_IJI */
					s_t_iji(a,S_PA_LI(S_T_U(a))-1-i,j));
			else return
			error("tex_tableaux:entry too big in tableaux");
					
				fprintf(texout,
					"$ \\vrule height10pt depth3pt}\n");
				}
			fprintf(texout,"}\n\\vskip 0pt\n");
			if (i== S_PA_LI(S_T_U(a)) -1L)
			fprintf(texout,
			"\\hrule width %dpt\n",S_PA_II(S_T_U(a),i)*13-1L);
			}

	fprintf(texout,"} } ");
	return(OK);
	}
#endif  /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
INT comp_tableaux(a,b)	OP a,b;
/* AK 060588 */ /* AK 281289 V1.1 */ /* AK 200891 V1.3 */
	{
/*
	OP c= callocobject(); 
	OP d = callocobject(); 
	INT erg;

	wordoftableaux(a,c);
	wordoftableaux(b,d);
	erg = COMP_WORD(c,d);
	freeall(c); freeall(d); 
	return(erg);
*/
	return(comp_matrix(S_T_S(a),S_T_S(b)));
	}
#endif  /* TABLEAUXTRUE */

INT inc_tableaux(tab) OP tab;
/* AK 250488 */ /* AK 291289 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OP l=callocobject();
	OP h=callocobject();
	OP b=callocobject(); /* die neue matrix */

	OP a = S_T_S(tab);

	INT i,j;

	copy(S_M_H(a),h);inc(h);
	copy(S_M_L(a),l);inc(l);

	b_lh_m(l,h,b);

	for (i=0L;i<S_M_HI(a);i++)
		for (j=0L;j<S_M_LI(a);j++)
			{
			C_O_S(S_M_IJ(b,i+1L,j),S_O_S(S_M_IJ(a,i,j)));
			C_O_K(S_M_IJ(b,i+1L,j),S_O_K(S_M_IJ(a,i,j)));
			}
	freeall(S_M_H(a)); freeall(S_M_L(a));
	*a = *b;
	return(OK);
#endif
	}




INT weight_tableaux(a,b) OP a,b;
/* AK 170790 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	return weight(S_T_U(a),b);
#endif
	}

INT fprint_tableaux(fp,a) FILE *fp; OP a;
/* AK 020488 */ /* AK 281289 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	INT i,j,schalter;
	for (i=S_T_HI(a)-1L;i >= 0L; i--)
			{
			if (S_O_K(S_T_U(a)) == PARTITION) 
				if (i >= S_T_ULI(a)) continue;
			if (S_O_K(S_T_U(a)) == SKEWPARTITION) 
				if (i >= S_T_UGLI(a)) continue;

			fprintf(fp,"\n");
			if (fp == stdout) zeilenposition = 0L;
			schalter=1L;
			for (j=0L; j<S_T_LI(a); j++)
				if (EMPTYP(S_T_IJ(a,i,j))) 
					{
				if (schalter==2L)fprintf(fp,"  ");
				else if (schalter==1L)fprintf(fp,"# ");
					}
				else {
					schalter=2L;
					fprint(fp,S_T_IJ(a,i,j));
					fprintf(fp," ");
					}
			};
	fprintf(fp,"\n");
	return OK;
#else
	return error("fprint_tableaux:TABLEAUX is not available");
#endif
	}

#ifdef TABLEAUXTRUE
OP s_t_s(a) OP a; 
/* AK 200891 V1.3 */
	{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	return(c.ob_tableaux->t_self); 
	}

OP s_t_u(a) OP a; 
/* AK 200891 V1.3 */
	{
	OBJECTSELF c;
	c=s_o_s(a); 
	return(c.ob_tableaux->t_umriss); 
	}

OP s_t_ug(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_spa_g(s_t_u(a))); }

OP s_t_l(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_m_l(s_t_s(a))); }

INT s_t_li(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_m_li(s_t_s(a))); }

INT s_t_hi(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_m_hi(s_t_s(a))); }

INT s_t_iji(a,i,j) OP a;INT i,j; 
/* AK 200891 V1.3 */
	{ return(s_i_i(s_t_ij(a,i,j))); }

OP s_t_ij(a,i,j) OP a;INT i,j; 
/* AK 200891 V1.3 */
	{ return(s_m_ij(s_t_s(a),i,j)); }

OP s_t_h(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_m_h(s_t_s(a))); }

INT c_t_s(a,b) OP a,b; 
/* AK 200891 V1.3 */
	{ OBJECTSELF c; c = s_o_s(a); c.ob_tableaux->t_self = b;
	return(OK); }

INT c_t_u(a,b) OP a,b;
/* AK 200891 V1.3 */
	{ OBJECTSELF c; c = s_o_s(a); c.ob_tableaux->t_umriss = b; return(OK); }

OP s_t_uk(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_spa_k(s_t_u(a))); }

OP s_t_us(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_pa_s(s_t_u(a))); }

OP s_t_ui(a,i) OP a;INT i; 
/* AK 200891 V1.3 */
	{ return(s_pa_i(s_t_u(a),i)); }

INT s_t_uii(a,i) OP a;INT i; 
/* AK 200891 V1.3 */
	{ return(s_pa_ii(s_t_u(a),i)); }

INT s_t_ukii(a,i) OP a;INT i; 
/* AK 200891 V1.3 */
	{ return(s_spa_kii(s_t_u(a),i)); }

INT s_t_ukli(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_spa_kli(s_t_u(a))); }

INT s_t_ugii(a,i) OP a;INT i; 
/* AK 200891 V1.3 */
	{ return(s_spa_gii(s_t_u(a),i)); }

INT s_t_ugli(a) OP a; 
/* AK 200891 V1.3 */
	{ return(s_spa_gli(s_t_u(a))); }
#endif

INT inhalt_tableaux(a,inhalt) OP a,inhalt;
/* 250488 berechnet inhalt i von tableaux a */
/* AK 230790 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	INT i,j;
	INT zahl;

	m_il_v(1L,inhalt);
	M_I_I(0L,S_V_I(inhalt,0L));

	if (S_O_K(S_T_U(a)) == PARTITION)
		{
		for (i=S_T_HI(a)-1L;i>=0L;i--)
			for (j=S_PA_II(S_T_U(a),i)-1L;j>=0L;j--)
				inhaltcoroutine(S_T_IJI(a,i,j),inhalt);
		}
	else if (S_O_K(S_T_U(a)) == SKEWPARTITION)
		{
		INT l;

		for (	i=S_T_HI(a)-1L,
			l=S_PA_LI(s_t_uk(a))-1L;
			l>=0L;
			i--,l--)

			for (	j=S_T_UGII(a,i)-1L;
			    	j>=S_T_UKII(a,l);
				j--)

				inhaltcoroutine(S_T_IJI(a,i,j),inhalt);
		
		for (;i>=0L;i--)
			for (j=S_T_UGII(a,i)-1L;j>=0L;j--)
				inhaltcoroutine(S_T_IJI(a,i,j),inhalt);

		};
#else
	return error("inhalt_tableaux:TABLEAUX not available");
#endif
	}


#ifdef TABLEAUXTRUE
static INT inhaltcoroutine(zahl,inhalt) INT zahl; OP inhalt;
/* AK 230790 V1.1 */ /* AK 200891 V1.3 */
	{
	if (zahl <= S_V_LI(inhalt)) 
		inc(S_V_I(inhalt,zahl-1L));
	else {
		OP b=callocobject(); 
		INT k,m=S_V_LI(inhalt); 
		m_il_v(zahl,b);
		for (k=0L;k<m;k++)
			M_I_I(S_V_II(inhalt,k),S_V_I(b,k));
		for (k=m;k<zahl;k++)
			M_I_I(0L,S_V_I(b,k));
		M_I_I(1L,S_V_I(b,zahl-1L));
		freeself(inhalt);
		*inhalt =  *b;
		};
	return(OK);
	}
#endif /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
INT scan_tableaux(a) OP a;
/* 020488 AK */ /* AK 010889 V1.1 */ /* AK 200691 V1.2 */ /* AK 200891 V1.3 */
	{
	INT i,j;
	char c[100];
	OP umriss = callocobject();

	printeingabe("(S)kewpartition or (P)artition for shape");
	scanf("%s",&c[0]);

	if (c[0] == 'P')
	{
	printeingabe("enter a tableau, shape is partition\n");
	scan(PARTITION,umriss);

	m_u_t(umriss,a);
	printeingabe("enter the tableau\n");
	for (i=0L; i<S_T_HI(a); i++)
		{ 
		sprintf(c,"row nr %d \n",(i+1L)); /* AK 020792 */
		printeingabe(c); /* AK 020792 */
		for (j=0L;j<S_PA_II(S_T_U(a),S_T_HI(a)-1-i);j++)
			scan(INTEGER,S_T_IJ(a,i,j)); 
		};
	}
	else if (c[0] == 'S')
	{
	INT k,m;
	printeingabe("enter a tableau, shape is skewpartition\n");
	scan(SKEWPARTITION,umriss);
	m_u_t(umriss,a);
	printeingabe("enter the tableau\n");
	m = S_T_UKLI(a); /* ab diesen index ist nur noch
					die groessere Partition */
	for (i=0L; i<S_T_HI(a); i++)
		{ 
/* s_t_ukii statt S_T_UKII */
		if (i<m) k=s_t_ukii(a,S_T_UKLI(a)-1-i);
		else k=0L;
				/* in spalte k wird eingetragen */
		sprintf(c,"row nr %d \n",(i+1L)); /* AK 020792 */
		printeingabe(c); /* AK 020792 */
		for (j=k;j<S_PA_II(s_t_ug(a),S_T_UGLI(a)-1-i);j++)
			scan(INTEGER,S_T_IJ(a,i,j)); 
		};
	}
	else /* AK 020792 */
		{
		freeall(umriss);
		return ERROR;
		}
	return(OK);
	}
#endif /* TABLEAUXTRUE */


#ifdef TABLEAUXTRUE
INT wordoftableaux(a,b) OP a,b;
/* AK 200891 V1.3 */
	{ return(rowwordoftableaux(a,b));}	
#endif /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
INT rowwordoftableaux(a,b) OP a,b;
/* berechnet das zu einem Tableaux gehoerende word */
/* MD p.70 */
/* AK 281289 V1.1 */ /* AK 200891 V1.3 */
	{
	OP l = callocobject();
	INT i,j,k;
	INT index=0L; /* der index im word */

	weight_tableaux(a,l);
	/* die laenge des wortes ist das gewicht des tableaus */

	m_il_w(S_I_I(l),b);

	for (i=0L;i<S_T_HI(a);i++)
		{
		k = zeilenanfang(a,i);
		for(j=zeilenende(a,i);j>=k;j--)
			{ M_I_I(S_T_IJI(a,i,j),S_W_I(b,index));index++; }
			
		}
	freeall(l); return OK;
	}

#endif  /* TABLEAUXTRUE */

INT columnwordoftableaux(a,b) OP a,b;
/* berechnet das zu einem Tableaux gehoerende word */
/* AK 020290 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OP l = callocobject();
	INT i,j,k;
	INT index=0L; /* der index im word */

	weight_tableaux(a,l);
	/* die laenge des wortes ist das gewicht des tableaus */

	m_il_w(S_I_I(l),b);

	for (j=0L;j<S_T_LI(a);j++)
		{
		k = spaltenanfang(a,j);
		for(i=spaltenende(a,j);i>=k;i--)
			{ M_I_I(S_T_IJI(a,i,j),S_W_I(b,index));index++; }
			
		}
	freeall(l); return(OK);
#endif 
	}

#ifdef TABLEAUXTRUE
INT spaltenanfang(a,b) OP a; INT b;
/* AK 020290 V1.1 */ /* AK 180691 V1.2 */ /* Ak 200891 V1.3 */
{
	OP z = S_T_U(a);
	INT j;
	if (b <0L) 
		return error("spaltenanfang:index < 0");
	if (S_O_K(z) == PARTITION) 
		{
		if (b >= S_PA_II(z,S_PA_LI(z)-1L)) return(S_T_HI(a));
		else return(0L);
		}
	else if (S_O_K(z) == SKEWPARTITION)
		{
/* s_t_ugii statt S_T_UGII */
		if (b >= s_t_ugii(a,S_T_UGLI(a)-1L)) return(S_T_HI(a));
/* s_t_ukii statt S_T_UKII */
		else if (b>=s_t_ukii(a,S_T_UKLI(a)-1L)) return(0L);
		else 
			{
			for (j=S_T_UKLI(a)-1L;j>=0L;j--) 
				if (S_T_UKII(a,j) <=  b) break;
			return(S_T_UKLI(a) - 1L - j);
			}
		}
	else error("spaltenanfang: wrong shape");
}

INT spaltenende(a,b) OP a; INT b;
/* AK 020290 V1.1 */ /* AK 180691 V1.2 */ /* Ak 200891 V1.3 */
{
	OP z = S_T_U(a);
	INT j;
	if (b <0L) 
		return error("spaltenende:index < 0");
	if (S_O_K(z) == PARTITION) 
		{
		if (b >= S_PA_II(z,S_PA_LI(z)-1L)) return(-1L);
		else {
			for (j=S_PA_LI(z)-1L;j>=0L;j--) 
				if (S_PA_II(z,j) <=  b) break;
			return(S_PA_LI(z) - 2L - j);
		     }
		}
	else if (S_O_K(z) == SKEWPARTITION)
		{
/* s_t_ugii statt S_T_UGII */
		if (b >= s_t_ugii(a,S_T_UGLI(a)-1L)) return(-1L);
		else {
			for (j=S_T_UGLI(a)-1L;j>=0L;j--) 
				if (S_T_UGII(a,j) <=  b) break;
			return(S_T_UGLI(a) - 2L - j);
		     }
		}
	else return error("spaltenende: wrong shape");
}

INT zeilenanfang(tab,zn) OP tab; INT zn;
/* AK 090688 */
/* gibt index ersten eintrag in zeile zn */
/* falls zn keine besetzte zeile ist, dann ist das ergebnis die breite der
matrix */
/* AK 281289 V1.1 */ /* AK 180691 V1.2 */ /* Ak 200891 V1.3 */
	{
	if (zn <0L) 
		return error("zeilenanfang:index < 0");
	if (S_O_K(S_T_U(tab)) == PARTITION) { /* ein tableau */
		if (zn < S_PA_LI(S_T_U(tab)) ) return(0L);
		else return(S_T_LI(tab));
		}
	else if (S_O_K(S_T_U(tab)) == SKEWPARTITION) /* ein schieftableau */
		{
		if (zn >=  S_T_UGLI(tab)) return(S_T_LI(tab));
		else if (zn >=  S_T_UKLI(tab)) return(0L);
/* s_t_ukii statt S_T_UKII */
		else return( s_t_ukii(tab,S_T_UKLI(tab)-zn-1L));
		}
	else {
		debugprint(tab);
		return error("zeilenanfang: wrong umriss");}
	}

INT zeilenende(tab,zn) OP tab; INT zn; 
/* letzter erlaubter index */
/* AK 281289 V1.1 */ /* AK 180691 V1.2 */ /* Ak 200891 V1.3 */
	{
	OP u = S_T_U(tab);
	if (zn <0L) 
		return error("zeilenende:index < 0");
	if (S_O_K(u) == PARTITION) 
		{
		if (zn >= S_PA_LI(u)) return(-1L);
		else return(S_PA_II(u,S_PA_LI(u)-1L-zn) -1L);
		}
	else if (S_O_K(u) == SKEWPARTITION)
		{
		if (zn >=   S_T_UGLI(tab)) return(-1L);
/* s_pa_ii statt S_PA_II */
		else return(s_pa_ii(s_t_ug(tab),S_T_UGLI(tab)-zn-1L)-1L);
		}
	else {
		debugprint(tab);
		return error("zeilenende: wrong umriss");}
	}

#endif /* TABLEAUXTRUE */

INT skewplane_plane(a,b) OP a,b;
/* AK 010889 */
/* Jeu de Taquin auf a wird b . a ist schiefplanepartition
 und wird eine planepartition b */
/* AK 010889 V1.1 */ /* Ak 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OP self = callocobject(); 
	OP umriss;
	OP unten,rechts;
	INT i,j; 
	INT posi,posj;  /* aktuelle position des jokers */
	INT nexti,nextj;  /* naechste position des jokers */
	INT si,sj; /* start of joker */

	copy (S_T_S(a),self);
m0108893: /* ein neues spiel */
	i = 0L;
	for (j=0L;j<S_M_LI(self);j++)
		if (not EMPTYP(S_M_IJ(self,i,j)))
			{
			if (j == 0L) goto m010889stop1; /* ende */
					/* man hat ein tableaux */


			/* spalte mit eintrag */
			j = j - 1L; 
			for (i=0L;i<S_M_HI(self);i++)
				if (not EMPTYP(S_M_IJ(self,i,j)))
					{ si=i-1L;sj=j;goto m0108891;}
			};
m0108891:	/* si,sj die position des jokers */
	posi = si; posj = sj;
m0108892: 	/* next step */
		/* nach richtung kleineres element, bei gleich nach unten */
	unten = NULL; rechts = NULL;
	if (posi+1 < S_M_HI(self)) /* joker nicht in unterste zeile */
		{
		unten = S_M_IJ(self,posi+1L,posj);
		if (EMPTYP(unten)) unten = NULL;
		};
	if (posj+1 < S_M_LI(self)) /* joker nicht in letzter spalte */
		{
		rechts = S_M_IJ(self,posi,posj+1L);
		if (EMPTYP(rechts)) rechts = NULL;
		};
	if ( (unten == NULL) && (rechts == NULL) ) 
		/* ende ein neues spiel */ goto m0108893;
	if ( (unten == NULL))  /* nach rechts */
		{ nexti = posi; nextj=posj+1L; }
	else if ( (rechts == NULL))  /* nach unten */
		{ nexti = posi+1L; nextj=posj; }
	else /* in beide richtungen ist noch ein eintrag */
		{
		if (gt(rechts,unten))
			{ nexti = posi; nextj=posj+1L; }
		else	{ nexti = posi+1L; nextj=posj; };
		};

	copy(S_M_IJ(self,nexti,nextj),S_M_IJ(self,posi,posj));
	freeself(S_M_IJ(self,nexti,nextj));
	posi=nexti; posj=nextj;
	goto m0108892; /* noch eine runde */
m010889stop1: /* wir sind fertig,aus der matrix wird ein tableau */
	umriss = callocobject(); m_matrix_umriss(self,umriss);
	return b_us_t(umriss,self,b);
#else
	error("skewplane_plane:TABLEAUX not supported");
	return(ERROR);
#endif
	}




INT plane_tableau(a,b) OP a,b;
/* AK 010889 */
/* Jeu de Taquin auf a wird b . a ist planepartition
 und wird ein tableau b */
/* AK 010889 V1.1 */ /* AK 200891 V1.3 */
	{
#ifdef TABLEAUXTRUE
	OP self = callocobject(); 
	OP umriss;
	OP unten,rechts;
	INT i,j,startwert; 
	INT posi,posj;  /* aktuelle position des jokers */
	INT nexti,nextj;  /* naechste position des jokers */
	INT si,sj; /* start of joker */

	copy(a,b);
	copy (S_T_S(a),self);
n0108893: /* ein neues spiel */
n0108891:	/* si,sj die position des jokers */
	posi = 0L; posj = 0L;
	if (EMPTYP(S_M_IJ(self,posi,posj)))
		goto n010889stop1;
	startwert=S_M_IJI(self,posi,posj);
n0108892: 	/* next step */
		/* nach richtung kleineres element, bei gleich nach unten */
	unten = NULL; rechts = NULL;
	if (posi+1 < S_M_HI(self)) /* joker nicht in unterste zeile */
		{
		unten = S_M_IJ(self,posi+1L,posj);
		if (EMPTYP(unten)) unten = NULL;
		};
	if (posj+1 < S_M_LI(self)) /* joker nicht in letzter spalte */
		{
		rechts = S_M_IJ(self,posi,posj+1L);
		if (EMPTYP(rechts)) rechts = NULL;
		};
	if ( (unten == NULL) && (rechts == NULL) ) 
		/* ende ein neues spiel */ {
		freeself(S_M_IJ(self,posi,posj));
		M_I_I(startwert,S_T_IJ(b,posi,posj));
		goto n0108893; }
	if ( (unten == NULL))  /* nach rechts */
		{ nexti = posi; nextj=posj+1L; }
	else if ( (rechts == NULL))  /* nach unten */
		{ nexti = posi+1L; nextj=posj; }
	else /* in beide richtungen ist noch ein eintrag */
		{
		if (gt(rechts,unten))
			{ nexti = posi; nextj=posj+1L; }
		else	{ nexti = posi+1L; nextj=posj; };
		};

	copy(S_M_IJ(self,nexti,nextj),S_M_IJ(self,posi,posj));
	freeself(S_M_IJ(self,nexti,nextj));
	posi=nexti; posj=nextj;
	goto n0108892; /* noch eine runde */
n010889stop1: /* wir sind fertig */
	freeall(self);
	return(OK);
#else
	error("plane_tableau:TABLEAUX not supported");
	return(ERROR);
#endif
	}

INT co_170790(l,s) OP l,s;
/* l ist liste von tableaux mit partition shape */
/* s wird schur function */
/* AK 230790 V1.1 */ /* AK 200891 V1.3 */
{
	OP z = l;
	OP d = callocobject();
	m_i_i(0L,s);
	while (z != NULL)
		{
		m_pa_s(S_T_U(S_L_S(z)),d);
		add(d,s,s);
		z = S_L_N(z);
		}	
	return freeall(d);
}

#ifdef TABLEAUXTRUE
INT apply_INJDT(a,l,k,anz) OP a,l;INT k,anz;
/* a ist tableau, l ist liste, hier werden die ergebnisse eingefuegt */
/* k ist die mindestspalte */
/* AK 160790 V1.1 */ /* AK 200891 V1.3 */
{	
	OP b ;
	INT i,j,oj,obergrenze;
	if (anz == 0L) return OK;
	oj = S_T_LI(a)+1L;
	if (S_O_K(S_T_U(a)) == PARTITION) obergrenze=S_T_ULI(a);
	if (S_O_K(S_T_U(a)) == SKEWPARTITION) obergrenze=S_T_UGLI(a);
	for (i=0L; i<=obergrenze ; i++)
		{
		j=zeilenende(a,i)+1L; 
		if (j == -1L) break;
		if (j == oj) continue; /* keine ecke */
		if (j < k) continue;
		b = callocobject();
		inverse_nilplactic_jeudetaquin_tableaux(a,i,j,b);
		oj = j;
		if (anz == 1L)insert(b,l,NULL,NULL);
		else { apply_INJDT(b,l,j+1L,anz-1L); freeall(b); }
		}
	return OK;
}
#endif /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
INT perm_tableaux(a,b) OP a,b;
/* a ist permutation
   b wird liste von tableaux, die reduzierte Zerlegung sind */
/* AK 230790 V1.1 */ /* AK 200891 V1.3 */
{
	OP c= callocobject();
	lehmercode(a,c);   /* c entahelt den lehmercode der permutation */
	lehmercode_tableaux(c,b); /* b ist eine liste von tableaux, die red.
			zerlegung von a sind */
	freeall(c); /* object c freigeben */
	return OK;
}
#endif /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
INT lehmercode_tableaux(a,b) OP a,b;
/* a ist lehmercode
   b wird liste von tableaux, die reduzierte Zerlegung sind */
/* AK 230790 V1.1 */ /* AK 200891 V1.3 */
{
	INT i,j,za,k;
	OP zz,c,d,z,e;
	if (not EMPTYP(b)) freeself(b); 
		/* b zum leeren object machen */
	for (i=0L; i<S_V_LI(a); i++) if (S_V_II(a,i) != 0L) break;
		/* i ist der erste index eines 
			eintrags ungleich 0 im lehmercode */
	if (i==S_V_LI(a)) return OK;  /* lehmercode == 0-Vektor */

	/* nun haben wir einen lehmercode mit inversionen */
	c = callocobject(); copy(a,c); M_I_I(0L,S_V_I(c,i)); 
	/* c ist der gleiche lehmercode wie a nur 
		mit einer 0 an der ersten stelle
	einer inversion */

	d = callocobject(); lehmercode_tableaux(c,d);
	init(LIST,b); /* b ist list-object mit NULL self und next */
	if (EMPTYP(d)) {
		/* c war 0-Vektor */
		freeself(c);
		b_us_t(callocobject(),callocobject(),c);
		m_ilih_m(S_V_II(a,i),1L,S_T_S(c));
		for (j=0;j<S_T_LI(c);j++) M_I_I(j+1+i,S_T_IJ(c,0L,j));
		m_matrix_umriss(S_T_S(c),S_T_U(c));
		insert(c,b,NULL,NULL);
		freeall(d);
		return OK;
		}
	freeall(c);
	z=d;
	e = callocobject(); init(LIST,e);
	while (z != NULL)
		{
		apply_INJDT(S_L_S(z),e,0L,S_V_II(a,i));
		z = S_L_N(z);
		}	
	freeall(d);
	/* jetzt muss diese liste durch sucht werden ob man in der untersten
	zeile einfuegen kann */
	z = e;
	while (z != NULL) 
		{
		zz = S_L_S(z);
		if (S_T_UKLI(zz) != 1L) freeself(zz);
	/* s_t_ukii statt S_T_UKII wg MSC */
	/* s_t_ugii statt S_T_UGII wg MSC */
		else if ( s_t_ukii(zz,S_T_UKLI(zz)-1L) == 
			  s_t_ugii(zz,S_T_UGLI(zz)-1L) ) 
			{
			za = S_V_II(a,i);
			for (j=S_V_II(a,i),k=1L;j>0L; j--,k++) 
				m_i_i(j+i,S_T_IJ(zz,0L,za-k));
			m_matrix_umriss(S_T_S(zz),S_T_U(zz));
			insert(zz,b,NULL,NULL);
			C_L_S(z,NULL);
			}
		else if (
			S_T_IJI(zz,0L,zeilenanfang(zz,0L)) <=
			S_V_II(a,i) + i + 1L
			)  freeself(zz);
		else {
			za = zeilenanfang(zz,0L);
			for (j=S_V_II(a,i),k=1L;j>0L; j--,k++) 
				m_i_i(j+i,S_T_IJ(zz,0L,za-k));
			m_matrix_umriss(S_T_S(zz),S_T_U(zz));
			insert(zz,b,NULL,NULL);
			C_L_S(z,NULL);
			}
		z = S_L_N(z);
		}
	freeall(e);return OK;
}
#endif /* TABLEAUXTRUE */
