;;; -*- Mode:Lisp; Package:User; Base:10; Lowercase:T; Syntax:Common-Lisp -*-
;;; ===========================================================================
;;;			    Package Definitions
;;; ===========================================================================
;;; (c) Copyright 1989, 1991 Cornell University

;;; $Id: packages.lisp,v 1.22 1992/12/04 14:34:26 rz Exp $

(in-package "USER")

;; This should probably only be used to create the WEYL package
(defun use-weyli-package (package)
  (declare (special *weyli-shadowed-symbols*))
  (shadowing-import (loop for sym in *weyli-shadowed-symbols*
			  collect (intern (symbol-name sym) 'weyli))
		    package)
  (use-package (find-package 'weyli) package))

(defun use-weyl-package (package)
  (declare (special *weyli-shadowed-symbols*))
  (shadowing-import (loop for sym in *weyli-shadowed-symbols*
			  collect (intern (symbol-name sym) 'weyl))
		    package)
  (use-package (find-package 'weyl) package))

(defun intern-in-package (package-name symbols)
  (loop for sym in symbols
	with  package = (find-package package-name)
	collect (intern sym package)))

(defvar *weyli-shadowed-symbols*
    '(coerce set + - * / = > < >= <= minus expt abs random
      gcd lcm floor ceiling truncate round max min
      complex conjugate realpart imagpart
      sqrt exp log phase signum minusp zerop plusp
      sin cos tan asin acos atan sinh cosh tanh asinh acosh atanh
      numerator denominator reduce 
      map delete member replace substitute getf
      apply funcall variable
      type-of
      defmethod))

(unless (find-package "WEYL-INTERNALS")
  #-Genera
  (make-package "WEYL-INTERNALS"
		:nicknames '("WEYLI")
		:use '(LISP #+PCL PCL #+CLOS CLOS))
  #+Genera
  (make-package "WEYL-INTERNALS"
		:nicknames '("WEYLI") 
		:use '(#-Rel8 LISP #+Rel8 FUTURE-COMMON-LISP
		       #+PCL PCL #+CLOS CLOS)
		:colon-mode :external))

(shadow *weyli-shadowed-symbols* 'weyl-internals)

(defvar *weyli-exported-symbols*
    '("*"
      "+"
      "-"
      "/"
      "="
      ">"
      "<"
      ">="
      "<="
      "0?"
      "1?"

      "*COERCE-WHERE-POSSIBLE*"
      "*DOMAINS*"
      "*GENERAL*"
      "*MORPHISMS*"

      "ABELIAN-GROUP"
      "ABELIAN-MONOID"
      "ABELIAN-SEMIGROUP"
      "ABSTRACT-POINT"
      "ABSTRACT-SPACE"
      "ADD-NEW-VARIABLE"
      "ADD-SUBSCRIPTS"
      "ALGEBRA"
      "ALGEBRAIC-EXTENSION"
      "ARGS-OF"
      "ARGUMENT-OF"
      "BASE-OF"
      "BIGFLOAT"
      "CHARACTERISTIC"
      "CHOOSE"
      "COEFFICIENT"
      "COEFFICIENT-DOMAIN"
      "COERCE"
      "COERCIBLE?"
      "COMPOSE"
      "CROSS-PRODUCT"
      "DECLARE-DEPENDENCIES"
      "DEFINE-OPERATIONS"
      "DEFMETHOD"
      "DEGREE"
      "DELETE"
      "DEPENDS-ON?"
      "DERIV"
      "DESCRIBE-OPERATIONS"
      "DIFFERENT-KERNELS"
      "DIFFERENTIAL-RING"
      "DIMENSION"
      "DIMENSIONS"
      "DIRECT-SUM"
      "DISPLAY"
      "DOMAIN-OF"
      "DOT-PRODUCT"
      "EQN="
      "EQN>"
      "EQN>="
      "EUCLIDEAN-DOMAIN"
      "EXPONENT-OF"
      "EXPR-OF"
      "EXPRS-OF"
      "EXPT"
      "FACTOR"
      "FIELD"
      "FINITE-FIELD"
      "FINITE-SET"
      "FOURIER"
      "FUNCT"
      "FUNCT-OF"
      "GCD"
      "GCD-DOMAIN"
      "GE-DERIV?"
      "GE-EQN=?"       
      "GE-EQN>?"
      "GE-EQN>=?"
      "GE-EXPT?"
      "GE-FOURIER?"
      "GE-FUNCTION?"
      "GE-IFOURIER?"
      "GE-NARY?"
      "GE-PLUS?"
      "GE-TIMES?"
      "GE-VARIABLE?"
      "GET-ALGEBRAIC-EXTENSION"
      "GET-AUTOMORPHISMS"
      "GET-COMPLEX-NUMBERS"
      "GET-DIFFERENTIAL-RING"
      "GET-DIRECT-SUM"
      "GET-EUCLIDEAN-SPACE"
      "GET-FINITE-FIELD"
      "GET-FREE-MODULE"
      "GET-GL-N"
      "GET-HOMOMORPHISMS"
      "GET-LISP-NUMBERS"
      "GET-MATRIX-SPACE"
      "GET-MORPHISMS"
      "GET-O-N"
      "GET-POLYNOMIAL-RING"
      "GET-PSL-N"
      "GET-QUATERNION-DOMAIN"
      "GET-QUOTIENT-FIELD"
      "GET-RATIONAL-INTEGERS"
      "GET-RATIONAL-NUMBERS"
      "GET-REAL-NUMBERS"
      "GET-SL-N"
      "GET-SO-N"
      "GET-UNIT-QUATERNION-DOMAIN"
      "GET-VARIABLE-PROPERTY"
      "GET-VARIABLE-NAME"
      "GET-VECTOR-SPACE"
      "GFM"
      "GFP"
      "GROUP"
      "HOMOMORPHISM"
      "IFOURIER"
      "INSERT"
      "INTEGRAL-DOMAIN"
      "JACOBIAN"
      "LEXICAL-<"
      "LEXICAL->"
      "LHS-OF"
      "LIST-OF-VARIABLES"
      "LIST-OPERATIONS"
      "MAKE-GE-DERIV"
      "MAKE-GE-EXPT"
      "MAKE-GE-PLUS"
      "MAKE-GE-TIMES"
      "MAKE-GENERATOR"
      "MAKE-UNION"
      "MAKE-VARIABLE"
      "MAP"
      "MAP-WITH-DOMAIN"
      "MAP-OVER-ELEMENTS"
      "MAP-OVER-EXPRESSIONS"
      "MATRIX-DIMENSIONS"
      "MAX"
      "MEMBER"
      "MEMOIZE"
      "MIN"
      "MINIMAL-POLYNOMIAL"
      "MINUS?"
      "MONOID"
      "MORPHISM"
      "MULTIPLICATIVE-ORDER"
      "MUTABLE-SET"
      "NUMBER-OF-ELEMENTS"
      "NUMBER?"
      "ONE"
      "ONE-MATRIX"
      "OPERATION-ARGUMENTS"
      "OPERATION-VALUES"
      "ORDERED-ABELIAN-GROUP"
      "ORDERED-RING"
      "ORDERED-SET"
      "ORDERED-SET-OF-PAIRS"
      "ORDERED-SIMPLE-SET"
      "PARTIAL-DERIV"
      "PERMUTE"
      "PLUS?"
      "POINT"
      "POLYNOMIAL"
      "PRIME?"
      "PROJECTIVE-SPACE"
      "QUOTIENT-FIELD"
      "QUOTIENT-RING"
      "RATIONAL-INTEGER"
      "RATIONAL-INTEGERS"
      "RATIONAL-NUMBER"
      "RATIONAL-NUMBERS"
      "REAL-NUMBERS"
      "RECIP"
      "REDUCE-BASIS"
      "REF"
      "RELATIONS"
      "REMAINDER"
      "REPLACE"
      "REQUIRED-OPERATIONS"
      "RESET-DOMAINS"
      "REVLEX->"
      "RHS-OF"
      "RING"
      "RING-VARIABLES"
      "RNG"
      "SCALAR?"
      "SEMIGROUP"
      "SET"
      "SET-ELEMENTS"
      "SET-OF-PAIRS"
      "SIMPLE-FIELD-EXTENSION"
      "SIMPLE-RING"
      "SIMPLE-SET"
      "SIMPLIFY"
      "SKEW-FIELD"
      "SPACE"
      "SQUARE-FREE"
      "STRING-OF"
      "SUBSTITUTE"
      "TERMS-OF"
      "TILDE"
      "TOTAL->"
      "TOTIENT"
      "TRANSPOSE"
      "TUPLE"
      "UNIQUE-FACTORIZATION-DOMAIN"
      "UNIVERSAL-QUANTIFIED-SET"
      "VAR-OF"
      "VAR-DOMAIN-OF"
      "VARIABLE-DERIVATION"
      "VARIABLE-INDEX"
      "VARLIST-OF"
      "VECTOR-SPACE"
      "WITH-MATRIX-DIMENSIONS"
      "WITH-NUMERATOR-AND-DENOMINATOR"
      "ZERO"
      "ZERO-MATRIX"
      ))

(export (intern-in-package "WEYLI" *weyli-exported-symbols*) 'weyli)

(unless (find-package "WEYL")
  #-Genera
  (make-package "WEYL" :use '(LISP #+PCL PCL #+CLOS CLOS))

  #+Genera
  (make-package "WEYL" 
		:use '(#-Rel8 LISP #+Rel8 FUTURE-COMMON-LISP
		       #+PCL PCL #+CLOS CLOS)
		:colon-mode :external))

(use-weyli-package 'weyl)

(defvar *weyl-exported-symbols*
    '("MAKE-ELEMENT"
      "MAKE-UPOLYNOMIAL"
      ))

(export (intern-in-package "WEYL" *weyli-exported-symbols*) 'weyl)
(export (intern-in-package "WEYL" *weyl-exported-symbols*) 'weyl)


