/*
 * This file is part of tela the Tensor Language.
 * Copyright (c) 1994 Pekka Janhunen
 */

#ifdef UNICOS
#  define dgetrf_ SGETRF
#  define dgetri_ SGETRI
#  define dgesv_  SGESV
#  define dgels_  SGELS
#  define dgeev_  SGEEV
#  define dgesvd_ SGESVD
#  define zgetrf_ CGETRF
#  define zgetri_ CGETRI
#  define zgesv_  CGESV
#  define zgels_  CGELS
#  define zgeev_  CGEEV
#  define zgesvd_ CGESVD
#  define dgemm_  SGEMM
#  define zgemm_  CGEMM
#  define ddot_   SDOT
#endif

extern "C" {

/* LAPACK routines: */
/* ---------------- */
	
void dgetrf_(const Tint& M, const Tint& N,
			 Treal A[], const Tint& LDA,
			 Tint IPIV[],
			 Tint& INFO);

void dgetri_(const Tint& N,
			 Treal A[], const Tint& LDA,
			 const Tint IPIV[],
			 Treal WORK[], const Tint& LWORK,
			 Tint& INFO);

void dgesv_(const Tint& N,
			const Tint& NRHS,
			Treal A[],
			const Tint& LDA,
			Tint IPIV[],
			Treal B[],
			const Tint& LDB,
			Tint& INFO);

void dgels_(const char*TRANSA,
			const Tint& M,
			const Tint& N,
			const Tint& NRHS,
			Treal A[],
			const Tint& LDA,
			Treal B[],
			const Tint& LDB,
			Treal WORK[],
			const Tint& LWORK,
			Tint& INFO);

void dgeev_(const char*JOBVL, const char*JOBVR,
			const Tint& N,
			Treal A[],
			const Tint& LDA,
			Treal WR[], Treal WI[],
			Treal VL[], const Tint& LDVL,
			Treal VR[], const Tint& LDVR,
			Treal WORK[], const Tint& LWORK,
			Tint& info);

void dgesvd_(const char*JOBU, const char*JOBVT,
			 const Tint& M, const Tint& N,
			 Treal A[], const Tint& LDA,
			 Treal S[],
			 Treal U[], const Tint& LDU,
			 Treal VT[], const Tint& LDVT,
			 Treal WORK[], const Tint& LWORK,
			 Tint& INFO);
		 

void zgetrf_(const Tint& M, const Tint& N,
			 Tcomplex A[], const Tint& LDA,
			 Tint IPIV[],
			 Tint& INFO);

void zgetri_(const Tint& N,
			 Tcomplex A[], const Tint& LDA,
			 const Tint IPIV[],
			 Tcomplex WORK[], const Tint& LWORK,
			 Tint& INFO);

void zgesv_(const Tint& N,
			const Tint& NRHS,
			Tcomplex A[],
			const Tint& LDA,
			Tint IPIV[],
			Tcomplex B[],
			const Tint& LDB,
			Tint& INFO);

void zgels_(const char*TRANSA,
			const Tint& M,
			const Tint& N,
			const Tint& NRHS,
			Tcomplex A[],
			const Tint& LDA,
			Tcomplex B[],
			const Tint& LDB,
			Tcomplex WORK[],
			const Tint& LWORK,
			Tint& INFO);

void zgeev_(const char*JOBVL, const char*JOBVR,
			const Tint& N,
			Tcomplex A[], const Tint& LDA,
			Tcomplex W[],
			Tcomplex VL[], const Tint& LDVL,
			Tcomplex VR[], const Tint& LDVR,
			Tcomplex WORK[], const Tint& LWORK,
			Treal RWORK[],
			Tint& INFO);

void zgesvd_(const char*JOBU, const char*JOBVT,
			 const Tint& M, const Tint& N,
			 Tcomplex A[], const Tint& LDA,
			 Treal S[],
			 Tcomplex U[], const Tint& LDU,
			 Tcomplex VT[], const Tint& LDVT,
			 Tcomplex WORK[], const Tint& LWORK,
			 Treal RWORK[],
			 Tint& INFO);

/* Level-1 BLAS routines: */
/* ---------------------- */

Treal ddot_(const Tint& N, const Treal x[], const Tint& incx, const Treal y[], const Tint& incy);

/* Level-3 BLAS routines: */
/* ---------------------- */
	
void dgemm_(const char* TRANSA, const char* TRANSB,
			const Tint& M, const Tint& N, const Tint& K,
			const Treal& ALPHA,
			const Treal A[], const Tint& LDA,
			const Treal B[], const Tint& LDB,
			const Treal& BETA,
			Treal C[], const Tint& LDC);

void zgemm_(const char* TRANSA, const char* TRANSB,
			const Tint& M, const Tint& N, const Tint& K,
			const Tcomplex& ALPHA,
			const Tcomplex A[], const Tint& LDA,
			const Tcomplex B[], const Tint& LDB,
			const Tcomplex& BETA,
			Tcomplex C[], const Tint& LDC);

}

#ifdef UNICOS
#  define RGETRF SGETRF
#  define RGETRI SGETRI
#  define RGESV  SGESV
#  define RGELS  SGELS
#  define RGEEV  SGEEV
#  define RGESVD SGESVD
#  define RGEMM  SGEMM
#  define RDOT   SDOT
#else
#  define RGETRF dgetrf_
#  define RGETRI dgetri_
#  define RGESV  dgesv_
#  define RGELS  dgels_
#  define RGEEV  dgeev_
#  define RGESVD dgesvd_
#  define CGETRF zgetrf_
#  define CGETRI zgetri_
#  define CGESV  zgesv_
#  define CGELS  zgels_
#  define CGEEV  zgeev_
#  define CGESVD zgesvd_
#  define RGEMM  dgemm_
#  define CGEMM  zgemm_
#  define RDOT   ddot_
#endif

