E0 = 0.3E-3;
Kp = 4;
CorotationPotential = 91E3;
dx = 0.5;
dy = dx;
[x,y] = grid(-16:dx:-4.,-7:dy:7.);

function [u;] = BC()	// Impose homogeneous Neumann boundary conditions on grid u
{
	u[2:imax-1,1] = u[2:imax-1,2];
	u[2:imax-1,jmax] = u[2:imax-1,jmax-1];
	u[1,1:jmax] = u[2,1:jmax];
	u[imax,1:jmax] = u[imax-1,1:jmax];
};

function [Vx,Vy] = grad(f)	// Compute the gradient of a scalar field f
{
	Vx = zeros(imax,jmax);
	Vy = zeros(imax,jmax);
	Vx[2:imax-1,2:jmax-1] = (f[3:imax,2:jmax-1] - f[1:imax-2,2:jmax-1])/(2*RE*dx);
	Vy[2:imax-1,2:jmax-1] = (f[2:imax-1,3:jmax] - f[2:imax-1,1:jmax-2])/(2*RE*dy);
	[Vx] = BC();
	[Vy] = BC();
};

function [y;] = neighbour_average(f)
{
	y[2:imax-1,2:jmax-1] =
		(4*f[2:imax-1,2:jmax-1]
		 + f[3:imax,2:jmax-1] + f[1:imax-2,2:jmax-1] + f[2:imax-1,3:jmax] + f[2:imax-1,1:jmax-2])/8;
	[y] = BC();
};

function y=th(x) {y=HeavisideTheta(x)};

RE = 6730E3;
[imax,jmax] = size(x);
r = sqrt(x^2+y^2);
rr = max(1,r+1E-8);
phim = -E0*y*RE - CorotationPotential/rr + 20E3*exp(-((x+8)/(3*th(x+8)+10*th(-8-x)))^2-((y-2)/(6*th(y-2)+8*th(2-y)))^2);

function mycontour(z,tit) {
contour(z,"nsteps",30,"xflip","true","xlabel","y", "ylabel","x",
		"xmin",min(y), "xmax",max(y), "ymin",min(x), "ymax",max(x),
		"toplabel",tit, "subtitle","In equatorial plane GSM coordinates")
};	

function mypcolor(z,tit) {
pcolor(z,"xflip","true","xlabel","y", "ylabel","x",
		"xmin",min(y), "xmax",max(y), "ymin",min(x), "ymax",max(x),
		"toplabel",tit, "subtitle","In equatorial plane GSM coordinates")
};	

//mycontour(1E-3*phim,"Potential (kV)");

Bz = 30000E-9/rr^3;
for (i=1; i<=imax; i++) for (j=1; j<=jmax; j++) {
	[bx,by,bz] = T89(Kp,x[i,j],y[i,j],0);
	Bz[i,j] = 1E-9*bz;
};

//mycontour(1E9*Bz,"Bz (nT)");
[Ex,Ey] = grad(phim);
vx = Ey/Bz;
vy = -Ex/Bz;
vmagn = sqrt(vx^2+vy^2);
[Dxvx,Dyvx] = grad(vx);
[Dxvy,Dyvy] = grad(vy);
gradv = abs(Dxvy-Dyvx);	// essentially gradv = curl(v)

//mycontour(1E-3*vmagn,"v (km/s)");
scalelength = min(100*RE,vmagn/(1E-11+gradv));
[scalelength] = BC();
//mycontour(scalelength/RE,"Scale length (RE)");

a = 0.72;
gamma = 1.64;
mp = 1.67E-27;

n = 1E6;
SigmaP = 6;
K = 1E-9;
Bi = 50000E-9;
H = 7*RE - 0.1*r*RE;
//scalelength = 2*RE;

[bx,by,bz] = T89(Kp,-11,0,0);	// compute bz at x=-11
bz = 1E-9*bz;					// transform it to Tesla
rho = mp*n * (Bz/bz);			// assume rho ~ Bz
lambda = sqrt(Bi*SigmaP/(Bz*K));
lotko = (1/a)*(rho*vmagn/(SigmaP*Bz^2))*(H/lambda)*(lambda/scalelength)^gamma;
mypcolor(lotko,"lotko");
