/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 3.12 $"
#endif
/*
$Header: /pita/work/HDF/dev/RCS/src/dfkit.c,v 3.12 1991/10/22 17:56:10 dilg beta $
$Log: dfkit.c,v $
 * Revision 3.12  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.11  1990/08/30  14:23:31  clow
 * replace DFCV ieee <-> unicos routine calls with calls to CSPK32 and SCUP32
 *
 * Revision 3.10  90/07/02  09:37:52  clow
 * enclosed DFconvert macro and function with an #ifdef on FUNC_CONV
 * so that the selection between these is a compilation option
 * 
 * Revision 3.9  90/06/21  10:40:53  clow
 * Changes UNICOS conversion functions for non-UNICOS env to be similar
 * to the UNICOS fortran functions, and
 * "#if 0" out the DFconvert function, use macro in dfconvrt.h
 * 
 * Revision 3.8  90/06/07  17:39:28  clow
 * bug fix in conversion routines

 * 
*/
/*
 * Changes:
 *	DFconvert() calls FORTRAN conversion routines if compiled with UNICOS 
 *	DFconvert() takes an array rather than a single number
 *	Register parameters have been declared
 *	Pointers are now used rather than array indexing
 */
/* Modified DFconvert so that it takes an array rather than a single number */
/* Now call FORTRAN conversion routines */
#include <ctype.h>
#include "df.h"

union fpx
{
     float f;
     long  l;
};

union float_uint_uchar {
    float32 f;
    int32 i;
    uint8 c[4];
};

#if defined __STDC__ || defined PC
char *DFIstrncpy(register char *dest,register char *source,int len)
#else
char *DFIstrncpy(dest, source, len)
register char *source, *dest;
int len;
#endif /* __STDC_ || PC */
{

    for(; (len-- > 0) && (*dest++ = *source++););
/*  Quincey's mod goes bye-bye
    for(; len-- > 0;)
        *dest++ = '\0';
    bye-bye! */
    if (!len) *dest = '\0';
	return(dest);
}

#ifdef FUNC_CONV
/* function convert, otherwise, this function is done in macro (dfconvrt.h) */
#if defined __STDC__ || defined PC
int DFconvert(char *source, char *dest, int ntype, register int sourcetype,
	      register int desttype, int size)
#else
int DFconvert(source, dest, ntype, sourcetype, desttype, size)
char *source, *dest;
int ntype;
register int sourcetype, desttype;
int size;
#endif /* __STDC_ || PC */
{
    register char t;      /* Temporary, used in byte-swapping */
    register int i;
	int status;

    if (ntype==DFNT_FLOAT) {

	if (((sourcetype==DFNTF_IEEE) && ( desttype==DFNTF_PC)) ||
	    ((sourcetype==DFNTF_PC) && (desttype==DFNTF_IEEE))) {
            for (i=0; i<size*4; i+=4)
              {
	        dest[i  ] = source[i+3];
	        dest[i+1] = source[i+2];
	        dest[i+2] = source[i+1];
	        dest[i+3] = source[i  ];
              }
	    return(0);
	}

	/* if reversed IEEE, reverse before conversion */
	if (sourcetype==DFNTF_PC) {
	  sourcetype=DFNTF_IEEE;
          for (i=0; i<size*4; i+=4)
            {
	      t           = source[i];
	      source[i  ] = source[i+3];
              source[i+3] = t;
	      t           = source[i+1];
	      source[i+1] = source[i+2];
              source[i+2] = t;
            }
	}

        if ((sourcetype==DFNTF_IEEE) && (desttype==DFNTF_CRAY)) {
#ifdef UNICOS
            SCUP32(source, dest, &size, &status);
#else
            if (SCUP32(source,(union fpx*) dest, size)<0)
               return(-1);
#endif
        } else if ((sourcetype==DFNTF_CRAY) &&
		   ((desttype==DFNTF_IEEE) || (desttype==DFNTF_PC))) {
#ifdef UNICOS
            CSPK32(source, dest, &size, &status);
#else
            if (CSPK32((union fpx*)source, dest, size)<0) 
               return(-1);
#endif
	}

        if ((sourcetype==DFNTF_IEEE) && (desttype==DFNTF_VAX)) {
            if (DFCVieeeF2vaxF((union float_uint_uchar *) source,
			       (union float_uint_uchar *) dest, size)<0)
		return(-1);
        } else if ((sourcetype==DFNTF_VAX) &&
		   ((desttype==DFNTF_IEEE) || (desttype==DFNTF_PC))) {
            if (DFCVvaxF2ieeeF((union float_uint_uchar*) source,
			       (union float_uint_uchar*) dest, size)<0)
		return(-1);
        }

	/* if reversed IEEE, reverse result */
	if (desttype==DFNTF_PC) {
          for (i=0; i<size*4; i+=4)
            {
	      t         = dest[i+3];
	      dest[i+3] = dest[i];
	      dest[i  ] = t;
	      t         = dest[i+2];
	      dest[i+2] = dest[i+1];
	      dest[i+1] = t;
            }
	}
	return(0);
    }
        /* default */
    DFerror = DFE_BADCONV;
    return(-1);
}
#else /* FUNC_CONV */
#include "dfconvrt.h"
#endif /* FUNC_CONV */

#ifdef PC
#ifdef WIN3
int32 DFIspaceleft(void)
{
/* return the largest amount of memory Windows can give us */
   return(GlobalCompact(0));
}
#else /* WIN3 */
int32 DFIspaceleft(void)
{
    struct _heapinfo h_info;        /* structure for heap information, defined in <malloc.h> */
    int heap_status;                /* the current condition of the heap */
    int32 total_free,total_used;    /* variables to store the amount used and the amount free in the heap */

    total_free=0;
    total_used=0;
    h_info._pentry=NULL;
    for(;;) {
        heap_status=_heapwalk(&h_info);
        if(heap_status!=_HEAPOK)
            break;
        if(h_info._useflag==_USEDENTRY)
            total_used+=h_info._size;
        else
            total_free+=h_info._size;
    } /* end for */
    switch(heap_status) {
        case _HEAPEND:
        case _HEAPEMPTY:
            break;

        case _HEAPBADBEGIN:
            printf("%s block at %Fp of size %4.4X\n",(h_info._useflag==_USEDENTRY ? "USED" : "FREE"),h_info._pentry,h_info._size);
            printf("ERROR - heap is damaged\n\n");
            return((int32)-1);
            break;

        case _HEAPBADPTR:
            printf("%s block at %Fp of size %4.4X\n",(h_info._useflag==_USEDENTRY ? "USED" : "FREE"),h_info._pentry,h_info._size);
            printf("ERROR - bad pointer to heap\n\n");
            return((int32)-1);
            break;

        case _HEAPBADNODE:
            printf("%s block at %Fp of size %4.4X\n",(h_info._useflag==_USEDENTRY ? "USED" : "FREE"),h_info._pentry,h_info._size);
            printf("ERROR - bad node in heap\n\n");
            return((int32)-1);
            break;
    } /* end switch */
    return((int32)total_free);
} /* end DFIspaceleft() */
#endif /* WIN3 */
#endif /* PC */


#ifdef PC
#ifdef WIN3
void *DFIgetspace(uint32 qty)
{
    HANDLE mem_handle;  /* handle of the memory allocated */
    HANDLE *handle_addr;/* pointer to the HANDLE stored in the memory block */
    char huge *p1;
    char *p2;

    if (qty <= (uint32)128) {
        mem_handle=LocalAlloc(LMEM_MOVEABLE, (WORD)qty+sizeof(HANDLE)+1);
        if (mem_handle==NULL) {
            DFerror = DFE_NOSPACE;
            return(NULL);
        }
        handle_addr=(HANDLE *)(p2=(char *)LocalLock(mem_handle));
        if (handle_addr==NULL) {
            DFerror = DFE_NOSPACE;
            return(NULL);
        }
        *handle_addr=mem_handle;
        *((char *)handle_addr+sizeof(HANDLE))=0;
        return (p2+sizeof(HANDLE)+1);
    } else {
        mem_handle=GlobalAlloc(GMEM_MOVEABLE,(DWORD)(qty+sizeof(HANDLE)+1));
        if(mem_handle==NULL) {
            DFerror = DFE_NOSPACE;
            return(NULL);
        }
        /* lock down the block, use GlobalWire because we don't know how long */
        /*  this potentially large block will be used */
        handle_addr=(HANDLE *)(p1=(char huge *)GlobalWire(mem_handle));
        if (handle_addr==NULL) {
            DFerror = DFE_NOSPACE;
            return(NULL);
        }
        *handle_addr=mem_handle;    /* store the handle in the first part of the memory block */
        *((char *)handle_addr+sizeof(HANDLE))=1;
        return(p1+sizeof(HANDLE)+1);
    }
}

void *DFIfreespace(void *ptr)
{
    HANDLE mem_handle;  /* handle of the memory allocated */
    HANDLE *handle_addr;/* pointer to the HANDLE stored in the memory block */

    if(ptr!=NULL) {
/* get the address of the handle, which is stored in the memory block itself */
        handle_addr=(HANDLE *)((char *)ptr-sizeof(HANDLE)-1);
        mem_handle=*handle_addr;    /* get the handle from the memory block */
        if (*((char *)ptr-1)) {
            GlobalUnWire(mem_handle);     /* unlock the block */
            GlobalFree(mem_handle);       /* free the block */
        } else {
            LocalUnlock(mem_handle);
            LocalFree(mem_handle);
        }
    } /* end if */
    return(NULL);
}
#else /* WIN3 */
char *DFIgetspace(uint32 qty)
{
    char huge *p;
    char *p2;

    qty++;          /* increment the quantity to allocate to allow for the extra byte we are going to include */

    if(qty>=(int32)64000) {   /* see if we have to use halloc() to get a really large chunk of memory */
        p = halloc((int32)qty,(size_t)1);
        if (p==NULL) {
            DFerror = DFE_NOSPACE;
            return(NULL);
          } /* end if */
        *p=1;           /* indicate that halloc() was used to acquire this memory */
        p++;
        return((char huge *)p);
      } /* end if */
    else {      /* we can get away with just malloc() */
        p2 = malloc((size_t)qty);
        if (p2==NULL) {
            DFerror = DFE_NOSPACE;
            return(NULL);
          } /* end if */
        *p2=0;           /* indicate that malloc() was used to acquire this memory */
        p2++;
        return((char huge *)p2);
      } /* end else */
}

char *DFIfreespace(char *ptr)
{
    ptr--;      /* decrement the pointer to free */
    if(*ptr) {  /* check whether the block of memory was allocated with halloc() */
        if(ptr!=NULL)
            hfree(ptr);
      } /* end if */
    else {      /* memory was allocated through malloc() */
        if(ptr!=NULL)
            free(ptr);
      } /* end else */
    return(NULL);
}
#endif /* WIN3 */
#else /* PC */


#if defined __STDC__ || defined PC
char *DFIgetspace(uint32 qty)
#else
char *DFIgetspace(qty)
uint32 qty;
#endif /* __STDC_ || PC */
{
    char *p;

    p = (char *) malloc(qty);
    if (p== (char *) NULL) {
        DFerror = DFE_NOSPACE;
        return(NULL);
    }
    return(p);
}

#if defined __STDC__ || defined PC
char *DFIfreespace(char *ptr)
#else
char *DFIfreespace(ptr)
char *ptr;
#endif /* __STDC_ || PC */
{
    if (ptr!=NULL) free(ptr);
    return(NULL);
}
#endif /* PC */


#ifdef UNICOS

#define MINEXP    0x3f81000000000000  /* min valid Cray masked exponent */
#define MAXEXP    0x407e000000000000  /* max valid Cray masked exponent */

#define C_FMASK   0x00007fffff000000  /* Cray fraction mask (1st 23 bits)*/
#define C_EMASK   0x7fff000000000000  /* Cray exponent mask */
#define C_SMASK   0x8000000000000000  /* Cray sign mask */
#define C_IMPLICIT 0x0000800000000000 /* Cray implicit bit */

#define I_FMASK   0x007fffff          /* IEEE fraction mask */
#define I_EMASK   0x7f800000          /* IEEE exponent mask */
#define I_SMASK   0x80000000          /* IEEE sign mask     */

#define IEEE_BIAS 0177
#define CRAY_BIAS 040000

#endif /*UNICOS*/

/* On UNICOS, this function is defined as a fortran function */
#ifndef UNICOS
    /*  convert from Cray2 floating point format to IEEE format */
/* shut lint up */
/* ARGSUSED */
#if defined __STDC__ || defined PC
CSPK32(char *cray_fp, char *ieee_fp, int *size, int *status)
#else
CSPK32(cray_fp, ieee_fp, size, status)
char *cray_fp;
char *ieee_fp;
int *size;
int *status;
#endif /* __STDC_ || PC */
{
    cray_fp = cray_fp;
    ieee_fp = ieee_fp;
    size = size;

    DFerror = DFE_BADCONV;
    *status = -1;
    return 0;
}
#endif /*!UNICOS*/

#if 0
/* Old cray conversion routine */
    register int i;
    register long C2I_diff;
    long tmp;
    C2I_diff = (IEEE_BIAS - CRAY_BIAS - 1) << 48;
    for (i=0; i<size; i++, cray_fp++, ieee_fp+=4)
      {
        if (cray_fp->l == 0)
          tmp = 0;
        else {
          tmp = (C_EMASK & cray_fp->l);
          if (tmp < MINEXP || tmp > MAXEXP) {
              DFerror = DFE_BADFP;
              return(-1);
          }

          tmp = ((tmp + C2I_diff) << 7)
            | ( (cray_fp->l & C_FMASK) << 8 )
            | ( (cray_fp->l & C_SMASK));
        }
		DFmovmem((char *)&tmp, ieee_fp, 4);
      }
    return(0);
}
#endif /* 0 */

/* On UNICOS, this function is defined as a fortran function */
#ifndef UNICOS
/* Conversion from IEEE floating point format to Cray format */
/* shut lint up */
/* ARGSUSED */
#if defined __STDC__ || defined PC
SCUP32(char *ieee_fp, char *cray_fp, int *size, int *status)
#else
SCUP32(ieee_fp, cray_fp, size, status)
char *cray_fp;
char *ieee_fp;
int *size;
int *status;
#endif /* __STDC_ || PC */
{
    cray_fp = cray_fp;
    ieee_fp = ieee_fp;
    size = size;

    DFerror = DFE_BADCONV;
    *status = -1;
    return 0;
}
#endif /*!UNICOS*/

#if 0
register union fpx *cray_fp;
register char *ieee_fp;
int size;
{
    long tmp;
    register int i;
    register long I2C_diff;

    I2C_diff = (CRAY_BIAS - IEEE_BIAS + 1) << 23;
    for (i=0; i<size; i++, ieee_fp+=4, cray_fp++)
      {
        tmp = 0;
        DFmovmem(ieee_fp, ((char *) &tmp) + 4, 4); 

        if ( (cray_fp->l = tmp & I_EMASK) == 0) {
          cray_fp->l = 0;
          continue;
        }

        cray_fp->l += I2C_diff;
        cray_fp->l = (cray_fp->l<< 25)
           | ( (tmp & I_FMASK) << 24)
           | ( (tmp & I_SMASK) << 32)
	   | C_IMPLICIT;
      }
    return (0);

}
#endif /* 0 */

#if defined __STDC__ || defined PC
DFIc2fstr(char *str, int len)
#else
DFIc2fstr(str, len)
char* str;
int len;
#endif /* __STDC_ || PC */
{
    int i;

    for(i=0; (str[i]); i++);
    for(; i<len; i++) str[i] = ' ';
    return 0;
}

#if defined __STDC__ || defined PC
char *DFIf2cstring(_fcd fdesc, int len)
#else
char *DFIf2cstring(fdesc, len)
    _fcd fdesc;
    int len;
#endif /* __STDC_ || PC */
{
    char *cstr, *str;
    int i;

    str = _fcdtocp(fdesc);
    for(i=len-1;i>=0 && (!isascii(str[i]) || !isgraph(str[i])); i--)
	/*EMPTY*/;
    cstr = DFIgetspace(i+2);
    cstr[i+1] = '\0';
    for (; i>=0; i--) cstr[i] = str[i];
    return cstr;
}

#if defined __STDC__ || defined PC
int DFCVvaxF2ieeeF(union float_uint_uchar in[], union float_uint_uchar out[],
		   int size)
#else
int DFCVvaxF2ieeeF(in, out, size)
union float_uint_uchar in[], out[];
int size;
#endif /* __STDC_ || PC */
{
    uint8 exp;
    int i;

    for (i=0; i<size; i++) {
        exp = (uint8)(in[i].c[1] << 1) | (uint8)(in[i].c[0] >> 7);  /* extract exponent */
        if (!exp && !in[i].c[1]) out[i].i = 0;        /* zero value */
        else if (exp>2) {                               /* normal value */
            out[i].c[0] = in[i].c[1] - (uint8)1; /* subtracts 2 from exponent */
                /* copy mantissa, LSB of exponent */
            out[i].c[1] = in[i].c[0];
            out[i].c[2] = in[i].c[3];
            out[i].c[3] = in[i].c[2];
        }
        else if (exp) {                          /* denormalized number */
            register int shft;

            out[i].c[0] = in[i].c[1] & (uint8)0x80; /* keep sign, zero exponent */
            shft = 3 - exp;
            /* shift original mant by 1 or 2 to get denormalized mant */
            /* prefix mantissa with '1'b or '01'b as appropriate */
            out[i].c[1] = (uint8)((in[i].c[0] & 0x7f) >> shft) | (uint8)(0x10 << exp);
            out[i].c[2] = (uint8)(in[i].c[0] << (8-shft)) | (uint8)(in[i].c[3] >> shft);
            out[i].c[3] = (uint8)(in[i].c[3] << (8-shft)) | (uint8)(in[i].c[2] >> shft);
        }
        else {                                  /* sign=1 -> infinity or NaN */
            out[i].c[0] = 0xff;                /* set exp to 255 */
                /* copy mantissa */
            out[i].c[1] = in[i].c[0] | (uint8)0x80;  /* LSB of exp = 1 */
            out[i].c[2] = in[i].c[3];
            out[i].c[3] = in[i].c[2];
        }
    }
    return(0);
}


#if defined __STDC__ || defined PC
int DFCVieeeF2vaxF(union float_uint_uchar in[], union float_uint_uchar out[],
		   int size)
#else
int DFCVieeeF2vaxF(in, out, size)
union float_uint_uchar in[], out[];
int size;
#endif /* __STDC_ || PC */
{
    register uint8 exp;
    int i;

    for (i=0; i<size; i++)
      {
         exp = (uint8)(in[i].c[0] << 1) | (uint8)(in[i].c[1] >> 7); /* extract exponent */
         if (exp) {                                  /* non-zero exponent */
            /* copy mantissa, last bit of exponent */
           out[i].c[0] = in[i].c[1];
           out[i].c[2] = in[i].c[3];
           out[i].c[3] = in[i].c[2];
           if (exp<254)                        /* normal value */
             out[i].c[1] = in[i].c[0] + (uint8)1;   /* actually adds two to exp */
           else {                              /* infinity or NaN */
             if (exp==254)                     /* unrepresentable - OFL */
               out[i].i = 0;                  /* set mant=0 for overflow */
            out[i].c[0] &= 0x7f;              /* set last bit of exp to 0 */
            out[i].c[1] = 0x80;               /* sign=1 exp=0 -> OFL or NaN */
          }
        }
        else if (in[i].c[1] & 0x60) {               /* denormalized value */
          register int shft;
    
          shft = (in[i].c[1] & 0x40) ? 1 : 2;  /* shift needed to normalize */
            /* shift mantissa */
            /* note last bit of exp set to 1 implicitly */
          out[i].c[0] = (uint8)(in[i].c[1] << shft) & (uint8)(in[i].c[2] >> (8-shft));
          out[i].c[3] = (uint8)(in[i].c[2] << shft) & (uint8)(in[i].c[3] >> (8-shft));
          out[i].c[2] = (uint8)(in[i].c[3] << shft);
          out[i].c[1] = (uint8)(in[i].c[0] & 0x80);          /* sign */
          if (shft==1) {                          /* set exp to 2 */
            out[i].c[1] |= 0x01;
            out[i].c[0] &= 0x7f;                  /* set LSB of exp to 0 */
          }
        }
        else out[i].i = 0;                            /* zero */
      }
    return(0);
}
