/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfkit.h,v 1.1 1991/10/22 17:56:10 dilg beta $

$Log: dfkit.h,v $
 * Revision 1.1  1991/10/22  17:56:10  dilg
 * Initial revision
 *
*/
#ifndef DFKIT    /* avoid re-inclusion */
#define DFKIT

#include "df.h"

union float_uint_uchar {
    float32 f;
    int32 i;
    uint8 c[4];
};

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfkit.c */

extern char huge *DFIstrncpy(register char huge *dest,
                             register char huge *source, int len);
extern int32 DFIspaceleft(void);
extern void huge *DFIgetspace(uint32 qty);
extern void huge *DFIfreespace(void huge *ptr);
extern int CSPK32(char huge *cray_fp, char huge *ieee_fp, int huge *size,
                  int huge *status);
extern int SCUP32(char huge *ieee_fp, char huge *cray_fp, int huge *size,
                  int huge *status);
extern int DFIc2fstr(char huge *str, int len);
extern char huge *DFIf2cstring(char huge *fdesc, int len);
extern int DFCVvaxF2ieeeF(union float_uint_uchar huge *in,
                          union float_uint_uchar huge *out, int size);
extern int DFCVieeeF2vaxF(union float_uint_uchar huge *in,
                          union float_uint_uchar huge *out, int size);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfkit.c */

extern char *DFIstrncpy(register char *dest, register char *source, int len);
extern int32 DFIspaceleft(void);
extern void *DFIgetspace(uint32 qty);
extern void *DFIfreespace(void *ptr);
extern int CSPK32(char *cray_fp, char *ieee_fp, int *size, int *status);
extern int SCUP32(char *ieee_fp, char *cray_fp, int *size, int *status);
extern int DFIc2fstr(char *str, int len);
extern char *DFIf2cstring(char *fdesc, int len);
extern int DFCVvaxF2ieeeF(union float_uint_uchar in[],
                          union float_uint_uchar out[], int size);
extern int DFCVieeeF2vaxF(union float_uint_uchar in[],
                          union float_uint_uchar out[], int size);


#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/* prototypes for dfkit.c */
extern char *DFIstrncpy();
extern int32 DFIspaceleft();
extern char *DFIgetspace();
extern char *DFIfreespace();
extern int CSPK32();
extern int SCUP32();
extern int DFIc2fstr();
extern char *DFIf2cstring();
extern int DFCVvaxF2ieeeF(); 
extern int DFCVieeeF2vaxF();

#endif /* __STDC__ */
#endif /* DFKIT */



