/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfp.h,v 1.1 1991/10/22 17:56:10 dilg beta $

$Log: dfp.h,v $
 * Revision 1.1  1991/10/22  17:56:10  dilg
 * Initial revision
 *
*/
#ifndef DFP /* avoid re-inclusion */

#define DFP
#include "df.h"

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfp.c */

extern int DFPgetpal(char huge *filename, uint8 huge *palette);
extern int DFPputpal(char huge *filename, uint8 huge *palette, int overwrite,
                     char huge *filemode);
extern int DFPaddpal(char huge *filename, uint8 huge *palette);
extern int DFPnpals(char huge *filename);
extern int DFPreadref(char huge *filename, uint16 ref);
extern int DFPwriteref(char huge *filename, uint16 ref);
extern int DFPrestart(void);
extern int DFPlastref(void);
extern DF huge *DFPIopen(char huge *filename, int access);


/* prototypes for dfpF.c */

extern int dpigpal_(char huge *filename, char huge *pal, int huge *fnlen);
extern int dpippal_(char huge *filename, char huge *pal, int overwrite,
                    char huge *filemode, int huge *fnlen);
extern int dpinpal_(char huge *filename, int huge *fnlen);
extern int dpirref_(char huge *filename, uint16 ref, int huge *fnlen);
extern int dpiwref_(char huge *filename, uint16 ref, int huge *fnlen);
extern int dprest_(void);
extern int dplref_(void);
extern int dfprestart_(void);
extern int dfplastref_(void);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfp.c */

extern int DFPgetpal(char *filename, uint8 *palette);
extern int DFPputpal(char *filename, uint8 *palette, int overwrite,
                     char *filemode);
extern int DFPaddpal(char *filename, uint8 *palette);
extern int DFPnpals(char *filename);
extern int DFPreadref(char *filename, uint16 ref);
extern int DFPwriteref(char *filename, uint16 ref);
extern int DFPrestart(void);
extern int DFPlastref(void);
extern DF *DFPIopen(char *filename, int access);


/* prototypes for dfpF.c */

extern int dpigpal_(char *filename, char *pal, int *fnlen);
extern int dpippal_(char *filename, char *pal, int *overwrite, char *filemode,
                    int *fnlen);
extern int dpinpal_(char *filename, int *fnlen);
extern int dpirref_(char *filename, uint16 *ref, int *fnlen);
extern int dpiwref_(char *filename, uint16 *ref, int *fnlen);
extern int dprest_(void);
extern int dplref_(void);
extern int dfprestart_(void);
extern int dfplastref_(void);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */


/* prototypes for dfp.c */

extern int DFPgetpal();
extern int DFPputpal();
extern int DFPaddpal();
extern int DFPnpals();
extern int DFPreadref();
extern int DFPwriteref();
extern int DFPrestart();
extern int DFPlastref();
extern DF *DFPIopen();


/* prototypes for dfpF.c */

extern int dpigpal_();
extern int dpippal_();
extern int dpinpal_();
extern int dpirref_();
extern int dpiwref_();
extern int dprest_();
extern int dplref_();
extern int dfprestart_();
extern int dfplastref_();

#endif /* __STDC__ */

#endif /* DFP */

