C*****************************************************************************
C 
C			  NCSA HDF version 3.10r5
C			     October 24, 1991
C
C NCSA HDF Version 3.10r5 source code and documentation are in the public
C domain.  Specifically, we give to the public domain all rights for future
C licensing of the source code, all resale rights, and all publishing rights.
C 
C We ask, but do not require, that the following message be included in all
C derived works:
C 
C Portions developed at the National Center for Supercomputing Applications at
C the University of Illinois at Urbana-Champaign.
C 
C THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
C SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
C WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
C 
C****************************************************************************/
C
C $Header: /pita/work/HDF/dev/RCS/src/dfufp2imFf.f,v 1.3 1991/10/22 17:56:10 dilg beta $
C
C $Log: dfufp2imFf.f,v $
c Revision 1.3  1991/10/22  17:56:10  dilg
c 5
c HDF3.1r5
c
c New machine types added:
c
c         PC      - IBM PC (DOS)
c         WIN     - IBM PC (Microsoft Windows 3.0)
c         IBM6000 - IBM RS/6000 (AIX)
c         CONVEX  - Convex C-2 (Unix)
c
c Bugs fixed in:
c
c         scup32.f
c         cspck32.f
c         dfpFf.f
c         dfpF.c
c         dfsd.c
c
c New utility added:
c
c         ristosds.c - convert raster images to sds.
c
c Also:
c         All code for the library was modified to conform to the
c         ANSI C standard.
c
c Revision 1.2  1991/01/14  08:23:27  mfolk
c Fixed bug in dfufptoimage: 1st executable line went beyond col 72
c
c Revision 1.1  90/06/05  21:03:58  mfolk
c Initial revision
c 
C


C------------------------------------------------------------------------------
C File:     DFUfptoimFf.f
C Purpose:  Fortran stub for DFUfptoimage()
C Invokes:  DFUfptoimage.c
C Contents: 
C   duf2im:       call duif2i_ to invoke DFUfptoimage()
C   dfufptoimage: call duif2i_ to invoke DFUfptoimage()
C -----------------------------------------------------------------------------

C------------------------------------------------------------------------------
C Name:     duf2im
C Purpose:   call duif2i_ to invoke DFUfptoimage()
C Inputs:   
C      hdim, vdim: horizontal and vertical dimensions of input data
C      max, min:   maximum and minimum values in the data
C      hscale,vscale: optional horizontal and vertical scales
C      data:       input data
C      palette:    optional palette to be stored with the image
C      outfile:n   name of hdf file to store image in
C      ct_method:  color transform method: 1=EXPAND; 2=INTERP
C      hres, vres: resolutions desired for output image
C      compress:   compression flag: 0=don't; 1=do
C  Returns: 0 on success, -1 on failure with DFerror set
C  Users:       HDF HLL (high-level library) users, utilities, other routines
C  Invokes: process
C  Remarks: none
C----------------------------------------------------------------------------


      integer function duf2im(hdim,vdim,max,min,hscale,vscale,data,
     *                palette,outfile,ct_method,hres,vres,compress)

      integer       hdim, vdim
      real          max, min, hscale, vscale, data
      character*(*) palette
      character*(*) outfile
      integer       ct_method, hres, vres, compress

      duf2im = duif2i(hdim,vdim,max,min,hscale,vscale,data,palette,
     *              outfile,ct_method,hres,vres,compress, len(outfile))        
      return
      end

CEND7MAX

C------------------------------------------------------------------------------
C Name:     dfufptoimage
C Purpose:   call duif2i_ to invoke DFUfptoimage()
C Inputs:   
C      hdim, vdim: horizontal and vertical dimensions of input data
C      max, min:   maximum and minimum values in the data
C      hscale,vscale: optional horizontal and vertical scales
C      data:       input data
C      palette:    optional palette to be stored with the image
C      outfile:n   name of hdf file to store image in
C      ct_method:  color transform method: 1=EXPAND; 2=INTERP
C      hres, vres: resolutions desired for output image
C      compress:   compression flag: 0=don't; 1=do
C  Returns: 0 on success, -1 on failure with DFerror set
C  Users:       HDF HLL (high-level library) users, utilities, other routines
C  Invokes: process
C  Remarks: none
C----------------------------------------------------------------------------


      integer function dfufptoimage(hdim,vdim,max,min,hscale,vscale,
     *           data, palette,outfile,ct_method,hres,vres,compress)

      integer       hdim, vdim
      real          max, min, hscale, vscale, data
      character*(*) palette
      character*(*) outfile
      integer       ct_method, hres, vres, compress

      dfufptoimage = 
     *             duif2i(hdim,vdim,max,min,hscale,vscale,data,palette,
     *              outfile,ct_method,hres,vres,compress, len(outfile))        
      return
      end

