C*****************************************************************************
C 
C			  NCSA HDF version 3.10r5
C			     October 24, 1991
C
C NCSA HDF Version 3.10r5 source code and documentation are in the public
C domain.  Specifically, we give to the public domain all rights for future
C licensing of the source code, all resale rights, and all publishing rights.
C 
C We ask, but do not require, that the following message be included in all
C derived works:
C 
C Portions developed at the National Center for Supercomputing Applications at
C the University of Illinois at Urbana-Champaign.
C 
C THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
C SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
C WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
C 
C****************************************************************************/
C
C $Header: /pita/work/HDF/dev/RCS/src/scup32.f,v 1.3 1991/10/23 22:14:26 sxu beta $
C
C $Log: scup32.f,v $
c Revision 1.3  1991/10/23  22:14:26  sxu
c A bug in odd is fixed.
c
c Revision 1.2  91/10/22  17:56:10  dilg
c 5
c HDF3.1r5
c 
c New machine types added:
c 
c         PC      - IBM PC (DOS)
c         WIN     - IBM PC (Microsoft Windows 3.0)
c         IBM6000 - IBM RS/6000 (AIX)
c         CONVEX  - Convex C-2 (Unix)
c 
c Bugs fixed in:
c 
c         scup32.f
c         cspck32.f
c         dfpFf.f
c         dfpF.c
c         dfsd.c
c 
c New utility added:
c 
c         ristosds.c - convert raster images to sds.
c 
c Also:
c         All code for the library was modified to conform to the
c         ANSI C standard.
c 
c Revision 1.1  1990/03/29  10:06:40  pwebb
c Initial revision
c
C
C Copyright (C) 1988
C The Board of Trustees of the University of Illiniois at Urbana-Champaign
C
C No warranty is expressed or implied.
C Permission is hereby granted to copy and distribute this material without
C charge provided that this NOTICE is retained.
C
C This material was developed at
C The National Center for Supercomputing Applications.
C Author:   Mark Straka
C-
C   Sun_to_Cray_32-bit_Floating-point (with unpacking) conversion routine.
C   USAGE:   call scup32 (sarray, carray, size)
C   WHERE    sarray is the array of 32-bit IEEE floating-point numbers
C            (packed 2 per word) to be converted 64-bit Cray format
C            and stored in carray.  Size is the dimension
C            of the output carray.  (sarray is assumed to be (size+1)/2 ).
C            Icheck is not used.

C
       subroutine scup32 (sarray,carray,size,icheck)
       integer size,sarray(0:(size+1)/2-1),carray(0:size-1),temp,odd

cdir$ ivdep

       odd=AND(size,x'0000000000000001') 

15     do 16 i=0,(size+1)/2-2
          carray(2*i)=AND(sarray(i),x'ffffffff00000000')
          carray(2*i+1)=shiftl(sarray(i),32)
16     continue

       carray(2*i)=AND(sarray((size+1)/2 -1),x'ffffffff00000000')
C      Size is even
       if (odd .EQ. 0) then  
			carray(2*i+1)=shiftl(sarray(i),32)
       end if
C

18     do 20 i=0,size-1
          temp=carray(i)
          carray(I)=or(or(and(carray(I),X'8000000000000000'),SHIFTR
     &      (AND(carray(I),X'7F80000000000000'),7)+shiftl(16258,48)),or(
     &shiftr(AND(carray(I),X'007FFFFF00000000'),8),X'0000800000000000'))
          carray(i)=cvmgn(carray(i),0,shiftl(temp,1))
20     continue
       end




