/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 3.1 $";
#endif
/*
$Header: /pita/work/HDF/dev/RCS/src/srtohdf.c,v 3.1 1991/10/22 17:56:10 dilg beta $

$Log: srtohdf.c,v $
 * Revision 3.1  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.0  1990/02/02  20:31:23  clow
 * *** empty log message ***
 *
*/
/*****************************************************************************
* 
*			  NCSA HDF version 3.00
*				December, 1989
*
* NCSA HDF Version 3.00 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/

/*
*  sunrastohdf.c
*  Encoding of Sunraster images in HDF files
*/

#include <rasterfile.h>
#include <sys/file.h>
#include <errno.h>
#include "df.h"

unsigned char *space, *convspace, *line;
unsigned char newfn[256];
unsigned char palspace[1024],
        reds[256],
        greens[256],
        blues[256];

int infile;

struct rasterfile sunras;

int32 rows,cols;

#if defined __STDC__ || defined PC
int main(int, char **);
int palconv(int, int, char *);
#else
int main();
int palconv();
#endif /* __STDC__ || PC */

#if defined __STDC__ || defined PC
main(int argc, char *argv) 
#else
main(argc,argv) 
int argc;
char *argv[];
#endif /* __STDC__ || PC */
{
    int i, j, argtype=0, infilearg=0, outfilearg=0, ret, readlen, encoded=0;
    int compress=0, csp=0, bitval;  /* csp = current position in convspace */

    if (argc < 2) { 
        printf("%s,  version: 0.8   date: May 3, 1989\n",argv[0]);
        printf("   This utility converts one or more Sun raster images to\n");
        printf("   HDF RIS8 format and adds them to an HDF file.\n\n");
        puts("Usage:");
        printf("   %s {[-r],[-c],[-i]} infile outfile\n", argv[0]);
        puts("   -r: Store without compression (default)");
        puts("   -c: Store using RLE compression");
        puts("   -i: Store using IMCOMP compression");
        exit(1);
    }

    for (i=1; i<argc; i++) {
        if (*argv[i]=='-') {
            switch (argv[i][1]) {
                case 'r':               /* raster */
                    compress=0;
                    break;
                case 'c':               /* RLE */
                    compress = DFTAG_RLE;
                    break;
                case 'i':               /* IMCOMP */
                    compress=DFTAG_IMC;
                    break;
                default:
                    printf("Illegal option: %s, skipping....\n",argv[i]);   
                    break;
            }
        }
        else { /* file name */
            if (argtype==0) infilearg = i;
            else if (argtype==1) outfilearg = i;
            else {
                printf("Too many arguments: %s.  Exiting\n", argv[i]);
                printf("Usage: %s {[-r],[-c],[-i]} infile outfile\n", argv[0]);
                exit(1);
            }
            argtype++;
        }
    }

    if (infilearg==0) {
        printf("Missing input file name.  Exiting\n");
        printf("Usage: %s {[-r],[-c],[-i]} infile outfile\n", argv[0]);
        exit(1);
    }
    if (outfilearg==0) {
        printf("Missing output file name.  Exiting\n");
        printf("Usage: %s {[-r],[-c],[-i]} infile outfile\n", argv[0]);
        exit(1);
    }
    
    infile = open(argv[infilearg], O_RDONLY);
    if (infile<0) {
        perror(argv[0]);
        printf("Error opening file %s. Exiting\n",argv[infilearg]);
        exit(1);
    }
            
    ret = read(infile, (unsigned char *) &sunras, sizeof(struct rasterfile));
    if (ret<=0) {
        perror(argv[0]);
        printf("Error reading from file %s. Exiting\n",argv[infilearg]);
        exit(1);
    }

    if (sunras.ras_magic != RAS_MAGIC) {
        printf("Not Sun raster file: %s.  Exiting\n",argv[infilearg]);
        exit(1);
    }

    cols = sunras.ras_width;
    rows = sunras.ras_height;
        
    if (sunras.ras_maptype == RMT_RAW) {
        printf("Unimplemented raw map type.  Exiting\n");
        exit(1);
    }
    if (sunras.ras_maptype == RMT_EQUAL_RGB) {
        if (sunras.ras_maplength != 768) {
            printf("Warning: palette length = %d, not 768.\n",
                                            sunras.ras_maplength);
            printf("Palette padded with NULLs, or excess bytes discarded.\n");
        }
        palconv(infile, (sunras.ras_maplength/3), argv[infilearg]);
    }

    if (NULL == (line = (unsigned char *) malloc(cols+2))) {
        puts("Not enough memory to convert image");
        exit(1);
    }

    if (NULL == (space = (unsigned char *) malloc(rows*cols))) {
        puts("Not enough memory to convert image. Exiting");
        exit(1);
    }

    if (sunras.ras_type==RT_BYTE_ENCODED) encoded = 1;
        
    if (encoded) {
        if (NULL == (convspace = (unsigned char *)malloc(sunras.ras_length))) {
            puts("Not enough memory to convert compressed image. Exiting");
            exit(1);
        }
        ret = read(infile, convspace, sunras.ras_length);
        if (ret<=0) {
            perror(argv[0]);
            printf("Error reading from file %s. Exiting\n",argv[infilearg]);
            exit(1);
        }
    }

    if (sunras.ras_depth==1) readlen = ((cols+15) / 16) * 2;
        /* Note: This takes care of padding to multiple of 16 bits,
            then converts to bytes.  INTEGER ARITHMETIC - do not simplify */
    else readlen = ((cols + 1) / 2 ) * 2;   /* ditto */

    for (i=0; i<rows; i++) {
        if (encoded) {
            ret = DFCunrle(&convspace[csp], line, readlen, !csp);
            if (ret<0) {
                printf("HDF Error %d on decompression.  Exiting\n", DFerror);
                exit(1);
            }
            csp += ret;
        }
        else {
            ret = read(infile, line, readlen);
            if (ret<=0) {
                perror(argv[0]);
                printf("Error reading from file %s. Exiting\n",argv[infilearg]);
                exit(1);
            }
        }
        
        if (sunras.ras_depth==1) {
            for (j=0; j<cols; j++) {
                bitval = line[j/8] & (1 << (7 - (j%8))); /* bit extraction */
                space[i*cols+j] = bitval ? 255 : 0;
            }
        }
        else DFmovmem(line, &space[i*cols], cols);
    }

    ret = DFR8addimage(argv[outfilearg], space, cols, rows, compress);
    if (ret < 0) {
        printf("HDF error: %d, in writing image to %s. Exiting\n", DFerror,
                                                            argv[outfilearg]);
        exit(1);
    }
    return(0);
}

/*
 *  palconv(file, len) sets the palette
 */

#if defined __STDC__ || defined PC
palconv(int palfile, int len, char *palfilename)
#else
palconv(palfile, len, palfilename)
int palfile;
int len;
char *palfilename;
#endif /* __STDC__ || PC */
{
    unsigned char *p;
    int j,ret;

    if (len<256) {
        ret = read(palfile, reds, len);
        for (j=len; j<256; j++) reds[j] = 0;
    }
    else ret = read(palfile, reds, 256);
    if (ret<=0) {
        perror("palconv");
        printf("Error reading from file %s. Exiting\n",palfilename);
        exit(1);
    }
    if (len>256) ret = lseek(palfile, len-256, 1);
    if (ret<0) {
        perror("palconv");
        printf("Error on seek in file %s. Exiting\n",palfilename);
        exit(1);
    }
    if (len<256) {
        ret = read(palfile, greens, len);
        for (j=len; j<256; j++) reds[j] = 0;
    }
    else ret = read(palfile, greens, 256);
    if (ret<=0) {
        perror("palconv");
        printf("Error reading from file %s. Exiting\n",palfilename);
        exit(1);
    }
    if (len>256) ret = lseek(palfile, len-256, 1);
    if (ret<0) {
        perror("palconv");
        printf("Error on seek in file %s. Exiting\n",palfilename);
        exit(1);
    }
    if (len<256) {
        ret = read(palfile, blues, len);
        for (j=len; j<256; j++) reds[j] = 0;
    }
    else ret = read(palfile, blues, 256);
    if (ret<=0) {
        perror("palconv");
        printf("Error reading from file %s. Exiting\n",palfilename);
        exit(1);
    }
    if (len>256) ret = lseek(palfile, len-256, 1);
    if (ret<0) {
        perror("palconv");
        printf("Error on seek in file %s. Exiting\n",palfilename);
        exit(1);
    }

    p = palspace;
    for (j=0; j<256; j++) {
        *p++ = reds[j];
        *p++ = greens[j];
        *p++ = blues[j];
    }

    ret = DFR8setpalette(palspace);
    if (ret < 0) {
        printf(" HDF error: %d, in writing palette.\n",DFerror);
        exit(1);
    }
    return(0);
}
