/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.packing;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BasePackedOutputStream<T> {
    private final Class<T> type;
    private final int basesPerType;
    private final OutputStream targetOutputStream;
    private final ByteBuffer buffer;

    public BasePackedOutputStream(Class<T> type, File outputFile, ByteOrder byteOrder) throws FileNotFoundException {
        this(type, new BufferedOutputStream(new FileOutputStream(outputFile)), byteOrder);
    }

    public BasePackedOutputStream(Class<T> type, OutputStream outputStream, ByteOrder byteOrder) {
        this.targetOutputStream = outputStream;
        this.type = type;
        this.basesPerType = PackUtils.bitsInType(type) / PackUtils.BITS_PER_BASE;
        this.buffer = ByteBuffer.allocate(this.basesPerType / 4).order(byteOrder);
    }

    public void write(int base) throws IOException {
        this.write(new byte[]{(byte)base});
    }

    public void write(byte[] bases) throws IOException {
        this.write(bases, 0, bases.length);
    }

    public void write(byte[] bases, int offset, int length) throws IOException {
        int packedBases = 0;
        int positionInPack = 0;
        for (int base = offset; base < offset + length; ++base) {
            packedBases = this.packBase(bases[base], packedBases, positionInPack);
            ++positionInPack;
            if ((positionInPack %= this.basesPerType) != 0) continue;
            this.writePackedBases(packedBases);
            packedBases = 0;
        }
        if (positionInPack > 0) {
            this.writePackedBases(packedBases);
        }
    }

    public void flush() throws IOException {
        this.targetOutputStream.flush();
    }

    public void close() throws IOException {
        this.targetOutputStream.close();
    }

    private int packBase(byte base, int basePack, int position) {
        return basePack |= PackUtils.packBase(base) << 2 * (this.basesPerType - position - 1);
    }

    private void writePackedBases(int packedBases) throws IOException {
        this.buffer.rewind();
        if (this.type == Integer.class) {
            this.buffer.putInt(packedBases);
        } else if (this.type == Byte.class) {
            this.buffer.put((byte)packedBases);
        } else {
            throw new ReviewedStingException("Cannot pack bases into type " + this.type.getName());
        }
        this.targetOutputStream.write(this.buffer.array());
    }
}

