/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.contexts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMReadGroupRecord;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;

public class AlignmentContextUtils {
    private AlignmentContextUtils() {
    }

    public static AlignmentContext stratify(AlignmentContext context, ReadOrientation type) {
        switch (type) {
            case COMPLETE: {
                return context;
            }
            case FORWARD: {
                return new AlignmentContext(context.getLocation(), context.getPileup().getPositiveStrandPileup());
            }
            case REVERSE: {
                return new AlignmentContext(context.getLocation(), context.getPileup().getNegativeStrandPileup());
            }
        }
        throw new ReviewedStingException("Unable to get alignment context for type = " + (Object)((Object)type));
    }

    public static Map<String, AlignmentContext> splitContextBySampleName(AlignmentContext context) {
        return AlignmentContextUtils.splitContextBySampleName(context, null);
    }

    public static Map<String, AlignmentContext> splitContextBySampleName(AlignmentContext context, String assumedSingleSample) {
        GenomeLoc loc = context.getLocation();
        HashMap<String, AlignmentContext> contexts = new HashMap<String, AlignmentContext>();
        for (String sample : context.getPileup().getSamples()) {
            ReadBackedPileup pileupBySample = context.getPileup().getPileupForSample(sample);
            if (pileupBySample.getNumberOfElements() == 0) continue;
            if (sample != null) {
                contexts.put(sample, new AlignmentContext(loc, pileupBySample));
                continue;
            }
            if (assumedSingleSample == null) {
                throw new UserException.ReadMissingReadGroup(((PileupElement)pileupBySample.iterator().next()).getRead());
            }
            contexts.put(assumedSingleSample, new AlignmentContext(loc, pileupBySample));
        }
        return contexts;
    }

    public static Map<SAMReadGroupRecord, AlignmentContext> splitContextByReadGroup(AlignmentContext context, Collection<SAMReadGroupRecord> readGroups) {
        HashMap<SAMReadGroupRecord, AlignmentContext> contexts = new HashMap<SAMReadGroupRecord, AlignmentContext>();
        for (SAMReadGroupRecord rg : readGroups) {
            ReadBackedPileup rgPileup = context.getBasePileup().getPileupForReadGroup(rg.getReadGroupId());
            if (rgPileup == null) continue;
            contexts.put(rg, new AlignmentContext(context.getLocation(), rgPileup));
        }
        return contexts;
    }

    public static Map<String, AlignmentContext> splitContextBySampleName(ReadBackedPileup pileup) {
        return AlignmentContextUtils.splitContextBySampleName(new AlignmentContext(pileup.getLocation(), pileup));
    }

    public static AlignmentContext joinContexts(Collection<AlignmentContext> contexts) {
        GenomeLoc loc = contexts.iterator().next().getLocation();
        for (AlignmentContext context : contexts) {
            if (loc.equals(context.getLocation())) continue;
            throw new ReviewedStingException("Illegal attempt to join contexts from different genomic locations");
        }
        ArrayList<PileupElement> pe = new ArrayList<PileupElement>();
        for (AlignmentContext context : contexts) {
            for (PileupElement pileupElement : context.basePileup) {
                pe.add(pileupElement);
            }
        }
        return new AlignmentContext(loc, new ReadBackedPileupImpl(loc, (List<PileupElement>)pe));
    }

    public static enum ReadOrientation {
        COMPLETE,
        FORWARD,
        REVERSE;

    }
}

