/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.downsampling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.downsampling.ReadsDownsampler;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ReservoirDownsampler<T extends SAMRecord>
implements ReadsDownsampler<T> {
    private ArrayList<T> reservoir;
    private int targetSampleSize;
    private int totalReadsSeen;

    public ReservoirDownsampler(int targetSampleSize) {
        if (targetSampleSize <= 0) {
            throw new ReviewedStingException("Cannot do reservoir downsampling with a sample size <= 0");
        }
        this.targetSampleSize = targetSampleSize;
        this.clear();
    }

    @Override
    public void submit(T newRead) {
        ++this.totalReadsSeen;
        if (this.totalReadsSeen <= this.targetSampleSize) {
            this.reservoir.add(newRead);
        } else {
            int randomSlot = GenomeAnalysisEngine.getRandomGenerator().nextInt(this.totalReadsSeen);
            if (randomSlot < this.targetSampleSize) {
                this.reservoir.set(randomSlot, newRead);
            }
        }
    }

    @Override
    public void submit(Collection<T> newReads) {
        for (SAMRecord read : newReads) {
            this.submit((T)read);
        }
    }

    @Override
    public boolean hasDownsampledItems() {
        return this.reservoir.size() > 0;
    }

    @Override
    public List<T> consumeDownsampledItems() {
        ArrayList<T> downsampledItems = this.reservoir;
        this.clear();
        return downsampledItems;
    }

    @Override
    public boolean hasPendingItems() {
        return false;
    }

    @Override
    public void signalEndOfInput() {
    }

    @Override
    public void clear() {
        this.reservoir = new ArrayList(this.targetSampleSize);
        this.totalReadsSeen = 0;
    }

    @Override
    public boolean requiresCoordinateSortOrder() {
        return false;
    }
}

