/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.regex.Pattern;
import org.broadinstitute.sting.gatk.filters.PlatformUnitFilter;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;

public class PlatformUnitFilterHelper {
    public static final Pattern EMPTYLINE_PATTERN = Pattern.compile("^\\s*$");

    public PlatformUnitFilterHelper(String arg) {
        File f = new File(arg);
        if (f.exists()) {
            try {
                XReadLines reader = new XReadLines(f);
                for (String line : reader) {
                    if (EMPTYLINE_PATTERN.matcher(line).matches()) continue;
                    PlatformUnitFilter.addBlackListedLane(line);
                }
            }
            catch (FileNotFoundException e) {
                throw new UserException.CouldNotReadInputFile(f, (Exception)e);
            }
            return;
        }
        PlatformUnitFilter.setBlackListedLanes(arg);
    }
}

