/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.samples;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class SampleDB {
    private final HashMap<String, Sample> samples = new HashMap();

    protected SampleDB addSample(Sample sample) {
        Sample prev = this.samples.get(sample.getID());
        if (prev != null) {
            sample = Sample.mergeSamples(prev, sample);
        }
        this.samples.put(sample.getID(), sample);
        return this;
    }

    public Sample getSample(String id) {
        return this.samples.get(id);
    }

    public Sample getSample(SAMRecord read) {
        return this.getSample(read.getReadGroup());
    }

    public Sample getSample(SAMReadGroupRecord rg) {
        return this.getSample(rg.getSample());
    }

    public Sample getSample(Genotype g) {
        return this.getSample(g.getSampleName());
    }

    public int sampleCount() {
        return this.samples.size();
    }

    public Set<Sample> getSamples() {
        return new HashSet<Sample>(this.samples.values());
    }

    public Collection<String> getSampleNames() {
        return Collections.unmodifiableCollection(this.samples.keySet());
    }

    public Set<Sample> getSamples(Collection<String> sampleNameList) {
        HashSet<Sample> samples = new HashSet<Sample>();
        for (String name : sampleNameList) {
            try {
                samples.add(this.getSample(name));
            }
            catch (Exception e) {
                throw new StingException("Could not get sample with the following ID: " + name, e);
            }
        }
        return samples;
    }

    public final Set<String> getFamilyIDs() {
        return this.getFamilies().keySet();
    }

    public final Map<String, Set<Sample>> getFamilies() {
        return this.getFamilies(null);
    }

    public final Map<String, Set<Sample>> getFamilies(Collection<String> sampleIds) {
        TreeMap<String, Set<Sample>> families = new TreeMap<String, Set<Sample>>();
        for (Sample sample : this.samples.values()) {
            String famID;
            if (sampleIds != null && !sampleIds.contains(sample.getID()) || (famID = sample.getFamilyID()) == null) continue;
            if (!families.containsKey(famID)) {
                families.put(famID, new TreeSet());
            }
            ((Set)families.get(famID)).add(sample);
        }
        return families;
    }

    public final Set<Sample> getChildrenWithParents() {
        return this.getChildrenWithParents(false);
    }

    public final Set<Sample> getChildrenWithParents(boolean triosOnly) {
        Map<String, Set<Sample>> families = this.getFamilies();
        HashSet<Sample> childrenWithParents = new HashSet<Sample>();
        for (Set<Sample> familyMembers : families.values()) {
            if (triosOnly && familyMembers.size() != 3) continue;
            for (Sample sample : familyMembers) {
                if (sample.getParents().size() != 2 || !familyMembers.containsAll(sample.getParents())) continue;
                childrenWithParents.add(sample);
            }
        }
        return childrenWithParents;
    }

    public Set<Sample> getFamily(String familyId) {
        return this.getFamilies().get(familyId);
    }

    public Set<Sample> getChildren(Sample sample) {
        HashSet<Sample> children = new HashSet<Sample>();
        for (Sample familyMember : this.getFamily(sample.getFamilyID())) {
            if (familyMember.getMother() != sample && familyMember.getFather() != sample) continue;
            children.add(familyMember);
        }
        return children;
    }

    public Set<String> getFounderIds() {
        HashSet<String> founders = new HashSet<String>();
        for (Sample sample : this.getSamples()) {
            if (sample.getParents().size() >= 1) continue;
            founders.add(sample.getID());
        }
        return founders;
    }
}

